/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.propbank.verbnet;

import com.googlecode.clearnlp.propbank.PBArg;
import com.googlecode.clearnlp.propbank.PBInstance;
import com.googlecode.clearnlp.propbank.PBLib;
import com.googlecode.clearnlp.propbank.verbnet.PVRole;
import com.googlecode.clearnlp.util.UTXml;
import java.util.ArrayList;
import java.util.Collections;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PVRoles
extends ArrayList<PVRole> {
    public static final String ATTR_VNCLS = "vncls";
    public static final String DELIM = ";";
    String s_vncls;

    public PVRoles(Element eRoles, String vncls) {
        NodeList list = eRoles.getElementsByTagName("role");
        int size = list.getLength();
        this.s_vncls = vncls;
        for (int i = 0; i < size; ++i) {
            this.add(new PVRole((Element)list.item(i)));
        }
    }

    public PVRoles(NodeList nRoles, String vncls) {
        int size = nRoles.getLength();
        this.s_vncls = vncls;
        for (int i = 0; i < size; ++i) {
            Element eRole = (Element)nRoles.item(i);
            String vntheta = this.getVntheta(eRole.getElementsByTagName("vnrole"), vncls);
            if (vntheta.isEmpty()) continue;
            String n = UTXml.getTrimmedAttribute(eRole, "n");
            String f = UTXml.getTrimmedAttribute(eRole, "f");
            this.add(new PVRole(n, f, vntheta));
        }
    }

    private String getVntheta(NodeList nVnroles, String vncls) {
        int size = nVnroles.getLength();
        for (int i = 0; i < size; ++i) {
            Element eVnrole = (Element)nVnroles.item(i);
            String cls = UTXml.getTrimmedAttribute(eVnrole, ATTR_VNCLS);
            if (!cls.equals(vncls)) continue;
            return UTXml.getTrimmedAttribute(eVnrole, "vntheta");
        }
        return "";
    }

    public void addVBRoles(PBInstance instance) {
        instance.roleset = instance.roleset + DELIM + this.s_vncls;
        for (PBArg pbArg : instance.getArgs()) {
            PVRole pvRole = this.getRole(pbArg);
            if (pvRole == null) continue;
            pbArg.label = pbArg.label + DELIM + pvRole.vntheta;
        }
    }

    public PVRole getRole(PBArg pbArg) {
        if (PBLib.isNumberedArgument(pbArg)) {
            for (PVRole pvRole : this) {
                if (!pvRole.isArgN(pbArg.label)) continue;
                return pvRole;
            }
        }
        return null;
    }

    public PVRole getRole(String n) {
        for (PVRole role : this) {
            if (!role.n.equals(n)) continue;
            return role;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder build = new StringBuilder();
        Collections.sort(this);
        for (PVRole pvRole : this) {
            build.append("\n");
            build.append("      ");
            build.append(pvRole);
        }
        return UTXml.getTemplate("roles", build.substring(1), "    ", ATTR_VNCLS, this.s_vncls);
    }
}

