/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.propbank.verbnet;

import com.googlecode.clearnlp.propbank.verbnet.PVRoleset;
import com.googlecode.clearnlp.util.UTXml;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PVVerb
extends HashMap<String, PVRoleset> {
    public static final String ATTR_LEMMA = "lemma";
    String s_lemma;

    public PVVerb(Element eVerb, String lemma, boolean fromMap) {
        NodeList list = eVerb.getElementsByTagName("roleset");
        int size = list.getLength();
        this.s_lemma = lemma;
        for (int i = 0; i < size; ++i) {
            String rolesetId;
            Element eRoleset = (Element)list.item(i);
            PVRoleset pvRoleset = new PVRoleset(eRoleset, rolesetId = UTXml.getTrimmedAttribute(eRoleset, "id"), fromMap);
            if (pvRoleset.isEmpty()) continue;
            this.put(rolesetId, pvRoleset);
        }
    }

    @Override
    public String toString() {
        ArrayList rolesetIds = new ArrayList(this.keySet());
        Collections.sort(rolesetIds);
        StringBuilder build = new StringBuilder();
        for (String rolesetId : rolesetIds) {
            build.append("\n");
            build.append(this.get(rolesetId));
        }
        return UTXml.getTemplate("verb", build.substring(1), "", ATTR_LEMMA, this.s_lemma);
    }
}

