/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.reader;

import com.googlecode.clearnlp.pos.POSNode;
import com.googlecode.clearnlp.reader.AbstractColumnReader;
import java.util.List;

public class POSReader
extends AbstractColumnReader<POSNode[]> {
    private int i_form;
    private int i_pos;

    public POSReader(int iForm, int iPos) {
        this.init(iForm, iPos);
    }

    public void init(int iForm, int iPos) {
        this.i_form = iForm;
        this.i_pos = iPos;
    }

    @Override
    public POSNode[] next() {
        POSNode[] nodes = null;
        try {
            List<String[]> lines = this.readLines();
            if (lines == null) {
                return null;
            }
            int size = lines.size();
            nodes = new POSNode[size];
            for (int i = 0; i < size; ++i) {
                String[] tmp = lines.get(i);
                String form = tmp[this.i_form];
                nodes[i] = this.i_pos < 0 ? new POSNode(form) : new POSNode(form, tmp[this.i_pos]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nodes;
    }

    @Override
    public String getType() {
        return "pos";
    }
}

