/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.pos.POSLib;
import com.googlecode.clearnlp.pos.POSNode;
import com.googlecode.clearnlp.reader.POSReader;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.UTXml;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.w3c.dom.Element;

public class MPAnalyze
extends AbstractRun {
    @Option(name="-c", usage="configuration file (required)", required=true, metaVar="<filename>")
    protected String s_configFile;
    @Option(name="-i", usage="input path (required)", required=true, metaVar="<filepath>")
    protected String s_inputPath;
    @Option(name="-ie", usage="input file extension (default: .*)", required=false, metaVar="<regex>")
    protected String s_inputExt = ".*";
    @Option(name="-oe", usage="output file extension (default: morph)", required=false, metaVar="<string>")
    protected String s_outputExt = "morph";

    public MPAnalyze(String[] args) {
        this.initArgs(args);
        try {
            Element eConfig = UTXml.getDocumentElement(new FileInputStream(this.s_configFile));
            POSReader reader = (POSReader)this.getReader((Element)eConfig).o1;
            AbstractMPAnalyzer analyzer = this.getMPAnalyzer(eConfig);
            List<String[]> filenames = this.getFilenames(this.s_inputPath, this.s_inputExt, this.s_outputExt);
            for (String[] io : filenames) {
                System.out.println(io[1]);
                this.analyze(analyzer, reader, io[0], io[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void analyze(AbstractMPAnalyzer analyzer, POSReader reader, String inputFile, String outputFile) {
        POSNode[] nodes;
        PrintStream fout = UTOutput.createPrintBufferedFileStream(outputFile);
        reader.open(UTInput.createBufferedFileReader(inputFile));
        while ((nodes = reader.next()) != null) {
            analyzer.lemmatize(nodes);
            fout.println(POSLib.toString(nodes, true) + "\n");
        }
        fout.close();
    }

    public static void main(String[] args) {
        new MPAnalyze(args);
    }
}

