/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import uk.co.flamingpenguin.jewel.cli.ArgumentCollection;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollectionBuilder;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;

class ArgumentParserImpl {
    private final ArgumentCollectionBuilder builder = new ArgumentCollectionBuilder();

    ArgumentParserImpl() {
    }

    public ArgumentCollection parseArguments(String ... arguments) throws ArgumentValidationException {
        for (String argument : arguments) {
            this.add(argument);
        }
        return this.getParsedArguments();
    }

    private void add(String argument) throws ArgumentValidationException {
        if (this.startsWithDash(argument) && !this.builder.isExpectingUnparsedOptions()) {
            if (this.startsWithDoubleDash(argument)) {
                if (argument.length() > 2) {
                    this.addOptionAndValue(argument);
                } else {
                    this.builder.unparsedOptionsFollow();
                }
            } else {
                this.addConjoinedOptions(argument.substring(1));
            }
        } else {
            this.addValue(argument);
        }
    }

    private void addConjoinedOptions(String options) throws ArgumentValidationException {
        for (int i = 0; i < options.length(); ++i) {
            this.addOption(options.substring(i, i + 1));
        }
    }

    private void addOptionAndValue(String argument) throws ArgumentValidationException {
        if (argument.contains("=")) {
            int separatorIndex = argument.indexOf("=");
            this.addOption(argument.substring(2, separatorIndex).trim());
            if (argument.length() > separatorIndex + 1) {
                this.addValue(argument.substring(separatorIndex + 1).trim());
            }
        } else {
            this.addOption(argument.substring(2, argument.length()).trim());
        }
    }

    private void addValue(String value) {
        this.builder.addValue(value);
    }

    private void addOption(String option) throws ArgumentValidationException {
        this.builder.addOption(option);
    }

    ArgumentCollection getParsedArguments() {
        return this.builder.getParsedArguments();
    }

    private boolean startsWithDash(String argument) {
        return argument.length() > 1 && argument.startsWith("-");
    }

    private boolean startsWithDoubleDash(String argument) {
        return argument.startsWith("--");
    }
}

