/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import uk.co.flamingpenguin.jewel.cli.Argument;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollection;
import uk.co.flamingpenguin.jewel.cli.ArgumentPresentingStrategy;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.ConvertTypeOfObject;
import uk.co.flamingpenguin.jewel.cli.Option;
import uk.co.flamingpenguin.jewel.cli.OptionSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.ParsedOptionSpecification;
import uk.co.flamingpenguin.jewel.cli.UnparsedOptionSpecification;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilder;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilderImpl;

class ArgumentPresenterImpl<O> {
    private final OptionsSpecification<O> specification;
    private final ArgumentPresentingStrategy<O> argumentPresentingStrategy;

    public ArgumentPresenterImpl(OptionsSpecification<O> specification, ArgumentPresentingStrategy<O> argumentPresentingStrategy) {
        this.specification = specification;
        this.argumentPresentingStrategy = argumentPresentingStrategy;
    }

    @Option
    public O presentArguments(ArgumentCollection validatedArguments) throws ArgumentValidationException {
        LinkedHashMap<String, Object> argumentMap = new LinkedHashMap<String, Object>();
        ValidationErrorBuilderImpl validationErrorBuilder = new ValidationErrorBuilderImpl();
        for (ParsedOptionSpecification optionSpecification : this.specification) {
            ConvertTypeOfObject convertTypeOfObject = ConvertTypeOfObject.converterTo((ValidationErrorBuilder)validationErrorBuilder, (OptionSpecification)optionSpecification, optionSpecification.getMethod());
            this.putDefaultInMap(argumentMap, optionSpecification, convertTypeOfObject);
            Argument argument = validatedArguments.getArgument(optionSpecification.getNames());
            if (argument == null) continue;
            this.putValuesInMap(argumentMap, optionSpecification, convertTypeOfObject, argument.getValues());
        }
        if (this.specification.hasUnparsedSpecification()) {
            UnparsedOptionSpecification unparsedSpecification = this.specification.getUnparsedSpecification();
            ConvertTypeOfObject convertTypeOfObject = ConvertTypeOfObject.converterTo((ValidationErrorBuilder)validationErrorBuilder, (OptionSpecification)unparsedSpecification, unparsedSpecification.getMethod());
            this.putDefaultInMap(argumentMap, unparsedSpecification, convertTypeOfObject);
            if (!validatedArguments.getUnparsed().isEmpty()) {
                this.putValuesInMap(argumentMap, unparsedSpecification, convertTypeOfObject, validatedArguments.getUnparsed());
            }
        }
        validationErrorBuilder.validate();
        return this.argumentPresentingStrategy.presentArguments(argumentMap);
    }

    private void putValuesInMap(Map<String, Object> argumentMap, OptionSpecification specification, ConvertTypeOfObject<?> convertTypeOfObject, List<String> values) {
        if (specification.isMultiValued()) {
            argumentMap.put(specification.getCanonicalIdentifier(), convertTypeOfObject.convert(values));
        } else if (!values.isEmpty()) {
            argumentMap.put(specification.getCanonicalIdentifier(), convertTypeOfObject.convert(values.get(0)));
        } else if (values.isEmpty()) {
            argumentMap.put(specification.getCanonicalIdentifier(), null);
        }
    }

    private void putDefaultInMap(Map<String, Object> argumentMap, OptionSpecification optionSpecification, ConvertTypeOfObject<?> convertTypeOfObject) {
        if (optionSpecification.isMultiValued() && optionSpecification.hasDefaultValue()) {
            argumentMap.put(optionSpecification.getCanonicalIdentifier(), convertTypeOfObject.convert(optionSpecification.getDefaultValue()));
        } else if (optionSpecification.hasDefaultValue() && optionSpecification.getDefaultValue().size() > 0) {
            argumentMap.put(optionSpecification.getCanonicalIdentifier(), convertTypeOfObject.convert(optionSpecification.getDefaultValue().get(0)));
        }
    }
}

