/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.smokingstatus.cc;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.ctakes.smokingstatus.patientLevel.PatientLevelSmokingStatus;
import org.apache.ctakes.smokingstatus.type.SmokingDocumentClassification;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JFSIndexRepository;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceProcessException;
import org.apache.uima.util.ProcessTrace;

public class RecordResolutionCasConsumer
extends CasConsumer_ImplBase {
    public static final String PARAM_OUTPUT_FILE = "OutputFile";
    public static final String PARAM_DELIMITER = "Delimiter";
    public static final String CDA_PROCESSING = "ProcessingCDADocument";
    public static final String PATIENT_LEVEL_PROCESSING = "RunPatientLevelClassification";
    public static final String FINAL_CLASS_FILE = "FinalClassificationOutputFile";
    private BufferedWriter iv_bw = null;
    private StringBuffer iv_sb;
    private String iv_patient_level_file = null;
    private String iv_delimiter;
    private static String NEW_LINE = System.getProperty("line.separator");
    private boolean iv_postPatientLvlProcess = false;
    private boolean iv_useCDAProcess = false;
    private PatientLevelSmokingStatus patientSmokingStatus = null;

    public void initialize() throws ResourceInitializationException {
        this.iv_sb = new StringBuffer();
        try {
            String filename = (String)this.getConfigParameterValue(PARAM_OUTPUT_FILE);
            File outFile = new File(filename);
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            this.iv_bw = new BufferedWriter(new FileWriter(outFile));
            this.iv_delimiter = (String)this.getConfigParameterValue(PARAM_DELIMITER);
            this.iv_useCDAProcess = (Boolean)this.getConfigParameterValue(CDA_PROCESSING);
            this.iv_postPatientLvlProcess = (Boolean)this.getConfigParameterValue(PATIENT_LEVEL_PROCESSING);
            this.iv_patient_level_file = (String)this.getConfigParameterValue(FINAL_CLASS_FILE);
            if (this.iv_postPatientLvlProcess) {
                this.patientSmokingStatus = new PatientLevelSmokingStatus();
                this.patientSmokingStatus.setInputFile(filename);
            }
        }
        catch (Exception ioe) {
            throw new ResourceInitializationException((Throwable)ioe);
        }
    }

    public void processCas(CAS cas) throws ResourceProcessException {
        try {
            JCas jcas = this.iv_useCDAProcess ? cas.getJCas().getView("plaintext") : cas.getJCas();
            JFSIndexRepository indexes = jcas.getJFSIndexRepository();
            FSIterator documentIDIterator = indexes.getAllIndexedFS(DocumentID.type);
            if (documentIDIterator.hasNext()) {
                DocumentID dia = (DocumentID)((Object)documentIDIterator.next());
                this.iv_sb.append(dia.getDocumentID());
            } else {
                this.iv_sb.append("Error in CasInitializer(?) NO_DOC_ID");
            }
            this.iv_sb.append(this.iv_delimiter);
            FSIterator docClsItr = indexes.getAnnotationIndex(SmokingDocumentClassification.type).iterator();
            if (docClsItr.hasNext()) {
                SmokingDocumentClassification dc = (SmokingDocumentClassification)((Object)docClsItr.next());
                this.iv_sb.append(dc.getClassification());
                this.iv_sb.append(NEW_LINE);
            } else {
                this.iv_sb.append("Error in RecordResolutionCasConsumer:NO classification");
            }
            this.iv_bw.write(this.iv_sb.toString());
        }
        catch (Exception exception) {
            throw new ResourceProcessException((Throwable)exception);
        }
        finally {
            this.iv_sb.delete(0, this.iv_sb.length());
        }
    }

    public void collectionProcessComplete(ProcessTrace arg0) throws ResourceProcessException, IOException {
        super.collectionProcessComplete(arg0);
        File outFile = null;
        try {
            this.iv_bw.flush();
            this.iv_bw.close();
        }
        catch (Exception e) {
            throw new ResourceProcessException((Throwable)e);
        }
        if (this.iv_postPatientLvlProcess) {
            String filename = (String)this.getConfigParameterValue(PARAM_OUTPUT_FILE);
            outFile = this.iv_patient_level_file != null ? new File(this.iv_patient_level_file) : new File(filename.replace(filename, filename + "_patientLevel.txt"));
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            this.patientSmokingStatus.setOutputFile(outFile.getAbsolutePath());
            PatientLevelSmokingStatus.collectCounts("\\" + this.iv_delimiter);
            RecordResolutionCasConsumer recordResolutionCasConsumer = this;
            recordResolutionCasConsumer.patientSmokingStatus.assignPatientLevelSmokingStatus();
            RecordResolutionCasConsumer recordResolutionCasConsumer2 = this;
            recordResolutionCasConsumer2.patientSmokingStatus.printToFile();
        }
    }
}

