/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dependency.parser.ae.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.ctakes.dependency.parser.ae.ClearNLPDependencyParserAE;
import org.apache.ctakes.dependency.parser.ae.ClearNLPSemanticRoleLabelerAE;
import org.apache.uima.UIMAException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.xml.sax.SAXException;

public class WriteClearNLPDescriptors {
    public static final String SIMPLE_SEGMENTER_PATH = "../ctakes-clinical-pipeline/desc/analysis_engine/SimpleSegmentAnnotator.xml";
    public static final String SENTENCE_DETECTOR_PATH = "../ctakes-core/desc/analysis_engine/SentenceDetectorAnnotator.xml";
    public static final String TOKENIZER_PATH = "../ctakes-core/desc/analysis_engine/TokenizerAnnotator.xml";
    public static final String LVG_BASE_TOKEN_ANNOTATOR_PATH = "desc/analysis_engine/LvgBaseTokenAnnotator.xml";
    public static final String POS_TAGGER_PATH = "../ctakes-pos-tagger/desc/POSTagger.xml";
    public static final String DEP_NAME = "ClearNLPDependencyParser";
    public static final String SRL_NAME = "ClearNLPSRL";

    public static void main(String[] args) throws IOException, UIMAException, SAXException, CmdLineException {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        TypeSystemDescription typeSystem = TypeSystemDescriptionFactory.createTypeSystemDescriptionFromPath((String[])new String[]{"../../../ctakes-type-system/src/main/resources/org/apache/ctakes/typesystem/types/TypeSystem.xml"});
        AnalysisEngineDescription ClearNLPSRLDesc = AnalysisEngineFactory.createEngineDescription(ClearNLPSemanticRoleLabelerAE.class, (TypeSystemDescription)typeSystem, (Object[])new Object[0]);
        AnalysisEngineDescription ClearNLPDepParserDesc = AnalysisEngineFactory.createEngineDescription(ClearNLPDependencyParserAE.class, (TypeSystemDescription)typeSystem, (Object[])new Object[0]);
        System.out.println(new File("desc/analysis_engine").getAbsolutePath());
        ClearNLPDepParserDesc.toXML((OutputStream)new FileOutputStream(new File(options.outputRoot, "ClearNLPDependencyParserAE.xml")));
        ClearNLPSRLDesc.toXML((OutputStream)new FileOutputStream(new File(options.outputRoot, "ClearNLPSemanticRoleLabelerAE.xml")));
        AggregateBuilder aggregateBuilder = WriteClearNLPDescriptors.getPlaintextAggregateBuilder();
        WriteClearNLPDescriptors.writeAggregateDescriptions(aggregateBuilder, ClearNLPDepParserDesc, ClearNLPSRLDesc, options.outputRoot, "PlaintextAggregate.xml");
        aggregateBuilder = WriteClearNLPDescriptors.getTokenizedAggregateBuilder();
        WriteClearNLPDescriptors.writeAggregateDescriptions(aggregateBuilder, ClearNLPDepParserDesc, ClearNLPSRLDesc, options.outputRoot, "TokenizedAggregate.xml");
        aggregateBuilder = WriteClearNLPDescriptors.getTokenizedInfPosAggregateBuilder();
        WriteClearNLPDescriptors.writeAggregateDescriptions(aggregateBuilder, ClearNLPDepParserDesc, ClearNLPSRLDesc, options.outputRoot, "TokenizedInfPosAggregate.xml");
    }

    public static AggregateBuilder getPlaintextAggregateBuilder() throws InvalidXMLException, IOException {
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(WriteClearNLPDescriptors.loadDescription(SIMPLE_SEGMENTER_PATH), new String[0]);
        aggregateBuilder.add(WriteClearNLPDescriptors.loadDescription(SENTENCE_DETECTOR_PATH), new String[0]);
        aggregateBuilder.add(WriteClearNLPDescriptors.loadDescription(TOKENIZER_PATH), new String[0]);
        aggregateBuilder.add(WriteClearNLPDescriptors.loadDescription(POS_TAGGER_PATH), new String[0]);
        return aggregateBuilder;
    }

    public static AggregateBuilder getTokenizedAggregateBuilder() throws InvalidXMLException, IOException {
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(WriteClearNLPDescriptors.loadDescription(SIMPLE_SEGMENTER_PATH), new String[0]);
        aggregateBuilder.add(WriteClearNLPDescriptors.loadDescription(LVG_BASE_TOKEN_ANNOTATOR_PATH), new String[0]);
        return aggregateBuilder;
    }

    public static AggregateBuilder getTokenizedInfPosAggregateBuilder() throws InvalidXMLException, IOException {
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(WriteClearNLPDescriptors.loadDescription(SIMPLE_SEGMENTER_PATH), new String[0]);
        aggregateBuilder.add(WriteClearNLPDescriptors.loadDescription(LVG_BASE_TOKEN_ANNOTATOR_PATH), new String[0]);
        aggregateBuilder.add(WriteClearNLPDescriptors.loadDescription(POS_TAGGER_PATH), new String[0]);
        return aggregateBuilder;
    }

    public static AnalysisEngineDescription loadDescription(String pathToDescription) throws IOException, InvalidXMLException {
        File file = new File(pathToDescription);
        XMLParser parser = UIMAFramework.getXMLParser();
        XMLInputSource source = new XMLInputSource(file);
        AnalysisEngineDescription desc = parser.parseAnalysisEngineDescription(source);
        return desc;
    }

    private static void writeAggregateDescriptions(AggregateBuilder preprocessing, AnalysisEngineDescription ClearNLPDepParserDesc, AnalysisEngineDescription ClearNLPSRLDesc, File outputRoot, String aggregateSuffix) throws ResourceInitializationException, FileNotFoundException, SAXException, IOException {
        preprocessing.add(ClearNLPDepParserDesc, new String[0]);
        preprocessing.createAggregateDescription().toXML((OutputStream)new FileOutputStream(new File(outputRoot, DEP_NAME + aggregateSuffix)));
        preprocessing.add(ClearNLPSRLDesc, new String[0]);
        preprocessing.createAggregateDescription().toXML((OutputStream)new FileOutputStream(new File(outputRoot, SRL_NAME + aggregateSuffix)));
    }

    public static class Options {
        @Option(name="-o", aliases={"--outputRoot"}, usage="specify the directory to write out descriptor files", required=false)
        public File outputRoot = new File("desc/analysis_engine");
        @Option(name="-m", aliases={"--modelFile"}, usage="specify the path to the relation extractor model jar file", required=false)
        public File modelFile = new File("model.jar");
    }
}

