/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.cr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.component.JCasCollectionReader_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.descriptor.SofaCapability;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.pear.util.FileUtil;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.cr.RegexFileFilter;

@SofaCapability(outputSofas={"UriView"})
public class FilesCollectionReader
extends JCasCollectionReader_ImplBase {
    public static final String PARAM_ROOT_FILE = "rootFile";
    @ConfigurationParameter(name="rootFile", mandatory=true, description="takes either the name of a single file or the root directory containing all the files to be processed.")
    protected File rootFile;
    public static final String PARAM_VIEW_NAME = "viewName";
    @ConfigurationParameter(name="viewName", mandatory=false, description="takes the the name that should be given to the JCas view that the document texts should be set to.", defaultValue={"_InitialView"})
    private String viewName;
    public static final String PARAM_LANGUAGE = "language";
    @ConfigurationParameter(name="language", mandatory=false, description="takes the language code corresponding to the language of the documents being examined.  The value of this parameter is simply passed on to JCas.setDocumentLanguage(String).")
    private String language;
    public static final String PARAM_ENCODING = "encoding";
    @ConfigurationParameter(name="encoding", mandatory=false, description="takes the encoding of the text files (e.g. \"UTF-8\").  See javadoc for java.nio.charset.Charset for a list of encoding names.")
    private String encoding;
    public static final String PARAM_SUFFIXES = "suffixes";
    @ConfigurationParameter(name="suffixes", mandatory=false, description="takes suffixes (e.g. .txt) of the files that should be read in.")
    private String[] suffixes;
    public static final String PARAM_PATTERNS = "patterns";
    @ConfigurationParameter(name="patterns", mandatory=false, description="\ttakes regular expressions for matching the files that should be read in. Note that these will be searched for using java.util. regex.Matcher.find, so if you want to make sure the entire file name matches a pattern, you should start the string with ^ and end the string with $.")
    private String[] patterns;
    public static final String PARAM_NAME_FILES_FILE_NAMES = "nameFilesFileNames";
    @ConfigurationParameter(name="nameFilesFileNames", mandatory=false, description="names files which contain lists of file names. For example, if the value 'mydata/mylist.txt' is provided, then the file 'mylist.txt' should contain a line delimited list of file names.  The file names in the list should not have directory information but should just be the names of the files. The directory is determined by 'rootFile' and the files that are processed result from traversing the directory structure provided and looking for files with a name found in the lists of file names. That is, no exception will be thrown if a file name in the list does not actually correspond to a file.")
    private String[] nameFilesFileNames;
    public static final String PARAM_FILE_NAMES = "fileNames";
    @ConfigurationParameter(name="fileNames", mandatory=false, description="provides a list of file names that should be read in. The directory of the file names is determined by 'rootFile' and the files that are processed result from traversing the directory structure provided and looking for files with a name found in the list of file names. That is, no exception will be thrown if a file name in the list does not actually correspond to a file.")
    private String[] fileNames;
    public static final String PARAM_IGNORE_SYSTEM_FILES = "ignoreSystemFiles";
    @ConfigurationParameter(name="ignoreSystemFiles", mandatory=false, description="This parameter provides a flag that determines whether file iteration will traverse into directories that begin with a period '.' - to loosely correspond to 'system' files.  Setting this parameter to true will not cause file names that begin with a period to be ignored - just directories. ")
    private boolean ignoreSystemFiles = true;
    protected Iterator<File> files;
    protected File currentFile;
    protected int completed = 0;
    protected int filesCount = 0;

    public static CollectionReaderDescription getDescription(String fileOrDir) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(FilesCollectionReader.class, null, (Object[])new Object[]{PARAM_ROOT_FILE, fileOrDir});
    }

    public static CollectionReader getCollectionReader(String fileOrDir) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader((CollectionReaderDescription)FilesCollectionReader.getDescription(fileOrDir), (Object[])new Object[0]);
    }

    public static CollectionReaderDescription getDescriptionWithView(String dir, String viewName) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(FilesCollectionReader.class, (Object[])new Object[]{PARAM_ROOT_FILE, dir, PARAM_VIEW_NAME, viewName});
    }

    public static CollectionReader getCollectionReaderWithView(String dir, String viewName) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader((CollectionReaderDescription)FilesCollectionReader.getDescriptionWithView(dir, viewName), (Object[])new Object[0]);
    }

    public static CollectionReaderDescription getDescriptionWithPatterns(String dir, String viewName, String ... patterns) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(FilesCollectionReader.class, (Object[])new Object[]{PARAM_ROOT_FILE, dir, PARAM_VIEW_NAME, viewName, PARAM_PATTERNS, patterns});
    }

    public static CollectionReader getCollectionReaderWithPatterns(String dir, String viewName, String ... patterns) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader((CollectionReaderDescription)FilesCollectionReader.getDescriptionWithPatterns(dir, viewName, patterns), (Object[])new Object[0]);
    }

    public static CollectionReaderDescription getDescriptionWithSuffixes(String dir, String viewName, String ... suffixes) throws ResourceInitializationException {
        return CollectionReaderFactory.createReaderDescription(FilesCollectionReader.class, (Object[])new Object[]{PARAM_ROOT_FILE, dir, PARAM_VIEW_NAME, viewName, PARAM_SUFFIXES, suffixes});
    }

    public static CollectionReader getCollectionReaderWithSuffixes(String dir, String viewName, String ... suffixes) throws ResourceInitializationException {
        return CollectionReaderFactory.createReader((CollectionReaderDescription)FilesCollectionReader.getDescriptionWithSuffixes(dir, viewName, suffixes), (Object[])new Object[0]);
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        if (!this.rootFile.exists()) {
            String format = "file or directory %s does not exist";
            String message = String.format(format, this.rootFile.getPath());
            throw new ResourceInitializationException((Throwable)new IOException(message));
        }
        if (this.rootFile.isFile()) {
            this.files = Arrays.asList(this.rootFile).iterator();
            this.filesCount = 1;
        } else {
            this.files = this.createFileIterator();
            this.filesCount = this.countFiles(this.createFileIterator());
        }
    }

    protected Iterator<File> createFileIterator() throws ResourceInitializationException {
        IOFileFilter fileFilter = TrueFileFilter.INSTANCE;
        if (this.suffixes != null) {
            fileFilter = new AndFileFilter(fileFilter, (IOFileFilter)new SuffixFileFilter(this.suffixes));
        }
        if (this.patterns != null && this.patterns.length > 0) {
            RegexFileFilter patternFilter = new RegexFileFilter(Pattern.compile(this.patterns[0]));
            if (this.patterns.length > 1) {
                for (int i = 1; i < this.patterns.length; ++i) {
                    patternFilter = new OrFileFilter((IOFileFilter)patternFilter, (IOFileFilter)new RegexFileFilter(this.patterns[i]));
                }
            }
            fileFilter = new AndFileFilter(fileFilter, (IOFileFilter)patternFilter);
        }
        if (this.nameFilesFileNames != null) {
            ArrayList<String> fileNamesFromLists = new ArrayList<String>();
            try {
                for (String fileNamesList : this.nameFilesFileNames) {
                    fileNamesFromLists.addAll(Arrays.asList(FileUtil.loadListOfStrings((File)new File(fileNamesList))));
                }
                fileFilter = new AndFileFilter(fileFilter, (IOFileFilter)new NameFileFilter(fileNamesFromLists));
            }
            catch (IOException ioe) {
                throw new ResourceInitializationException((Throwable)ioe);
            }
        }
        if (this.fileNames != null) {
            fileFilter = new AndFileFilter(fileFilter, (IOFileFilter)new NameFileFilter(this.fileNames));
        }
        Object directoryFilter = TrueFileFilter.INSTANCE;
        if (this.ignoreSystemFiles) {
            directoryFilter = new RegexFileFilter("^[^\\.].*$");
            fileFilter = new AndFileFilter(fileFilter, (IOFileFilter)new RegexFileFilter("^[^\\.].*$"));
        }
        return FileUtils.iterateFiles((File)this.rootFile, (IOFileFilter)fileFilter, (IOFileFilter)directoryFilter);
    }

    public void getNext(JCas jCas) throws IOException, CollectionException {
        JCas view;
        if (!this.hasNext()) {
            throw new RuntimeException("getNext(jCas) was called but hasNext() returns false");
        }
        try {
            view = ViewCreatorAnnotator.createViewSafely((JCas)jCas, (String)this.viewName);
        }
        catch (AnalysisEngineProcessException e) {
            throw new CollectionException((Throwable)e);
        }
        String text = org.apache.uima.util.FileUtils.file2String((File)this.currentFile, (String)this.encoding);
        view.setSofaDataString(text, "text/plain");
        if (this.language != null) {
            view.setDocumentLanguage(this.language);
        }
        ViewUriUtil.setURI(jCas, this.currentFile.toURI());
        ++this.completed;
        this.currentFile = null;
    }

    protected int countFiles(Iterator<File> tempFiles) {
        int count = 0;
        while (tempFiles.hasNext()) {
            File file = tempFiles.next();
            if (!file.isFile()) continue;
            ++count;
        }
        return count;
    }

    public Progress[] getProgress() {
        ProgressImpl progress = new ProgressImpl(this.completed, this.filesCount, "entities");
        return new Progress[]{progress};
    }

    public boolean hasNext() throws IOException, CollectionException {
        if (this.currentFile != null) {
            return true;
        }
        while (this.files.hasNext()) {
            this.currentFile = this.files.next();
            if (!this.currentFile.isFile()) continue;
            return true;
        }
        return false;
    }

    public void close() throws IOException {
    }
}

