/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.util.cr.linereader;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.uima.UimaContext;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.fit.component.initialize.ConfigurationParameterInitializer;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.cr.linereader.LineHandler;

public class SimpleLineHandler
implements LineHandler {
    public static final String PARAM_DELIMITER = "delimiter";
    @ConfigurationParameter(name="delimiter", mandatory=true, defaultValue={"|"}, description="specifies a string that delimits the id from the text. ")
    private String delimiter;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        ConfigurationParameterInitializer.initialize((Object)this, (UimaContext)context);
    }

    @Override
    public void handleLine(JCas jCas, File rootFile, File file, String line) throws IOException, CollectionException {
        URI uri;
        String id = line.substring(0, line.indexOf(this.delimiter));
        String text = line.substring(line.indexOf(this.delimiter) + 1);
        jCas.setSofaDataString(text, "text/plain");
        try {
            uri = new URI(String.format("%s#%s", file.toURI().toString(), id));
        }
        catch (URISyntaxException e) {
            throw new CollectionException((Throwable)e);
        }
        ViewUriUtil.setURI(jCas, uri);
    }
}

