/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.attributes.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.Chunk;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class GenericAttributeClassifier {
    private static final String POSTCOORD_NMOD = "donor_srlarg";
    private static final String DISCUSSION_DEPPATH = "discussion_deppath";
    private static final String SUBSUMED_CHUNK = "other_token";
    private static final String SUBSUMED_ANNOT = "other_deppath";
    public static ArrayList<String> FeatureIndex = new ArrayList();

    public static Boolean getGeneric(JCas jCas, IdentifiedAnnotation mention) {
        HashMap<String, Boolean> vfeat = GenericAttributeClassifier.extract(jCas, (Annotation)mention);
        return GenericAttributeClassifier.classifyWithLogic(vfeat);
    }

    public static Boolean classifyWithLogic(HashMap<String, Boolean> vfeat) {
        int subsumectr = 0;
        if (vfeat.get(SUBSUMED_CHUNK).booleanValue()) {
            // empty if block
        }
        if (vfeat.get(SUBSUMED_ANNOT).booleanValue()) {
            ++subsumectr;
        }
        if (vfeat.get(POSTCOORD_NMOD).booleanValue()) {
            ++subsumectr;
        }
        Boolean subsume_summary = subsumectr > 0;
        if (vfeat.get(DISCUSSION_DEPPATH).booleanValue() || subsume_summary.booleanValue()) {
            return true;
        }
        return false;
    }

    public static HashMap<String, Boolean> extract(JCas jCas, Annotation arg) {
        List depnodes;
        HashMap<String, Boolean> vfeat = new HashMap<String, Boolean>();
        for (String feat : FeatureIndex) {
            vfeat.put(feat, false);
        }
        Sentence sEntity = null;
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        for (Object s : sentences) {
            if (s.getBegin() > arg.getBegin() || s.getEnd() < arg.getEnd()) continue;
            sEntity = s;
            break;
        }
        if (sEntity != null) {
            Chunk chunk;
            IdentifiedAnnotation annot;
            Object s;
            List lsmentions = JCasUtil.selectPreceding((JCas)jCas, IdentifiedAnnotation.class, (AnnotationFS)arg, (int)5);
            lsmentions.addAll(JCasUtil.selectFollowing((JCas)jCas, IdentifiedAnnotation.class, (AnnotationFS)arg, (int)5));
            s = lsmentions.iterator();
            while (s.hasNext() && (annot = (IdentifiedAnnotation)s.next()).getBegin() <= arg.getBegin()) {
                if (annot.getEnd() < arg.getEnd() || DependencyUtility.equalCoverage((Annotation)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)annot), (Annotation)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)arg))) continue;
                vfeat.put(SUBSUMED_ANNOT, true);
            }
            List lschunks = JCasUtil.selectPreceding((JCas)jCas, Chunk.class, (AnnotationFS)arg, (int)5);
            lschunks.addAll(JCasUtil.selectFollowing((JCas)jCas, Chunk.class, (AnnotationFS)arg, (int)5));
            Iterator iterator = lschunks.iterator();
            while (iterator.hasNext() && (chunk = (Chunk)iterator.next()).getBegin() <= arg.getBegin()) {
                if (chunk.getEnd() < arg.getEnd() || DependencyUtility.equalCoverage((Annotation)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)chunk), (Annotation)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)arg))) continue;
                vfeat.put(SUBSUMED_CHUNK, true);
            }
        }
        if (!(depnodes = JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)arg)).isEmpty()) {
            ConllDependencyNode depnode = DependencyUtility.getNominalHeadNode((List)depnodes);
            if (depnode.getDeprel().matches("(NMOD|amod|nmod|det|predet|nn|poss|possessive|infmod|partmod|rcmod)")) {
                vfeat.put(POSTCOORD_NMOD, true);
            }
            for (ConllDependencyNode dn : DependencyUtility.getPathToTop((JCas)jCas, (ConllDependencyNode)depnode)) {
                if (!GenericAttributeClassifier.isDiscussionContext((Annotation)dn)) continue;
                vfeat.put(DISCUSSION_DEPPATH, true);
            }
        }
        return vfeat;
    }

    private static boolean isDonorTerm(Annotation arg) {
        return arg.getCoveredText().toLowerCase().matches("(donor).*");
    }

    private static boolean isDiscussionContext(Annotation arg) {
        return arg.getCoveredText().toLowerCase().matches("(discuss|ask|understand|understood|tell|told|mention|talk|speak|spoke|address).*");
    }

    public static void main(String[] args) {
        String s = "steps";
        if (s.toLowerCase().matches(".*(in-law|stepc|stepd|stepso|stepf|stepm|step-).*")) {
            System.out.println("match");
        } else {
            System.out.println("no match");
        }
    }

    static {
        FeatureIndex.add(POSTCOORD_NMOD);
        FeatureIndex.add(DISCUSSION_DEPPATH);
        FeatureIndex.add(SUBSUMED_CHUNK);
        FeatureIndex.add(SUBSUMED_ANNOT);
    }
}

