/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.attributes.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.Chunk;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;

public class HistoryAttributeClassifier {
    private static final String POSTCOORD_NMOD = "donor_srlarg";
    private static final String DISCUSSION_DEPPATH = "discussion_deppath";
    private static final String SUBSUMED_CHUNK = "other_token";
    private static final String SUBSUMED_ANNOT = "other_deppath";
    private static final String IN_HIST_SECTION = "in_history_section";
    public static ArrayList<String> FeatureIndex = new ArrayList();
    private static final String[] GHC_HIST_SECTIONS;

    public static Boolean getHistory(JCas jCas, IdentifiedAnnotation mention) {
        HashMap<String, Boolean> vfeat = HistoryAttributeClassifier.extract(jCas, (Annotation)mention);
        return HistoryAttributeClassifier.classifyWithLogic(vfeat);
    }

    public static Boolean precededByH_O(JCas jCas, Annotation arg) {
        Boolean answer = false;
        return answer;
    }

    public static Boolean classifyWithLogic(HashMap<String, Boolean> vfeat) {
        int subsumectr = 0;
        if (vfeat.get(SUBSUMED_CHUNK).booleanValue()) {
            // empty if block
        }
        if (vfeat.get(SUBSUMED_ANNOT).booleanValue()) {
            ++subsumectr;
        }
        if (vfeat.get(POSTCOORD_NMOD).booleanValue()) {
            ++subsumectr;
        }
        Boolean subsume_summary = subsumectr > 0;
        if (vfeat.get(DISCUSSION_DEPPATH).booleanValue() || subsume_summary.booleanValue()) {
            return true;
        }
        return false;
    }

    private static boolean isInHistSection(Sentence s) {
        String sText = s.getCoveredText().trim();
        for (String secStart : GHC_HIST_SECTIONS) {
            String sentStart;
            int slen = secStart.length();
            if (sText.length() < slen || !(sentStart = sText.substring(0, slen).toLowerCase()).equals(secStart)) continue;
            return true;
        }
        return false;
    }

    public static HashMap<String, Boolean> extract(JCas jCas, Annotation arg) {
        List depnodes;
        HashMap<String, Boolean> vfeat = new HashMap<String, Boolean>();
        for (String feat : FeatureIndex) {
            vfeat.put(feat, false);
        }
        Sentence sEntity = null;
        Collection sentences = JCasUtil.select((JCas)jCas, Sentence.class);
        for (Sentence s : sentences) {
            if (s.getBegin() > arg.getBegin() || s.getEnd() < arg.getEnd()) continue;
            sEntity = s;
            break;
        }
        DocumentAnnotation docAnnot = null;
        Collection docAnnots = JCasUtil.select((JCas)jCas, DocumentAnnotation.class);
        if (!docAnnots.isEmpty()) {
            Object[] docAnnotArray = docAnnots.toArray();
            docAnnot = (DocumentAnnotation)docAnnotArray[0];
        }
        if (sEntity != null) {
            Chunk chunk;
            IdentifiedAnnotation annot;
            if (docAnnot != null) {
                String doctext = docAnnot.getCoveredText();
                int sentStart = sEntity.getBegin();
                if (sentStart > 0) {
                    boolean argInHistSection = false;
                    ArrayList sentList = new ArrayList(sentences);
                    Collections.sort(sentList, new AnnotLocationComparator());
                    int currind = sentList.indexOf(sEntity);
                    if (currind == 0) {
                        argInHistSection = HistoryAttributeClassifier.isInHistSection(sEntity);
                    } else {
                        Sentence prevSent = (Sentence)sentList.get(--currind);
                        String tweenSents = "";
                        try {
                            tweenSents = doctext.substring(prevSent.getEnd(), sentStart);
                        }
                        catch (IndexOutOfBoundsException e) {
                            tweenSents = "";
                        }
                        if (tweenSents.indexOf("\n") != -1) {
                            argInHistSection = HistoryAttributeClassifier.isInHistSection(sEntity);
                        } else if (currind == 0) {
                            argInHistSection = HistoryAttributeClassifier.isInHistSection(prevSent);
                        } else {
                            while (currind > 0) {
                                Sentence currSent = prevSent;
                                prevSent = (Sentence)sentList.get(--currind);
                                sentStart = currSent.getBegin();
                                int prevSentEnd = prevSent.getEnd();
                                try {
                                    tweenSents = doctext.substring(prevSentEnd, sentStart);
                                }
                                catch (StringIndexOutOfBoundsException e) {
                                    tweenSents = "";
                                }
                                if (tweenSents.indexOf("\n") != -1 || currind == 0) {
                                    argInHistSection = HistoryAttributeClassifier.isInHistSection(currSent);
                                    break;
                                }
                                if (currind != 0) continue;
                                argInHistSection = HistoryAttributeClassifier.isInHistSection(prevSent);
                                break;
                            }
                        }
                    }
                    vfeat.put(IN_HIST_SECTION, argInHistSection);
                }
            }
            List lsmentions = JCasUtil.selectCovering((JCas)jCas, IdentifiedAnnotation.class, (int)arg.getBegin(), (int)arg.getEnd());
            Collections.sort(lsmentions, new AnnotLocationComparator());
            Iterator sentStart = lsmentions.iterator();
            while (sentStart.hasNext() && (annot = (IdentifiedAnnotation)sentStart.next()).getBegin() <= arg.getBegin()) {
                if (annot.getEnd() < arg.getEnd() || DependencyUtility.equalCoverage((Annotation)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)annot), (Annotation)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)arg)) || !(annot instanceof EntityMention) && !(annot instanceof EventMention)) continue;
                vfeat.put(SUBSUMED_ANNOT, true);
                break;
            }
            List lschunks = JCasUtil.selectPreceding((JCas)jCas, Chunk.class, (AnnotationFS)arg, (int)5);
            lschunks.addAll(JCasUtil.selectFollowing((JCas)jCas, Chunk.class, (AnnotationFS)arg, (int)5));
            Iterator iterator = lschunks.iterator();
            while (iterator.hasNext() && (chunk = (Chunk)iterator.next()).getBegin() <= arg.getBegin()) {
                if (chunk.getEnd() < arg.getEnd() || DependencyUtility.equalCoverage((Annotation)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)chunk), (Annotation)DependencyUtility.getNominalHeadNode((JCas)jCas, (Annotation)arg))) continue;
                vfeat.put(SUBSUMED_CHUNK, true);
            }
        }
        if (!(depnodes = JCasUtil.selectCovered((JCas)jCas, ConllDependencyNode.class, (AnnotationFS)arg)).isEmpty()) {
            ConllDependencyNode depnode = DependencyUtility.getNominalHeadNode((List)depnodes);
            if (depnode.getDeprel().matches("(NMOD|amod|nmod|det|predet|nn|poss|possessive|infmod|partmod|rcmod)")) {
                vfeat.put(POSTCOORD_NMOD, true);
            }
            for (ConllDependencyNode dn : DependencyUtility.getPathToTop((JCas)jCas, (ConllDependencyNode)depnode)) {
                if (!HistoryAttributeClassifier.isDiscussionContext((Annotation)dn)) continue;
                vfeat.put(DISCUSSION_DEPPATH, true);
            }
        }
        return vfeat;
    }

    private static boolean isDonorTerm(Annotation arg) {
        return arg.getCoveredText().toLowerCase().matches("(donor).*");
    }

    private static boolean isDiscussionContext(Annotation arg) {
        return arg.getCoveredText().toLowerCase().matches("(discuss|ask|understand|understood|tell|told|mention|talk|speak|spoke|address).*");
    }

    public static void main(String[] args) {
        String s = "steps";
        if (s.toLowerCase().matches(".*(in-law|stepc|stepd|stepso|stepf|stepm|step-).*")) {
            System.out.println("match");
        } else {
            System.out.println("no match");
        }
    }

    static {
        FeatureIndex.add(POSTCOORD_NMOD);
        FeatureIndex.add(DISCUSSION_DEPPATH);
        FeatureIndex.add(SUBSUMED_CHUNK);
        FeatureIndex.add(SUBSUMED_ANNOT);
        GHC_HIST_SECTIONS = new String[]{"fh", "sh", "pmh", "psh", "social history:", "family history", "past medical history", "pmh/psh"};
    }

    public static class AnnotLocationComparator
    implements Comparator<Annotation> {
        @Override
        public int compare(Annotation a1, Annotation a2) {
            int answer = a1.getBegin() == a2.getBegin() ? a1.getEnd() - a2.getEnd() : a1.getBegin() - a2.getBegin();
            return answer;
        }
    }
}

