/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import java.net.URI;
import org.apache.ctakes.assertion.attributes.features.SubjectFeaturesExtractor;
import org.apache.ctakes.assertion.attributes.features.selection.Chi2FeatureSelection;
import org.apache.ctakes.assertion.attributes.features.selection.FeatureSelection;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionCleartkAnalysisEngine;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Instance;

public class SubjectCleartkAnalysisEngine
extends AssertionCleartkAnalysisEngine {
    boolean USE_DEFAULT_EXTRACTORS = false;

    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.probabilityOfKeepingADefaultExample = 1.0;
        if (this.isTraining() && this.goldViewName == null) {
            throw new IllegalArgumentException("GoldViewName must be defined during training");
        }
        this.initialize_subject_extractor();
        this.initializeFeatureSelection();
    }

    private void initialize_subject_extractor() {
        this.entityFeatureExtractors.add(new SubjectFeaturesExtractor());
    }

    @Override
    public void setClassLabel(IdentifiedAnnotation entityOrEventMention, Instance<String> instance) throws AnalysisEngineProcessException {
        if (this.isTraining()) {
            String subj = entityOrEventMention.getSubject();
            if ("patient".equals(subj) && coin.nextDouble() >= this.probabilityOfKeepingADefaultExample) {
                return;
            }
            instance.setOutcome((Object)subj);
            this.logger.log((Priority)Level.DEBUG, (Object)String.format("[%s] expected: ''; actual: ''; features: %s", ((Object)((Object)this)).getClass().getSimpleName(), instance.toString()));
        } else {
            String label = (String)this.classifier.classify(instance.getFeatures());
            entityOrEventMention.setSubject(label);
            this.logger.log((Priority)Level.DEBUG, (Object)("SUBJECT is being set on an IdentifiedAnnotation: " + label + " " + entityOrEventMention.getSubject()));
        }
    }

    public static FeatureSelection<String> createFeatureSelection(double threshold) {
        return new Chi2FeatureSelection<String>("SelectNeighborFeatures", threshold, false);
    }

    public static URI createFeatureSelectionURI(File outputDirectoryName) {
        return new File(outputDirectoryName, "SelectNeighborFeatures_Chi2_extractor.dat").toURI();
    }

    @Override
    protected void initializeFeatureSelection() throws ResourceInitializationException {
        this.featureSelection = this.featureSelectionThreshold.floatValue() == 0.0f ? null : SubjectCleartkAnalysisEngine.createFeatureSelection(this.featureSelectionThreshold.floatValue());
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(SubjectCleartkAnalysisEngine.class, (Object[])new Object[]{"FEATURE_CONFIG", AssertionCleartkAnalysisEngine.FEATURE_CONFIG.DEP_REGEX, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription() throws ResourceInitializationException {
        return SubjectCleartkAnalysisEngine.createAnnotatorDescription("/org/apache/ctakes/assertion/models/subject/model.jar");
    }
}

