/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.i2b2.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.ctakes.assertion.medfacts.i2b2.api.ConstraintConstructorFindContainedBy;
import org.apache.ctakes.assertion.medfacts.i2b2.api.ConstraintConstructorFindContainedWithin;
import org.apache.ctakes.assertion.stub.ApiConcept;
import org.apache.ctakes.assertion.stub.CharacterOffsetToLineTokenConverter;
import org.apache.ctakes.assertion.stub.LineAndTokenPosition;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.syntax.NewlineToken;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;

public class CharacterOffsetToLineTokenConverterCtakesImpl
implements CharacterOffsetToLineTokenConverter {
    protected Logger logger = Logger.getLogger((String)CharacterOffsetToLineTokenConverterCtakesImpl.class.getName());
    protected JCas jcas;
    protected TreeMap<Integer, Sentence> beginTreeMap;
    protected TreeSet<Integer> tokenBeginEndTreeSet;
    protected Map<Sentence, List<BaseToken>> sentenceToTokenNumberMap;

    public CharacterOffsetToLineTokenConverterCtakesImpl() {
    }

    public CharacterOffsetToLineTokenConverterCtakesImpl(JCas jcas) {
        this.jcas = jcas;
        this.buildSentenceBoundaryMap();
        this.buildTokenBoundaryMap();
        this.buildSentenceToTokenNumberMap();
    }

    public void buildSentenceBoundaryMap() {
        this.beginTreeMap = new TreeMap();
        AnnotationIndex annotationIndex = this.jcas.getAnnotationIndex(Sentence.type);
        for (Annotation current : annotationIndex) {
            Sentence currentSentence = (Sentence)current;
            int begin = currentSentence.getBegin();
            this.beginTreeMap.put(begin, currentSentence);
        }
    }

    public void buildTokenBoundaryMap() {
        this.tokenBeginEndTreeSet = new TreeSet();
        AnnotationIndex annotationIndex = this.jcas.getAnnotationIndex(BaseToken.type);
        for (Annotation current : annotationIndex) {
            BaseToken bt = (BaseToken)current;
            if (bt instanceof NewlineToken) continue;
            int begin = bt.getBegin();
            int end = bt.getEnd();
            this.tokenBeginEndTreeSet.add(begin);
            this.tokenBeginEndTreeSet.add(end);
        }
    }

    protected void buildSentenceToTokenNumberMap() {
        this.sentenceToTokenNumberMap = new HashMap<Sentence, List<BaseToken>>();
        for (Sentence s : this.beginTreeMap.values()) {
            FSIterator tokensInSentenceIterator = this.jcas.getAnnotationIndex(BaseToken.type).subiterator((AnnotationFS)s);
            ArrayList<BaseToken> btList = new ArrayList<BaseToken>();
            BaseToken bt = null;
            while ((bt = this.getNextNonEOLToken((FSIterator<Annotation>)tokensInSentenceIterator)) != null) {
                btList.add(bt);
            }
            this.sentenceToTokenNumberMap.put(s, btList);
        }
    }

    public Sentence findPreviousOrCurrentSentence(int characterOffset) {
        Integer floorKey = this.beginTreeMap.floorKey(characterOffset);
        if (floorKey == null) {
            return null;
        }
        Sentence floorEntry = this.beginTreeMap.get(floorKey);
        return floorEntry;
    }

    public LineAndTokenPosition convert(int characterOffset) {
        return this.convertCharacterOffsetToLineToken(characterOffset);
    }

    public int adjustOffsetToBestMatch(int original) {
        this.logger.debug((Object)"inside adjustOffsetToBestMatch");
        Integer newValue = this.tokenBeginEndTreeSet.floor(original);
        if (newValue == null) {
            this.logger.debug((Object)"no previous token begin or end found. using begin of first token.");
            newValue = this.tokenBeginEndTreeSet.first();
        } else if (original == newValue) {
            this.logger.debug((Object)("value not adjusted: " + original));
        } else {
            this.logger.debug((Object)("found previous token boundary. original: " + original + "; new value: " + newValue));
        }
        if (newValue == null) {
            this.logger.info((Object)"no previous and no first token found!!");
        }
        this.logger.debug((Object)"end adjustOffsetToBestMatch");
        return newValue;
    }

    public LineAndTokenPosition convertCharacterOffsetToLineToken(int characterOffset) {
        this.logger.debug((Object)("entering CharacterOffsetToLineTokenConverterCtakesImpl.convertCharacterOffsetToLineToken() with a characterOffset of: " + characterOffset));
        this.logger.debug((Object)"before adjusting input character offset...");
        characterOffset = this.adjustOffsetToBestMatch(characterOffset);
        this.logger.debug((Object)"after adjusting input character offset.");
        int baseTokenTypeId = BaseToken.type;
        ConstraintConstructorFindContainedBy constraintConstructorFindContainedBy = new ConstraintConstructorFindContainedBy(this.jcas);
        ConstraintConstructorFindContainedWithin constraintConstructorFindContainedWithin = new ConstraintConstructorFindContainedWithin(this.jcas);
        Type sentenceType = this.jcas.getTypeSystem().getType(Sentence.class.getName());
        Type baseTokenType = this.jcas.getTypeSystem().getType(BaseToken.class.getName());
        this.logger.debug((Object)("finding current or previous sentence for character offset " + characterOffset));
        Sentence sentence = this.findPreviousOrCurrentSentence(characterOffset);
        if (sentence == null) {
            this.logger.info((Object)"current or previous sentence IS NULL!");
        } else {
            this.logger.debug((Object)("current or previous sentence -- id: " + sentence.getAddress() + "; begin: " + sentence.getBegin() + "; end: " + sentence.getEnd()));
        }
        int lineNumber = sentence.getSentenceNumber() + 1;
        FSIterator<Annotation> beginTokenInSentenceIterator = constraintConstructorFindContainedBy.createFilteredIterator(characterOffset, characterOffset, baseTokenType);
        BaseToken beginToken = this.getNextNonEOLToken(beginTokenInSentenceIterator);
        int beginTokenWordNumber = this.sentenceToTokenNumberMap.get(sentence).indexOf(beginToken);
        LineAndTokenPosition b = new LineAndTokenPosition();
        b.setLine(lineNumber);
        b.setTokenOffset(beginTokenWordNumber);
        return b;
    }

    public BaseToken getNextNonEOLToken(FSIterator<Annotation> tokensInSentenceIterator) {
        while (tokensInSentenceIterator.hasNext()) {
            BaseToken bt = (BaseToken)tokensInSentenceIterator.next();
            if (bt instanceof NewlineToken) continue;
            return bt;
        }
        return null;
    }

    public List<LineAndTokenPosition> calculateBeginAndEndOfConcept(ApiConcept problem) {
        return this.calculateBeginAndEndOfConcept(problem.getBegin(), problem.getEnd());
    }

    public List<LineAndTokenPosition> calculateBeginAndEndOfConcept(int problemBegin, int problemEnd) {
        int baseTokenTypeId = BaseToken.type;
        ConstraintConstructorFindContainedBy constraintConstructorFindContainedBy = new ConstraintConstructorFindContainedBy(this.jcas);
        ConstraintConstructorFindContainedWithin constraintConstructorFindContainedWithin = new ConstraintConstructorFindContainedWithin(this.jcas);
        Type sentenceType = this.jcas.getTypeSystem().getType(Sentence.class.getName());
        Type baseTokenType = this.jcas.getTypeSystem().getType(BaseToken.class.getName());
        FSIterator<Annotation> filteredIterator = constraintConstructorFindContainedBy.createFilteredIterator(problemBegin, problemEnd, sentenceType);
        ArrayList<LineAndTokenPosition> list = new ArrayList<LineAndTokenPosition>();
        if (filteredIterator.hasNext()) {
            Annotation sentenceAnnotation = (Annotation)filteredIterator.next();
            Sentence sentence = (Sentence)sentenceAnnotation;
            int lineNumber = sentence.getSentenceNumber() + 1;
            FSIterator<Annotation> beginTokenInSentenceIterator = constraintConstructorFindContainedWithin.createFilteredIterator(problemBegin, problemEnd, baseTokenType);
            BaseToken beginToken = this.getNextNonEOLToken(beginTokenInSentenceIterator);
            int beginTokenWordNumber = this.sentenceToTokenNumberMap.get(sentence).indexOf(beginToken);
            beginTokenInSentenceIterator.moveToLast();
            if (!beginTokenInSentenceIterator.hasNext()) {
                throw new RuntimeException("First token in sentence not found!!");
            }
            Annotation endTokenAnnotation = (Annotation)beginTokenInSentenceIterator.next();
            BaseToken endToken = (BaseToken)endTokenAnnotation;
            int endTokenWordNumber = this.sentenceToTokenNumberMap.get(sentence).indexOf(endToken);
            LineAndTokenPosition b = new LineAndTokenPosition();
            b.setLine(lineNumber);
            b.setTokenOffset(beginTokenWordNumber);
            list.add(b);
            LineAndTokenPosition e = new LineAndTokenPosition();
            e.setLine(lineNumber);
            e.setTokenOffset(endTokenWordNumber);
            list.add(e);
        }
        return list;
    }
}

