/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.train;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.apache.ctakes.assertion.eval.AssertionEvaluation;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionCleartkAnalysisEngine;
import org.apache.ctakes.assertion.train.PolarityDomainAdaptationTrain;
import org.apache.ctakes.assertion.util.AssertionConst;

public class PolarityDomainAdaptationTests {
    static final String RUN_ID = "feda_";
    protected static final String SHARP_TEST = "/projects/data/assertion/data/preprocessed_data/sharp/test";
    protected static final String I2B2_TEST = "/projects/data/assertion/data/preprocessed_data/i2b2/test";
    protected static final String MIPACQ_TEST = "/projects/data/assertion/data/preprocessed_data/mipacq/test";
    protected static final String NEGEX_TEST = "/projects/data/assertion/data/preprocessed_data/negex";

    public static void main(String[] args) throws Exception {
        AssertionEvaluation.useEvaluationLogFile = true;
        AssertionEvaluation.evaluationLogFilePath = "eval/feda_" + new Date().toString().replaceAll(" ", "_") + ".txt";
        ArrayList<TestPair> testGrid = new ArrayList<TestPair>();
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain-feda", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train-feda", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/mipacqtrain-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/mipacqtrain-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/mipacqtrain-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/mipacqtrain-feda", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/negextest-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/negextest-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/negextest-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/negextest-feda", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train-feda", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain-feda", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+negextest-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+negextest-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+negextest-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+negextest-feda", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/i2b2train+mipacqtrain+negextest-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+mipacqtrain+negextest-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+negextest-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharptrain+i2b2train+mipacqtrain-feda", NEGEX_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex-feda", SHARP_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex-feda", I2B2_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex-feda", MIPACQ_TEST));
        testGrid.add(new TestPair("../ctakes-assertion-res/resources/model/sharpi2b2mipacqnegex-feda", NEGEX_TEST));
        String attribute = "polarity";
        for (TestPair oneTest : testGrid) {
            ArrayList<String> params = new ArrayList<String>();
            File instancef = new File("eval/instances_" + oneTest.model.substring(oneTest.model.lastIndexOf("/") + 1) + "_" + AssertionCleartkAnalysisEngine.normalizeToDomain(oneTest.data));
            params.add("--test-dir");
            params.add(oneTest.data);
            params.add("--models-dir");
            params.add(oneTest.model);
            String trainDomains = (String)PolarityDomainAdaptationTrain.trainGrid.inverse().get((Object)oneTest.model);
            if (null == trainDomains) continue;
            params.add("--train-dir");
            params.add(trainDomains);
            params.add("--test-only");
            params.add("--feda");
            params.add("--print-instances");
            params.add(instancef.getAbsolutePath());
            for (String ignoreAttribute : AssertionConst.allAnnotationTypes) {
                if (ignoreAttribute.equals(attribute)) continue;
                if (ignoreAttribute.equals("historyOf")) {
                    ignoreAttribute = ignoreAttribute.substring(0, ignoreAttribute.length() - 2);
                }
                params.add("--ignore-" + ignoreAttribute);
            }
            String[] paramList = params.toArray(new String[0]);
            System.out.println(Arrays.asList(paramList).toString());
            AssertionEvaluation.main(paramList);
        }
    }

    static class TestPair {
        String model;
        String data;

        TestPair(String a, String b) {
            this.model = a;
            this.data = b;
        }
    }
}

