/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Map;
import java.util.TreeMap;

public enum ConnectionField {
    CONNECTION_ID("connectionID"),
    CLIENT_ID("clientID"),
    USERS("users"),
    PROTOCOL("protocol"),
    SESSION_COUNT("sessionCount"),
    REMOTE_ADDRESS("remoteAddress"),
    LOCAL_ADDRESS("localAddress"),
    SESSION_ID("sessionID"),
    CREATION_TIME("creationTime"),
    IMPLEMENTATION("implementation"),
    PROXY_ADDRESS("proxyAddress"),
    PROXY_PROTOCOL_VERSION("proxyProtocolVersion");

    private static final Map<String, ConnectionField> lookup;
    private final String name;

    public String getName() {
        return this.name;
    }

    private ConnectionField(String name) {
        this.name = name;
    }

    public static ConnectionField valueOfName(String name) {
        return lookup.get(name);
    }

    static {
        lookup = new TreeMap<String, ConnectionField>(String.CASE_INSENSITIVE_ORDER);
        for (ConnectionField e : ConnectionField.values()) {
            lookup.put(e.name, e);
        }
    }
}

