/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.criteria;

import javax.annotation.Nonnull;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.resolver.Criterion;

public final class PeerEntityIDCriterion
implements Criterion {
    @Nonnull
    @NotEmpty
    private String peerID;

    public PeerEntityIDCriterion(@Nonnull @NotEmpty String peer) {
        this.peerID = this.validatePeerID(peer);
    }

    @Nonnull
    @NotEmpty
    public String getPeerID() {
        return this.peerID;
    }

    public void setPeerID(@Nonnull @NotEmpty String peer) {
        this.peerID = this.validatePeerID(peer);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PeerEntityIDCriterion [peerID=");
        builder.append(this.peerID);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return this.peerID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PeerEntityIDCriterion) {
            PeerEntityIDCriterion peercrit = (PeerEntityIDCriterion)obj;
            return this.peerID.equals(peercrit.peerID);
        }
        return false;
    }

    @Nonnull
    @NotEmpty
    public String validatePeerID(@Nonnull @NotEmpty String peer) {
        String trimmed = StringSupport.trimOrNull((String)peer);
        return (String)Constraint.isNotNull((Object)trimmed, (String)"Peer entityID criterion value cannot be null or empty");
    }
}

