/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.Serializable;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public final class DiscoveryGroupConfiguration
implements Serializable {
    private static final long serialVersionUID = 8657206421727863400L;
    private String name = UUIDGenerator.getInstance().generateStringUUID();
    private long refreshTimeout = 10000L;
    private long discoveryInitialWaitTimeout = 10000L;
    private long stoppingTimeout = 10000L;
    private BroadcastEndpointFactory endpointFactory;

    public String getName() {
        return this.name;
    }

    public long getRefreshTimeout() {
        return this.refreshTimeout;
    }

    public DiscoveryGroupConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public DiscoveryGroupConfiguration setRefreshTimeout(long refreshTimeout) {
        this.refreshTimeout = refreshTimeout;
        return this;
    }

    public long getDiscoveryInitialWaitTimeout() {
        return this.discoveryInitialWaitTimeout;
    }

    public DiscoveryGroupConfiguration setDiscoveryInitialWaitTimeout(long discoveryInitialWaitTimeout) {
        this.discoveryInitialWaitTimeout = discoveryInitialWaitTimeout;
        return this;
    }

    public long getStoppingTimeout() {
        return this.stoppingTimeout;
    }

    public void setStoppingTimeout(long stoppingTimeout) {
        this.stoppingTimeout = stoppingTimeout;
    }

    public BroadcastEndpointFactory getBroadcastEndpointFactory() {
        return this.endpointFactory;
    }

    public DiscoveryGroupConfiguration setBroadcastEndpointFactory(BroadcastEndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DiscoveryGroupConfiguration)) {
            return false;
        }
        DiscoveryGroupConfiguration other = (DiscoveryGroupConfiguration)obj;
        return this.discoveryInitialWaitTimeout == other.discoveryInitialWaitTimeout && this.refreshTimeout == other.refreshTimeout && Objects.equals(this.name, other.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.refreshTimeout, this.discoveryInitialWaitTimeout);
    }

    public String toString() {
        return "DiscoveryGroupConfiguration{name='" + this.name + "', refreshTimeout=" + this.refreshTimeout + ", discoveryInitialWaitTimeout=" + this.discoveryInitialWaitTimeout + "}";
    }
}

