/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.MemoryRequestServer;

public interface Resource
extends AutoCloseable {
    public static final MemoryRequestServer defaultMemReqSvr = new DefaultMemoryRequestServer();

    public MemoryRequestServer getMemoryRequestServer();

    public boolean hasMemoryRequestServer();

    public void setMemoryRequestServer(MemoryRequestServer var1);

    @Override
    public void close();

    public boolean isCloseable();

    default public boolean equalTo(Resource that) {
        if (that == null || this.getCapacity() != that.getCapacity()) {
            return false;
        }
        return this.equalTo(0L, that, 0L, that.getCapacity());
    }

    public boolean equalTo(long var1, Resource var3, long var4, long var6);

    public void force();

    public long getCapacity();

    default public long getCumulativeOffset() {
        return this.getCumulativeOffset(0L);
    }

    public long getCumulativeOffset(long var1);

    public long getRelativeOffset();

    public ByteOrder getTypeByteOrder();

    public boolean hasByteBuffer();

    public boolean isByteOrderCompatible(ByteOrder var1);

    public boolean isDirect();

    public boolean isDuplicate();

    public boolean isHeap();

    public boolean isLoaded();

    public boolean isMemory();

    public boolean isMapped();

    public boolean isNonNativeOrder();

    public boolean isReadOnly();

    public boolean isRegionView();

    public boolean isSameResource(Resource var1);

    public boolean isAlive();

    public void load();

    public String toString(String var1, long var2, int var4, boolean var5);

    public String toString();

    public long xxHash64(long var1, long var3, long var5);

    public long xxHash64(long var1, long var3);
}

