/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.foreign.Arena;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.Resource;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.memory.internal.ResourceImpl;
import org.apache.datasketches.memory.internal.Util;
import org.apache.datasketches.memory.internal.UtilTest;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class AllocateDirectWritableMapMemoryTest {
    private final MemoryRequestServer memReqSvr = Resource.defaultMemReqSvr;

    @BeforeClass
    public void setReadOnly() throws IOException {
        UtilTest.setGettysburgAddressFileToReadOnly();
    }

    @Test
    public void simpleMap() throws IllegalArgumentException, InvalidPathException, IllegalStateException, UnsupportedOperationException, IOException, SecurityException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        try (Arena arena = Arena.ofConfined();){
            Memory mem = Memory.map((File)file, (Arena)arena);
            byte[] byteArr = new byte[(int)mem.getCapacity()];
            mem.getByteArray(0L, byteArr, 0, byteArr.length);
            String text = new String(byteArr, StandardCharsets.UTF_8);
            AllocateDirectWritableMapMemoryTest.println(text);
            Assert.assertTrue((boolean)mem.isReadOnly());
        }
    }

    @Test
    public void copyOffHeapToMemoryMappedFile() throws IllegalArgumentException, InvalidPathException, IllegalStateException, UnsupportedOperationException, IOException, SecurityException {
        long numBytes = 1024L;
        long numLongs = numBytes >>> 3;
        File file = new File("TestFile.bin");
        if (file.exists()) {
            Files.delete(file.toPath());
        }
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        file.deleteOnExit();
        WritableMemory dstMem = null;
        WritableMemory srcMem = null;
        try (Arena arena = Arena.ofConfined();){
            dstMem = WritableMemory.writableMap((File)file, (long)0L, (long)numBytes, (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena);
            srcMem = WritableMemory.allocateDirect((long)numBytes, (long)8L, (ByteOrder)ByteOrder.nativeOrder(), (MemoryRequestServer)this.memReqSvr, (Arena)arena);
            for (long i = 0L; i < numLongs; ++i) {
                srcMem.putLong(i << 3, i);
            }
            srcMem.copyTo(0L, dstMem, 0L, srcMem.getCapacity());
            dstMem.force();
            Assert.assertEquals((long)dstMem.getLong(numLongs - 1L << 3), (long)(numLongs - 1L));
        }
    }

    @Test
    public void checkNonNativeFile() throws IllegalArgumentException, InvalidPathException, IllegalStateException, UnsupportedOperationException, IOException, SecurityException {
        File file = new File("TestFile2.bin");
        if (file.exists()) {
            Files.delete(file.toPath());
        }
        Assert.assertTrue((boolean)file.createNewFile());
        Assert.assertTrue((boolean)file.setWritable(true, false));
        Assert.assertTrue((boolean)file.isFile());
        file.deleteOnExit();
        long bytes = 8L;
        WritableMemory wmem = null;
        Arena arena = Arena.ofConfined();
        wmem = WritableMemory.writableMap((File)file, (long)0L, (long)8L, (ByteOrder)ResourceImpl.NON_NATIVE_BYTE_ORDER, (Arena)arena);
        wmem.putChar(0L, '\u0001');
        Assert.assertEquals((byte)wmem.getByte(1L), (byte)1);
        arena.close();
    }

    @Test
    public void testMapExceptionNoTWR() throws IllegalArgumentException, InvalidPathException, IllegalStateException, UnsupportedOperationException, IOException, SecurityException {
        File dummy = AllocateDirectWritableMapMemoryTest.createTempFile("dummy", ".txt", "");
        try (Arena arena = Arena.ofConfined();){
            Memory.map((File)dummy, (long)0L, (long)dummy.length(), (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena);
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void simpleMap2() throws IllegalArgumentException, InvalidPathException, IllegalStateException, UnsupportedOperationException, IOException, SecurityException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        Assert.assertTrue((boolean)file.canRead());
        Assert.assertFalse((boolean)file.canWrite());
        try (Arena arena = Arena.ofConfined();){
            WritableMemory wmem = WritableMemory.writableMap((File)file, (Arena)arena);
            wmem.getCapacity();
        }
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkReadException() throws IllegalArgumentException, InvalidPathException, IllegalStateException, UnsupportedOperationException, IOException, SecurityException {
        File file = Util.getResourceFile((String)"GettysburgAddress.txt");
        Arena arena = Arena.ofConfined();
        WritableMemory wmem = null;
        wmem = WritableMemory.writableMap((File)file, (long)0L, (long)0x100000L, (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena);
        wmem.getCapacity();
        arena.close();
    }

    @Test
    public void testForce() throws IllegalArgumentException, InvalidPathException, IllegalStateException, UnsupportedOperationException, IOException, SecurityException {
        String origStr = "Corectng spellng mistks";
        File origFile = AllocateDirectWritableMapMemoryTest.createTempFile("force_original", ".txt", origStr);
        Assert.assertTrue((boolean)origFile.setWritable(true, false));
        long origBytes = origFile.length();
        String correctStr = "Correcting spelling mistakes";
        byte[] correctByteArr = correctStr.getBytes(StandardCharsets.UTF_8);
        long correctBytesLen = correctByteArr.length;
        Memory mem = null;
        WritableMemory wmem = null;
        try (Arena arena = Arena.ofConfined();){
            mem = Memory.map((File)origFile, (long)0L, (long)origBytes, (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena);
            mem.load();
            byte[] buf = new byte[(int)origBytes];
            mem.getByteArray(0L, buf, 0, (int)origBytes);
            String bufStr = new String(buf, StandardCharsets.UTF_8);
            Assert.assertEquals((String)bufStr, (String)origStr);
            wmem = WritableMemory.writableMap((File)origFile, (long)0L, (long)correctBytesLen, (ByteOrder)ByteOrder.nativeOrder(), (Arena)arena);
            wmem.load();
            wmem.putByteArray(0L, correctByteArr, 0, (int)correctBytesLen);
            wmem.force();
            byte[] buf2 = new byte[(int)correctBytesLen];
            wmem.getByteArray(0L, buf2, 0, (int)correctBytesLen);
            String bufStr2 = new String(buf2, StandardCharsets.UTF_8);
            Assert.assertEquals((String)bufStr2, (String)correctStr);
        }
    }

    private static File createTempFile(String fileNamePrefix, String fileNameSuffix, String text) throws FileNotFoundException, IOException {
        File file = File.createTempFile(fileNamePrefix, fileNameSuffix);
        file.deleteOnExit();
        try {
            PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8.name());
            writer.print(text);
            writer.close();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return file;
    }

    @Test
    public void printlnTest() {
        AllocateDirectWritableMapMemoryTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            AllocateDirectWritableMapMemoryTest.print(ResourceImpl.LS);
        } else {
            AllocateDirectWritableMapMemoryTest.print(o.toString() + ResourceImpl.LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

