/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.io.IOException;
import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.ItemsUnion;
import org.apache.pig.Accumulator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public abstract class DataToItemsSketch<T>
extends EvalFunc<Tuple>
implements Accumulator<Tuple>,
Algebraic {
    private static final TupleFactory tupleFactory_ = TupleFactory.getInstance();
    private final int k_;
    private final Comparator<T> comparator_;
    private final ArrayOfItemsSerDe<T> serDe_;
    private ItemsUnion<T> accumUnion_;

    public DataToItemsSketch(int k, Comparator<T> comparator, ArrayOfItemsSerDe<T> serDe) {
        this.k_ = k;
        this.comparator_ = comparator;
        this.serDe_ = serDe;
    }

    public Tuple exec(Tuple inputTuple) throws IOException {
        if (inputTuple != null && inputTuple.size() > 0) {
            ItemsUnion union = this.k_ > 0 ? ItemsUnion.getInstance((int)this.k_, this.comparator_) : ItemsUnion.getInstance(this.comparator_);
            DataBag bag = (DataBag)inputTuple.get(0);
            for (Tuple innerTuple : bag) {
                Object value = innerTuple.get(0);
                if (value == null) continue;
                union.update(this.extractValue(value));
            }
            ItemsSketch resultSketch = union.getResultAndReset();
            if (resultSketch != null) {
                return tupleFactory_.newTuple((Object)new DataByteArray(resultSketch.toByteArray(this.serDe_)));
            }
        }
        ItemsSketch sketch = this.k_ > 0 ? ItemsSketch.getInstance((int)this.k_, this.comparator_) : ItemsSketch.getInstance(this.comparator_);
        return tupleFactory_.newTuple((Object)new DataByteArray(sketch.toByteArray(this.serDe_)));
    }

    public Schema outputSchema(Schema input) {
        if (input == null) {
            return null;
        }
        try {
            Schema tupleSchema = new Schema();
            tupleSchema.add(new Schema.FieldSchema("Sketch", 50));
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), tupleSchema, 110));
        }
        catch (FrontendException e) {
            throw new RuntimeException(e);
        }
    }

    public void accumulate(Tuple inputTuple) throws IOException {
        if (inputTuple == null || inputTuple.size() == 0) {
            return;
        }
        DataBag bag = (DataBag)inputTuple.get(0);
        if (bag == null) {
            return;
        }
        if (this.accumUnion_ == null) {
            this.accumUnion_ = this.k_ > 0 ? ItemsUnion.getInstance((int)this.k_, this.comparator_) : ItemsUnion.getInstance(this.comparator_);
        }
        for (Tuple innerTuple : bag) {
            Object value = innerTuple.get(0);
            if (value == null) continue;
            this.accumUnion_.update(this.extractValue(value));
        }
    }

    public Tuple getValue() {
        ItemsSketch resultSketch;
        if (this.accumUnion_ != null && (resultSketch = this.accumUnion_.getResultAndReset()) != null) {
            return tupleFactory_.newTuple((Object)new DataByteArray(resultSketch.toByteArray(this.serDe_)));
        }
        ItemsSketch sketch = this.k_ > 0 ? ItemsSketch.getInstance((int)this.k_, this.comparator_) : ItemsSketch.getInstance(this.comparator_);
        return tupleFactory_.newTuple((Object)new DataByteArray(sketch.toByteArray(this.serDe_)));
    }

    public void cleanup() {
        this.accumUnion_ = null;
    }

    protected T extractValue(Object object) {
        return (T)object;
    }

    public static abstract class DataToItemsSketchIntermediateFinal<T>
    extends EvalFunc<Tuple> {
        private final int k_;
        private final Comparator<T> comparator_;
        private final ArrayOfItemsSerDe<T> serDe_;

        public DataToItemsSketchIntermediateFinal(int k, Comparator<T> comparator, ArrayOfItemsSerDe<T> serDe) {
            this.k_ = k;
            this.comparator_ = comparator;
            this.serDe_ = serDe;
        }

        protected T extractValue(Object object) {
            return (T)object;
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            if (inputTuple != null && inputTuple.size() > 0) {
                ItemsUnion union = this.k_ > 0 ? ItemsUnion.getInstance((int)this.k_, this.comparator_) : ItemsUnion.getInstance(this.comparator_);
                DataBag outerBag = (DataBag)inputTuple.get(0);
                for (Tuple dataTuple : outerBag) {
                    Object f0 = dataTuple.get(0);
                    if (f0 == null) continue;
                    if (f0 instanceof DataBag) {
                        DataBag innerBag = (DataBag)f0;
                        if (innerBag.size() == 0L) continue;
                        for (Tuple innerTuple : innerBag) {
                            Object value = innerTuple.get(0);
                            if (value == null) continue;
                            union.update(this.extractValue(value));
                        }
                        continue;
                    }
                    if (f0 instanceof DataByteArray) {
                        DataByteArray dba = (DataByteArray)f0;
                        union.update(ItemsSketch.getInstance((Memory)Memory.wrap((byte[])dba.get()), this.comparator_, this.serDe_));
                        continue;
                    }
                    throw new IllegalArgumentException("dataTuple.Field0: Is not a DataByteArray: " + f0.getClass().getName());
                }
                ItemsSketch resultSketch = union.getResultAndReset();
                if (resultSketch != null) {
                    return tupleFactory_.newTuple((Object)new DataByteArray(resultSketch.toByteArray(this.serDe_)));
                }
            }
            ItemsSketch sketch = this.k_ > 0 ? ItemsSketch.getInstance((int)this.k_, this.comparator_) : ItemsSketch.getInstance(this.comparator_);
            return tupleFactory_.newTuple((Object)new DataByteArray(sketch.toByteArray(this.serDe_)));
        }
    }

    public static class DataToItemsSketchInitial
    extends EvalFunc<Tuple> {
        public DataToItemsSketchInitial() {
        }

        public DataToItemsSketchInitial(String kStr) {
        }

        public Tuple exec(Tuple inputTuple) throws IOException {
            return inputTuple;
        }
    }
}

