/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.tuple;

import java.io.IOException;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.tuple.Util;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketchIterator;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

public class ArrayOfDoublesSketchToEstimates
extends EvalFunc<Tuple> {
    public Tuple exec(Tuple input) throws IOException {
        if (input == null || input.size() == 0) {
            return null;
        }
        DataByteArray dba = (DataByteArray)input.get(0);
        ArrayOfDoublesSketch sketch = ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])dba.get()));
        double[] estimates = new double[sketch.getNumValues() + 1];
        estimates[0] = sketch.getEstimate();
        if (sketch.getRetainedEntries() > 0) {
            ArrayOfDoublesSketchIterator it = sketch.iterator();
            while (it.next()) {
                double[] values = it.getValues();
                for (int i = 0; i < sketch.getNumValues(); ++i) {
                    int n = i + 1;
                    estimates[n] = estimates[n] + values[i];
                }
            }
            for (int i = 0; i < sketch.getNumValues(); ++i) {
                int n = i + 1;
                estimates[n] = estimates[n] / sketch.getTheta();
            }
        }
        return Util.doubleArrayToTuple(estimates);
    }
}

