/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.DataTruncation;
import java.util.Locale;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Utils;
import org.apache.derby.client.net.Typdef;
import org.apache.derby.shared.common.error.MessageUtils;

public abstract class Sqlca {
    private static final int HIGH_ORDER_ROW_COUNT = 0;
    private static final int LOW_ORDER_ROW_COUNT = 1;
    private static final int LOW_ORDER_UPDATE_COUNT = 2;
    private static final int HIGH_ORDER_UPDATE_COUNT = 3;
    public static final int SQL_ERR_LENGTH = 6;
    private transient ClientConnection connection_;
    SqlException exceptionThrownOnStoredProcInvocation_;
    boolean messageTextRetrievedContainsTokensOnly_ = true;
    protected int sqlCode_;
    private String sqlErrmc_;
    private String[] sqlErrmcMessages_;
    private String[] sqlStates_;
    private String sqlErrp_;
    protected int[] sqlErrd_;
    private String sqlWarn_;
    protected String sqlState_;
    protected byte[] sqlErrmcBytes_;
    protected byte[] sqlErrpBytes_;
    protected byte[] sqlWarnBytes_;
    private boolean containsSqlcax_ = true;
    private long rowsetRowCount_;
    private boolean returnTokensOnlyInMessageText_ = false;
    private final transient Agent agent_;
    private String[] cachedMessages;
    private static final String elevenBlanks = "           ";

    protected Sqlca(ClientConnection connection) {
        this.connection_ = connection;
        this.agent_ = this.connection_ != null ? this.connection_.agent_ : null;
    }

    void returnTokensOnlyInMessageText(boolean returnTokensOnlyInMessageText) {
        this.returnTokensOnlyInMessageText_ = returnTokensOnlyInMessageText;
    }

    synchronized int numberOfMessages() {
        this.initSqlErrmcMessages();
        if (this.sqlErrmcMessages_ != null) {
            return this.sqlErrmcMessages_.length;
        }
        return 1;
    }

    public synchronized int getSqlCode() {
        return this.sqlCode_;
    }

    public synchronized int getErrorCode() {
        if (this.sqlCode_ >= 0) {
            return this.sqlCode_;
        }
        int errorCode = -(this.sqlCode_ + 1);
        if (errorCode == 20000 && this.connection_ != null && this.connection_.autoCommit_) {
            errorCode = 30000;
        }
        return errorCode;
    }

    public synchronized String getSqlErrmc() {
        int indx;
        if (this.sqlErrmc_ != null) {
            return this.sqlErrmc_;
        }
        this.initSqlErrmcMessages();
        if (this.sqlErrmcMessages_ == null) {
            return null;
        }
        if (this.sqlErrmcMessages_.length == 0) {
            this.sqlErrmc_ = "";
            return this.sqlErrmc_;
        }
        StringBuffer buffer = new StringBuffer();
        for (indx = 0; indx < this.sqlErrmcMessages_.length - 1; ++indx) {
            buffer.append(this.sqlErrmcMessages_[indx]);
            buffer.append(MessageUtils.SQLERRMC_MESSAGE_DELIMITER);
            buffer.append(this.sqlStates_[indx + 1]);
            buffer.append(":");
        }
        buffer.append(this.sqlErrmcMessages_[indx]);
        this.sqlErrmc_ = buffer.toString();
        return this.sqlErrmc_;
    }

    private void initSqlErrmcMessages() {
        if (this.sqlErrmcMessages_ == null || this.sqlStates_ == null) {
            this.processSqlErrmcTokens(this.sqlErrmcBytes_);
        }
    }

    public synchronized String getSqlErrp() {
        if (this.sqlErrp_ != null) {
            return this.sqlErrp_;
        }
        if (this.sqlErrpBytes_ == null) {
            return null;
        }
        this.sqlErrp_ = this.bytes2String(this.sqlErrpBytes_, 0, this.sqlErrpBytes_.length);
        return this.sqlErrp_;
    }

    private int[] getSqlErrd() {
        if (this.sqlErrd_ != null) {
            return this.sqlErrd_;
        }
        this.sqlErrd_ = new int[6];
        return this.sqlErrd_;
    }

    String formatSqlErrd() {
        return Utils.getStringFromInts(this.getSqlErrd());
    }

    public synchronized String getSqlWarn() {
        if (this.sqlWarn_ == null) {
            this.sqlWarn_ = this.sqlWarnBytes_ != null ? this.bytes2String(this.sqlWarnBytes_, 0, this.sqlWarnBytes_.length) : elevenBlanks;
        }
        return this.sqlWarn_;
    }

    public synchronized String getSqlState() {
        return this.sqlState_;
    }

    synchronized String getSqlState(int messageNumber) {
        this.initSqlErrmcMessages();
        if (this.sqlStates_ != null) {
            return this.sqlStates_[messageNumber];
        }
        return this.getSqlState();
    }

    public Object[] getArgs(int messageNumber) {
        if (this.sqlErrmcMessages_ != null) {
            return MessageUtils.getArgs(this.getSqlState(messageNumber), this.sqlErrmcMessages_[messageNumber]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMessage(int messageNumber) throws SqlException {
        if (this.cachedMessages != null && this.cachedMessages[messageNumber] != null) {
            return this.cachedMessages[messageNumber];
        }
        if (this.connection_ == null || this.connection_.isClosedX() || this.returnTokensOnlyInMessageText_) {
            return this.getUnformattedMessage(messageNumber);
        }
        ClientCallableStatement cs = null;
        ClientConnection clientConnection = this.connection_;
        synchronized (clientConnection) {
            cs = this.connection_.prepareMessageProc("call SYSIBM.SQLCAMESSAGE(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            cs.isAutoCommittableStatement_ = false;
            String errmc = null;
            String sqlState = null;
            if (this.sqlErrmcMessages_ != null) {
                errmc = this.sqlErrmcMessages_[messageNumber];
                sqlState = this.sqlStates_[messageNumber];
            }
            cs.setIntX(1, messageNumber == 0 ? this.getSqlCode() : 0);
            cs.setShortX(2, (short)(errmc == null ? 0 : errmc.length()));
            cs.setStringX(3, errmc);
            cs.setStringX(4, this.getSqlErrp());
            cs.setIntX(5, this.getSqlErrd()[0]);
            cs.setIntX(6, this.getSqlErrd()[1]);
            cs.setIntX(7, this.getSqlErrd()[2]);
            cs.setIntX(8, this.getSqlErrd()[3]);
            cs.setIntX(9, this.getSqlErrd()[4]);
            cs.setIntX(10, this.getSqlErrd()[5]);
            cs.setStringX(11, this.getSqlWarn());
            cs.setStringX(12, sqlState);
            cs.setStringX(13, null);
            cs.setStringX(14, Locale.getDefault().toString());
            cs.registerOutParameterX(14, 12);
            cs.registerOutParameterX(15, -1);
            cs.registerOutParameterX(16, 4);
            cs.executeX();
            if (cs.getIntX(16) == 0) {
                this.messageTextRetrievedContainsTokensOnly_ = false;
                String message = cs.getStringX(15);
                if (this.cachedMessages == null) {
                    this.cachedMessages = new String[this.numberOfMessages()];
                }
                this.cachedMessages[messageNumber] = message;
                String string2 = message;
                return string2;
            }
            String string = this.getUnformattedMessage(messageNumber);
            return string;
            finally {
                if (cs != null) {
                    try {
                        cs.closeX();
                    }
                    catch (SqlException sqlException) {}
                }
            }
        }
    }

    synchronized String getJDBCMessage(int messageNumber) {
        if (this.connection_ != null && this.connection_.retrieveMessageText_) {
            try {
                return this.getMessage(messageNumber);
            }
            catch (SqlException e) {
                this.exceptionThrownOnStoredProcInvocation_ = e;
                this.chainDeferredExceptionsToAgentOrAsConnectionWarnings(e);
                return this.getUnformattedMessage(messageNumber);
            }
        }
        return this.getUnformattedMessage(messageNumber);
    }

    private String getUnformattedMessage(int messageNumber) {
        String sqlErrmc;
        String sqlState;
        int errorCode;
        if (messageNumber == 0) {
            errorCode = this.getErrorCode();
            sqlState = this.getSqlState();
            sqlErrmc = this.getSqlErrmc();
        } else {
            errorCode = 0;
            sqlState = this.sqlStates_[messageNumber];
            sqlErrmc = this.sqlErrmcMessages_[messageNumber];
        }
        return "DERBY SQL error: ERRORCODE: " + errorCode + ", SQLSTATE: " + sqlState + ", SQLERRMC: " + sqlErrmc;
    }

    private void chainDeferredExceptionsToAgentOrAsConnectionWarnings(SqlException e) {
        SqlException current = e;
        while (current != null) {
            SqlWarning warningForStoredProcFailure;
            SqlException next = current.getNextException();
            if ((current = current.copyAsUnchainedSQLException(this.agent_.logWriter_)).getErrorCode() == -440) {
                warningForStoredProcFailure = new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J12"), new Object[0]);
                warningForStoredProcFailure.setNextException(current.getSQLException());
                this.connection_.accumulate440WarningForMessageProcFailure(warningForStoredProcFailure);
            } else if (current.getErrorCode() == -444) {
                warningForStoredProcFailure = new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J12"), new Object[0]);
                warningForStoredProcFailure.setNextException(current.getSQLException());
                this.connection_.accumulate444WarningForMessageProcFailure(warningForStoredProcFailure);
            } else {
                this.agent_.accumulateDeferredException(current);
            }
            current = next;
        }
    }

    DataTruncation getDataTruncation() {
        String[] tokens = this.getSqlErrmc().split(MessageUtils.SQLERRMC_TOKEN_DELIMITER);
        return new DataTruncation(Integer.parseInt(tokens[0]), Boolean.valueOf(tokens[1]), Boolean.valueOf(tokens[2]), Integer.parseInt(tokens[3]), Integer.parseInt(tokens[4]));
    }

    private void processSqlErrmcTokens(byte[] tokenBytes) {
        if (tokenBytes == null) {
            return;
        }
        int length = tokenBytes.length;
        if (length == 0) {
            this.sqlErrmcMessages_ = new String[0];
            this.sqlStates_ = this.sqlErrmcMessages_;
            return;
        }
        String fullString = this.bytes2String(tokenBytes, 0, length);
        String[] tokens = fullString.split("\\u0014{3}");
        String[] states = new String[tokens.length];
        states[0] = this.getSqlState();
        for (int i = 1; i < tokens.length; ++i) {
            int colonpos = tokens[i].indexOf(":");
            states[i] = tokens[i].substring(0, colonpos);
            tokens[i] = tokens[i].substring(colonpos + 1);
        }
        this.sqlStates_ = states;
        this.sqlErrmcMessages_ = tokens;
    }

    protected String bytes2String(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, Typdef.UTF8ENCODING);
    }

    public long getUpdateCount() {
        if (this.sqlErrd_ == null) {
            return 0L;
        }
        long result = this.getSqlErrd()[2];
        result &= 0xFFFFFFFFL;
        return result |= (long)this.getSqlErrd()[3] << 32;
    }

    public long getRowCount() throws DisconnectException {
        return ((long)this.getSqlErrd()[0] << 32) + (long)this.getSqlErrd()[1];
    }

    public void setContainsSqlcax(boolean containsSqlcax) {
        this.containsSqlcax_ = containsSqlcax;
    }

    public boolean containsSqlcax() {
        return this.containsSqlcax_;
    }

    public void resetRowsetSqlca(ClientConnection connection, int sqlCode, String sqlState) {
        this.connection_ = connection;
        this.sqlCode_ = sqlCode;
        this.sqlState_ = sqlState;
        this.sqlErrpBytes_ = null;
    }

    public void setRowsetRowCount(long rowCount) {
        this.rowsetRowCount_ = rowCount;
    }

    public long getRowsetRowCount() {
        return this.rowsetRowCount_;
    }
}

