/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobTruncateTest
extends BaseJDBCTestCase {
    public ClobTruncateTest(String name) {
        super(name);
    }

    private void insertClobs() throws SQLException, IOException {
        PreparedStatement ps = this.prepareStatement("insert into truncateclob values (?,?,?)");
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 100; ++i) {
            sb.append("small clob");
        }
        int length = sb.length();
        ps.setInt(1, length);
        ps.setCharacterStream(2, (Reader)new StringReader(sb.toString()), length);
        ps.setInt(3, length / 2);
        ps.execute();
        LoopingAlphabetReader reader = new LoopingAlphabetReader(0x100000L);
        ps.setInt(1, 0x100000);
        ps.setCharacterStream(2, (Reader)reader, 0x100000);
        ps.setInt(3, 524288);
        ps.execute();
        LoopingAlphabetReader uReader = new LoopingAlphabetReader(300000L, CharAlphabet.tamil());
        ps.setInt(1, 300000);
        ps.setCharacterStream(2, (Reader)uReader, 300000);
        ps.setInt(3, 150000);
        ps.execute();
    }

    private void checkTruncate(int size, Clob clob, int newSize) throws SQLException {
        ClobTruncateTest.assertEquals((String)"unexpected clob size", (long)size, (long)clob.length());
        clob.truncate(newSize);
        ClobTruncateTest.assertEquals((String)"truncate failed ", (long)newSize, (long)clob.length());
        clob.truncate(newSize / 2);
        ClobTruncateTest.assertEquals((String)"truncate failed ", (long)(newSize / 2), (long)clob.length());
    }

    public void testTruncateOnClob() throws SQLException, IOException {
        this.insertClobs();
        this.getConnection().setAutoCommit(false);
        ResultSet rs = this.createStatement().executeQuery("select size, data, newsize from truncateclob");
        try {
            while (rs.next()) {
                this.checkTruncate(rs.getInt(1), rs.getClob(2), rs.getInt(3));
            }
        }
        finally {
            rs.close();
            this.getConnection().commit();
        }
    }

    @Override
    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("drop table truncateclob");
        super.tearDown();
    }

    protected void setUp() throws Exception {
        super.setUp();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table truncateclob (size integer, data clob, newSize integer)");
    }

    public static Test suite() {
        return TestConfiguration.embeddedSuite(ClobTruncateTest.class);
    }
}

