/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class GrantRevokeTest
extends BaseJDBCTestCase {
    public static final String[] users = new String[]{"TEST_DBO", "U1", "U2", "U3", "U4"};

    public GrantRevokeTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite();
        suite.addTest(GrantRevokeTest.basesuite());
        suite.addTest(TestConfiguration.clientServerDecorator((Test)new GrantRevokeTest("testGrantDatabaseMetaDataMethods")));
        return suite;
    }

    public static Test basesuite() {
        Object test = new BaseTestSuite(GrantRevokeTest.class);
        test = DatabasePropertyTestSetup.singleProperty((Test)test, "derby.locks.deadlockTrace", "true");
        test = new CleanDatabaseTestSetup((Test)test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create schema s1");
                s.execute("create schema s2");
                s.execute("create table s1.t1(c1 int, c2 int, c3 int)");
                s.execute("create table s2.t1(c1 int, c2 int, c3 int)");
                s.execute("create table s2.t2(c1 int, c2 int, c3 int)");
                s.execute("create table s2.t3(c1 int, c2 int, c3 int)");
                s.execute("create table s2.noPerms(c1 int, c2 int, c3 int)");
                s.execute("create function s1.f1() returns int  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.GrantRevokeTest.s1F1'  no sql called on null input");
                s.execute("create procedure s1.f1( )  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.GrantRevokeTest.s1F1P'  no sql called on null input");
                s.execute("create procedure s1.p1( )  language java parameter style java  external name 'org.apache.derbyTesting.functionTests.tests.lang.GrantRevokeTest.s1P1'  no sql called on null input");
                s.execute("create schema appl");
                s.execute("CREATE TABLE appl.\"TBL_Tasks\"(\"TaskID\" integer NOT NULL                     GENERATED ALWAYS AS IDENTITY, \"Task\" varchar(64) NOT NULL, \"AssignedTo\" varchar(64) NOT NULL,CONSTRAINT \"PK_Tasks\" PRIMARY KEY (\"TaskID\"))");
                s.execute("CREATE TABLE appl.\"TBL_Priorities\"(\"TaskID\" integer NOT NULL, \"Priority\" integer NOT NULL, \"SeqNbr\" integer NOT NULL,CONSTRAINT \"PK_Priorities\" PRIMARY KEY   (\"TaskID\", \"Priority\"))");
                s.execute("CREATE VIEW appl.\"VW_MyTasks\" AS     SELECT * FROM appl.\"TBL_Tasks\" WHERE \"AssignedTo\" = SESSION_USER");
                s.execute("CREATE VIEW appl.\"VW_MyPriorityTasks\" AS     SELECT t.\"TaskID\", t.\"Task\", p.\"Priority\"    FROM appl.\"TBL_Tasks\" AS t,         appl.\"TBL_Priorities\" AS p     WHERE p.\"TaskID\" = t.\"TaskID\"           AND t.\"AssignedTo\" = SESSION_USER");
                s.execute("CREATE VIEW appl.\"VW2_MyPriorityTasks\" AS     SELECT t.\"TaskID\", t.\"Task\", p.\"Priority\"     FROM appl.\"TBL_Tasks\" AS t INNER JOIN          appl.\"TBL_Priorities\" AS p ON          p.\"TaskID\" = t.\"TaskID\"     WHERE t.\"AssignedTo\" = SESSION_USER");
                s.execute("CREATE VIEW appl.\"VW3_MyPriorityTasks\" AS     SELECT t.\"TaskID\", t.\"Task\"     FROM appl.\"TBL_Tasks\" AS t     WHERE t.\"AssignedTo\" = SESSION_USER     AND EXISTS         (SELECT * FROM appl.\"TBL_Priorities\" AS p          WHERE p.\"TaskID\" = t.\"TaskID\")");
            }
        };
        test = DatabasePropertyTestSetup.builtinAuthentication((Test)test, users, "grantrevoke");
        test = TestConfiguration.sqlAuthorizationDecorator((Test)test);
        return test;
    }

    public void testSimpleGrant() throws Exception {
        this.grant("select", "s1", "t1", users[1]);
        this.assertSelectPrivilege(true, users[1], "s1", "t1", null);
        this.assertSelectPrivilege(false, users[2], "s1", "t1", null);
        this.assertSelectPrivilege(false, users[2], "s2", "t1", null);
        this.assertSelectPrivilege(false, users[2], "s2", "t2", null);
        this.revoke("select", "s1", "t1", users[1]);
    }

    public void testAllPrivileges() throws Exception {
        this.grant("all privileges", "s2", "t1", new String[]{users[2], users[3]});
        this.assertAllPrivileges(false, users[1], "S2", "T1", null);
        this.assertAllPrivileges(true, users[2], "S2", "T1", null);
        this.assertAllPrivileges(true, users[3], "S2", "T1", null);
        this.assertSelectPrivilege(false, users[1], "s1", "t1", null);
        this.assertSelectPrivilege(false, users[1], "s2", "t2", null);
        this.revoke("all privileges", "s2", "t1", new String[]{users[2], users[3]});
    }

    public void testColumnPrivileges() throws Exception {
        this.grant("select(c1),update(c3,c2),references(c3,c1,c2)", "s1", "t1", users[4]);
        this.assertSelectPrivilege(true, users[4], "s1", "t1", new String[]{"c1"});
        this.assertSelectPrivilege(false, users[4], "s1", "t1", new String[]{"c2"});
        this.assertSelectPrivilege(false, users[4], "s1", "t1", new String[]{"c3"});
        this.assertSelectPrivilege(false, users[4], "s1", "t1", null);
        this.assertUpdatePrivilege(false, users[4], "S1", "T1", new String[]{"C1"});
        this.assertUpdatePrivilege(true, users[4], "S1", "T1", new String[]{"C2", "C3"});
        this.assertReferencesPrivilege(true, users[4], "s1", "t1", new String[]{"c1", "c2", "c3"});
        this.revoke("select(c1),update(c3,c2),references(c3,c1,c2)", "s1", "t1", users[4]);
    }

    public void testFunctionWithSameProcedureName() throws Exception {
        this.grant("execute", "function s1", "f1", users[1]);
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertProcedurePrivilege(false, users[1], "S1", "F1");
        this.assertFunctionPrivilege(false, users[2], "S1", "F1", false);
        this.revoke("execute", "function s1", "f1", users[1]);
    }

    public void testGrantOnProcedure() throws Exception {
        this.grant("execute", "procedure s1", "p1", users[1]);
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.assertFunctionPrivilege(false, users[1], "S1", "P1", true);
        this.assertProcedurePrivilege(false, users[2], "S1", "P1");
        this.assertFunctionPrivilege(false, users[2], "S1", "P1", true);
        this.revoke("execute", "procedure s1", "p1", users[1]);
    }

    public void testPublicTablePrivileges() throws Exception {
        this.grant("select, references(c1)", "s2", "t2", "public");
        this.assertSelectPrivilege(true, users[4], "S2", "T2", null);
        this.assertSelectPrivilege(true, users[1], "S2", "T2", null);
        this.assertSelectPrivilege(false, users[4], "S2", "NOPERMS", null);
        this.assertUpdatePrivilege(false, users[4], "S2", "T2", null);
        this.assertReferencesPrivilege(true, users[4], "S2", "T2", new String[]{"C1"});
        this.assertReferencesPrivilege(false, users[4], "S2", "T2", null);
        this.revoke("select, references(c1)", "s2", "t2", "public");
    }

    public void testPublicRoutinePrivileges() throws Exception {
        this.grant("execute", "procedure s1", "p1", "public");
        this.grant("execute", "procedure s1", "p1", users[1]);
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.assertProcedurePrivilege(true, users[4], "S1", "P1");
        this.revoke("execute", "procedure s1", "p1", "public");
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.assertProcedurePrivilege(false, users[4], "S1", "P1");
        this.revoke("execute", "procedure s1", "p1", users[1]);
        this.assertProcedurePrivilege(false, users[1], "S1", "P1");
    }

    public void testGrantRollbackAndCommit() throws SQLException {
        Connection oc = this.openUserConnection(users[0]);
        oc.setAutoCommit(false);
        this.grant(oc, "select", "s2", "t2", "public");
        oc.commit();
        this.assertSelectPrivilege(true, users[3], "S2", "T2", null);
        this.assertUpdatePrivilege(false, users[3], "S2", "T2", null);
        this.assertSelectPrivilege(false, users[1], "S2", "T3", new String[]{"C2"});
        this.assertDeletePrivilege(false, users[1], "S2", "T3");
        this.assertTriggerPrivilege(false, users[2], "S2", "T2");
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.grant(oc, "select(c2),delete", "s2", "t3", users[1]);
        this.grant(oc, "trigger", "s2", "t2", "public");
        this.grant(oc, "execute", "function s1", "f1", users[1]);
        oc.rollback();
        this.assertSelectPrivilege(false, users[1], "S2", "T3", new String[]{"C2"});
        this.assertDeletePrivilege(false, users[1], "S2", "T3");
        this.assertTriggerPrivilege(false, users[2], "S2", "T2");
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.grant(oc, "select(c2),delete", "s2", "t3", users[1]);
        this.grant(oc, "trigger", "s2", "t2", "public");
        this.grant(oc, "execute", "function s1", "f1", users[1]);
        oc.commit();
        this.assertSelectPrivilege(true, users[1], "S2", "T3", new String[]{"C2"});
        this.assertDeletePrivilege(true, users[1], "S2", "T3");
        this.assertTriggerPrivilege(true, users[2], "S2", "T2");
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.revoke(oc, "select", "s2", "t2", "public");
        this.revoke(oc, "select(c2),delete", "s2", "t3", users[1]);
        this.revoke(oc, "trigger", "s2", "t2", "public");
        this.revoke(oc, "execute", "function s1", "f1", users[1]);
        oc.commit();
        oc.setAutoCommit(false);
        this.assertSelectPrivilege(false, users[3], "S2", "T2", null);
        this.assertUpdatePrivilege(false, users[3], "S2", "T2", null);
        this.assertSelectPrivilege(false, users[1], "S2", "T3", new String[]{"C2"});
        this.assertDeletePrivilege(false, users[1], "S2", "T3");
        this.assertTriggerPrivilege(false, users[2], "S2", "T2");
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        oc.close();
    }

    public void testGrantDatabaseMetaDataMethods() throws Exception {
        DatabaseMetaData dm = this.getConnection().getMetaData();
        GrantRevokeTest.assertFalse((String)"GrantRevoke: DatabaseMetaData.supportsCatalogsInPrivilegeDefinitionSupport", (boolean)dm.supportsCatalogsInPrivilegeDefinitions());
        GrantRevokeTest.assertTrue((String)"GrantRevoke: DatabaseMetaData.supportsSchemasInPrivilegeDefinitions", (boolean)dm.supportsSchemasInPrivilegeDefinitions());
    }

    public void testRevokeWithNoPermissions() throws Exception {
        this.assertSelectPrivilege(false, users[1], "S1", "T1", null);
        this.assertSelectPrivilege(false, users[2], "S1", "T1", new String[]{"C2"});
        this.assertUpdatePrivilege(false, users[2], "S1", "T1", new String[]{"C1", "C3"});
        this.assertProcedurePrivilege(false, users[1], "S1", "P1");
        this.revoke("all privileges", "s1", "t1", users[1]);
        this.assertSelectPrivilege(false, users[1], "S1", "T1", null);
        this.assertSelectPrivilege(false, users[1], "S1", "T1", new String[]{"C2"});
        this.revoke("execute", "procedure s1", "p1", users[1]);
        this.assertProcedurePrivilege(false, users[1], "S1", "P1");
        this.revoke("select(c2), update(c1,c3)", "s1", "t1", users[2]);
        this.assertSelectPrivilege(false, users[2], "S1", "T1", new String[]{"C2"});
        this.assertUpdatePrivilege(false, users[2], "S1", "T1", new String[]{"C1", "C3"});
    }

    public void testRevokeSingleTableSingleUser() throws Exception {
        this.grant("all privileges", "s2", "t1", users[1]);
        this.grant("update(c3)", "s2", "t1", users[1]);
        this.assertSelectPrivilege(true, users[1], "S2", "T1", null);
        this.assertUpdatePrivilege(true, users[1], "S2", "T1", new String[]{"C3"});
        this.revoke("update", "S2", "t1", users[1]);
        this.assertSelectPrivilege(true, users[1], "S2", "T1", null);
        this.assertUpdatePrivilege(false, users[1], "S2", "T1", null);
        this.assertUpdatePrivilege(false, users[1], "S2", "T1", new String[]{"C3"});
        this.assertInsertPrivilege(true, users[1], "S2", "T1", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T1");
        this.assertReferencesPrivilege(true, users[1], "S2", "T1", null);
        this.assertTriggerPrivilege(true, users[1], "S2", "T1");
        this.revoke("all privileges", "s2", "t1", users[1]);
        this.assertAllPrivileges(false, users[1], "S2", "T1", null);
    }

    public void testRevokeMultiplePermissionsMultipleUsers() throws SQLException {
        this.grant("select", "s1", "t1", new String[]{users[1], users[2], users[3]});
        this.grant("update(c1,c2,c3)", "s1", "t1", users[1]);
        this.grant("update(c3)", "s1", "t1", users[2]);
        this.grant("trigger", "s1", "t1", users[1]);
        this.assertSelectPrivilege(true, users[1], "S1", "T1", null);
        this.assertSelectPrivilege(true, users[2], "S1", "T1", null);
        this.assertSelectPrivilege(true, users[3], "S1", "T1", null);
        this.assertUpdatePrivilege(true, users[1], "S1", "T1", new String[]{"C1", "C2", "C3"});
        this.assertUpdatePrivilege(false, users[2], "S1", "T1", new String[]{"C1", "C2"});
        this.assertUpdatePrivilege(true, users[2], "S1", "T1", new String[]{"C3"});
        this.assertTriggerPrivilege(true, users[1], "S1", "T1");
        this.assertTriggerPrivilege(false, users[2], "S1", "T1");
        this.revoke("select, update(c2,c3)", "s1", "t1", new String[]{users[1], users[2], users[3]});
        this.assertSelectPrivilege(false, users[1], "S1", "T1", null);
        this.assertSelectPrivilege(false, users[2], "S1", "T1", null);
        this.assertSelectPrivilege(false, users[3], "S1", "T1", null);
        this.assertUpdatePrivilege(true, users[1], "S1", "T1", new String[]{"C1"});
        this.assertUpdatePrivilege(false, users[1], "S1", "T1", new String[]{"C2", "C3"});
        this.assertUpdatePrivilege(false, users[2], "S1", "T1", null);
        this.assertTriggerPrivilege(true, users[1], "S1", "T1");
        this.assertTriggerPrivilege(false, users[2], "S1", "T1");
        this.revoke("update", "s1", "t1", users[1]);
        this.assertUpdatePrivilege(false, users[1], "S1", "T1", new String[]{"C1"});
        this.assertUpdatePrivilege(false, users[1], "S1", "T1", null);
        this.revoke("all privileges", "s1", "t1", users[1]);
        this.assertAllPrivileges(false, users[1], "S1", "T1", null);
    }

    public void testRevokeExecutePrivileges() throws Exception {
        this.grant("execute", "function s1", "f1", new String[]{users[1], users[2]});
        this.grant("execute", "procedure s1", "f1", users[1]);
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertProcedurePrivilege(true, users[1], "S1", "F1");
        this.revoke("execute", "function s1", "f1", users[1]);
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertProcedurePrivilege(true, users[1], "S1", "F1");
        this.grant("execute", "function s1", "f1", users[1]);
        this.revoke("execute", "procedure s1", "f1", users[1]);
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertProcedurePrivilege(false, users[1], "S1", "F1");
        this.revoke("execute", "function s1", "f1", new String[]{users[1], users[2]});
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(false, users[2], "S1", "F1", false);
        this.assertProcedurePrivilege(false, users[1], "S1", "F1");
    }

    public void testRevokeWithPublicPrivilege() throws Exception {
        this.grant("select, delete", "s2", "t1", "public");
        this.grant("select, delete", "s2", "t1", new String[]{users[1], users[2]});
        this.grant("update(c1,c3)", "s2", "t1", "public");
        this.grant("update(c1,c3)", "s2", "t1", new String[]{users[1], users[2]});
        this.assertSelectPrivilege(true, users[1], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[2], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[4], "S2", "T1", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T1");
        this.assertDeletePrivilege(true, users[2], "S2", "T1");
        this.assertDeletePrivilege(true, users[4], "S2", "T1");
        this.assertUpdatePrivilege(true, users[1], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[2], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[4], "S2", "T1", new String[]{"C1", "C3"});
        this.revoke("select, update(c1,c3), delete", "S2", "T1", users[1]);
        this.assertSelectPrivilege(true, users[1], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[2], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[4], "S2", "T1", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T1");
        this.assertDeletePrivilege(true, users[2], "S2", "T1");
        this.assertDeletePrivilege(true, users[4], "S2", "T1");
        this.assertUpdatePrivilege(true, users[1], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[2], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[4], "S2", "T1", new String[]{"C1", "C3"});
        this.revoke("select, update(c1,c3), delete", "S2", "t1", "public");
        this.assertSelectPrivilege(false, users[1], "S2", "T1", null);
        this.assertSelectPrivilege(true, users[2], "S2", "T1", null);
        this.assertSelectPrivilege(false, users[4], "S2", "T1", null);
        this.assertDeletePrivilege(false, users[1], "S2", "T1");
        this.assertDeletePrivilege(true, users[2], "S2", "T1");
        this.assertDeletePrivilege(false, users[4], "S2", "T1");
        this.assertUpdatePrivilege(false, users[1], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(true, users[2], "S2", "T1", new String[]{"C1", "C3"});
        this.assertUpdatePrivilege(false, users[4], "S2", "T1", new String[]{"C1", "C3"});
        this.revoke("all privileges", "S2", "t1", users[2]);
        this.assertAllPrivileges(false, users[2], "S2", "T1", null);
    }

    public void testRevokeExecuteWithPublicPrivilege() throws Exception {
        this.grant("execute", "function s1", "f1", "public");
        this.grant("execute", "function s1", "f1", new String[]{users[1], users[2]});
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[4], "S1", "F1", false);
        this.revoke("execute", "function s1", "f1", users[1]);
        this.assertFunctionPrivilege(true, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[4], "S1", "F1", false);
        this.revoke("execute", "function s1", "f1", "public");
        this.assertFunctionPrivilege(false, users[1], "S1", "F1", false);
        this.assertFunctionPrivilege(true, users[2], "S1", "F1", false);
        this.assertFunctionPrivilege(false, users[4], "S1", "F1", false);
        this.revoke("execute", "function s1", "f1", users[2]);
        this.assertFunctionPrivilege(false, users[2], "s1", "F1", false);
    }

    public void testRevokeRollbackAndCommit() throws Exception {
        Connection oc = this.openUserConnection(users[0]);
        oc.setAutoCommit(false);
        this.grant(oc, "select(c1,c2), update(c1), insert, delete", "s2", "t3", users[1]);
        this.grant(oc, "select, references", "s2", "t3", users[2]);
        this.grant(oc, "select", "s2", "t3", users[3]);
        this.grant(oc, "execute", "procedure s1", "p1", users[1]);
        oc.commit();
        this.assertSelectPrivilege(true, users[1], "S2", "T3", new String[]{"C1", "C2"});
        this.assertUpdatePrivilege(true, users[1], "S2", "T3", new String[]{"C1"});
        this.assertInsertPrivilege(true, users[1], "S2", "T3", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T3");
        this.assertSelectPrivilege(true, users[2], "S2", "T3", null);
        this.assertReferencesPrivilege(true, users[2], "S2", "T3", null);
        this.assertSelectPrivilege(true, users[3], "S2", "T3", null);
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.revoke(oc, "select(c2), update(c1), delete", "s2", "t3", users[1]);
        this.revoke(oc, "select, references", "s2", "t3", users[2]);
        this.revoke(oc, "select", "s2", "t3", users[3]);
        this.revoke(oc, "execute", "procedure s1", "p1", users[1]);
        oc.rollback();
        this.assertSelectPrivilege(true, users[1], "S2", "T3", new String[]{"C1", "C2"});
        this.assertUpdatePrivilege(true, users[1], "S2", "T3", new String[]{"C1"});
        this.assertInsertPrivilege(true, users[1], "S2", "T3", null);
        this.assertDeletePrivilege(true, users[1], "S2", "T3");
        this.assertSelectPrivilege(true, users[2], "S2", "T3", null);
        this.assertReferencesPrivilege(true, users[2], "S2", "T3", null);
        this.assertSelectPrivilege(true, users[3], "S2", "T3", null);
        this.assertProcedurePrivilege(true, users[1], "S1", "P1");
        this.revoke(oc, "select(c2), update(c1), delete", "s2", "t3", users[1]);
        this.revoke(oc, "select, references", "s2", "t3", users[2]);
        this.revoke(oc, "select", "s2", "t3", users[3]);
        this.revoke(oc, "execute", "procedure s1", "p1", users[1]);
        oc.commit();
        oc.setAutoCommit(true);
        this.assertSelectPrivilege(false, users[1], "S2", "T3", new String[]{"C1", "C2"});
        this.assertUpdatePrivilege(false, users[1], "S2", "T3", new String[]{"C1"});
        this.assertInsertPrivilege(true, users[1], "S2", "T3", null);
        this.assertDeletePrivilege(false, users[1], "S2", "T3");
        this.assertSelectPrivilege(false, users[2], "S2", "T3", null);
        this.assertReferencesPrivilege(false, users[2], "S2", "T3", null);
        this.assertSelectPrivilege(false, users[3], "S2", "T3", null);
        this.assertProcedurePrivilege(false, users[1], "S1", "P1");
    }

    public void testInvalidGrantAction() throws Exception {
        try {
            this.grant("xx", "s1", "t1", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42X01", e);
        }
    }

    public void testInvalidReservedWordAction() throws Exception {
        try {
            this.grant("between", "s1", "t1", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42X01", e);
        }
        this.assertCompileError("42X01", "grant select on schema t1 to " + users[1]);
        this.assertCompileError("42X01", "grant select on decimal t1 to " + users[1]);
    }

    public void testGrantOnNonexistantColumn() throws Exception {
        try {
            this.grant("select(nosuchCol)", "s1", "t1", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42X14", e);
        }
    }

    public void testGrantOnNonexistantSchema() throws Exception {
        try {
            this.grant("select", "nosuch", "t1", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42Y07", e);
        }
    }

    public void testGrantOnNonexistantTable() throws Exception {
        try {
            this.grant("select(nosuchCol)", "s1", "nosuch", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42X05", e);
        }
    }

    public void testGrantOnFunctionWithBadSchema() throws Exception {
        try {
            this.grant("execute", "function nosuch", "f0", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42Y07", e);
        }
    }

    public void testGrantOnNonexistantFunction() throws Exception {
        block2: {
            try {
                this.grant("execute", "function s1", "nosuch", users[1]);
            }
            catch (SQLException e) {
                GrantRevokeTest.assertSQLState("42Y03", e);
                if (!Locale.getDefault().getLanguage().equals("en")) break block2;
                GrantRevokeTest.assertEquals((String)"'S1.NOSUCH' is not recognized as a function.", (String)e.getMessage());
            }
        }
    }

    public void testGrantOnNonexistantFunctionForProcedure() throws Exception {
        block2: {
            try {
                this.grant("execute", "function s1", "p1", users[1]);
            }
            catch (SQLException e) {
                GrantRevokeTest.assertSQLState("42Y03", e);
                if (!Locale.getDefault().getLanguage().equals("en")) break block2;
                GrantRevokeTest.assertEquals((String)"'S1.P1' is not recognized as a function.", (String)e.getMessage());
            }
        }
    }

    public void testGrantOnProcedureWithBadSchema() throws Exception {
        try {
            this.grant("execute", "procedure nosuch", "f0", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42Y07", e);
        }
    }

    public void testGrantOnNonexistantProcedure() throws Exception {
        block2: {
            try {
                this.grant("execute", "procedure s1", "nosuch", users[1]);
            }
            catch (SQLException e) {
                GrantRevokeTest.assertSQLState("42Y03", e);
                if (!Locale.getDefault().getLanguage().equals("en")) break block2;
                GrantRevokeTest.assertEquals((String)"'S1.NOSUCH' is not recognized as a procedure.", (String)e.getMessage());
            }
        }
    }

    public void testGrantOnNonexistantProcedureForFunction() throws Exception {
        block2: {
            try {
                this.grant("execute", "procedure s1", "f2", users[1]);
            }
            catch (SQLException e) {
                GrantRevokeTest.assertSQLState("42Y03", e);
                if (!Locale.getDefault().getLanguage().equals("en")) break block2;
                GrantRevokeTest.assertEquals((String)"'S1.F2' is not recognized as a procedure.", (String)e.getMessage());
            }
        }
    }

    public void testGrantExecuteOnTable() throws Exception {
        this.assertCompileError("42X01", "grant execute on table s1.t1 to " + users[1]);
    }

    public void testGrantSelectOnRoutine() throws Exception {
        this.assertCompileError("42X01", "grant select on function s1.f1 to " + users[1]);
        this.assertCompileError("42X01", "grant select on procedure s1.p1 to " + users[1]);
    }

    public void testGrantExecuteWithRestrict() throws Exception {
        this.assertCompileError("42X01", "grant execute on function s1.f1 to " + users[1] + " restrict");
    }

    public void testGrantRevokeWithoutRestrict() throws Exception {
        this.assertCompileError("42X01", "revoke execute on function s1.f1 from " + users[0]);
    }

    public void testGrantRevokeSelectWithRestrict() throws Exception {
        this.assertCompileError("42X01", "revoke select on s1.t1 from " + users[0] + " restrict");
    }

    public void testGrantDeleteWithColumnList() throws Exception {
        try {
            this.grant("delete(c1)", "s1", "t1", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42X01", e);
        }
    }

    public void testGrantTriggerWithColumnList() throws Exception {
        try {
            this.grant("trigger(c1)", "s1", "t1", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42X01", e);
        }
    }

    public void testOtherUserCannotRevokeOwnerPrivileges() throws SQLException {
        this.grant("select", "s1", "t1", "public");
        this.grant("insert", "s1", "t1", users[1]);
        this.grant("update", "s1", "t1", users[1]);
        this.grant("delete", "s1", "t1", users[1]);
        this.grant("update(c1)", "s1", "t1", users[2]);
        try {
            this.revoke(users[2], "select", "s1", "t1", "public");
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42506", e);
        }
        try {
            this.revoke(users[2], "select", "s1", "t1", users[0]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42509", e);
        }
        try {
            this.revoke(users[2], "insert", "s1", "t1", users[1]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42506", e);
        }
        try {
            this.revoke(users[2], "update(c1)", "s1", "t1", users[2]);
        }
        catch (SQLException e) {
            GrantRevokeTest.assertSQLState("42506", e);
        }
        this.revoke("select", "s1", "t1", "public");
        this.revoke("all privileges", "s1", "t1", users[1]);
        this.revoke("all privileges", "s1", "t1", users[2]);
        this.assertAllPrivileges(false, users[1], "S1", "T1", null);
        this.assertAllPrivileges(false, users[2], "S1", "T1", null);
    }

    public void testViewDefinersRights() throws Exception {
        this.grant("select", "appl", "\"VW_MyTasks\"", users[1]);
        this.grant("select", "appl", "\"VW_MyPriorityTasks\"", users[1]);
        this.grant("select", "appl", "\"VW2_MyPriorityTasks\"", users[1]);
        this.grant("select", "appl", "\"VW3_MyPriorityTasks\"", users[1]);
        this.assertSelectPrivilege(true, users[1], "appl", "\"VW_MyTasks\"", null);
        this.assertSelectPrivilege(true, users[1], "appl", "\"VW_MyPriorityTasks\"", null);
        this.assertSelectPrivilege(true, users[1], "appl", "\"VW2_MyPriorityTasks\"", null);
        this.assertSelectPrivilege(true, users[1], "appl", "\"VW3_MyPriorityTasks\"", null);
    }

    void grant(String perm, String schema, String table, String user) throws SQLException {
        this.grant(perm, schema, table, new String[]{user});
    }

    void grant(String grantor, String perm, String schema, String table, String user) throws SQLException {
        Connection c = this.openUserConnection(grantor);
        this.grant(c, perm, schema, table, user);
        c.close();
    }

    void grant(String perm, String schema, String table, String[] users) throws SQLException {
        StringBuffer command = new StringBuffer("grant " + perm + " on " + schema + "." + table + " to " + users[0]);
        for (int i = 1; i < users.length; ++i) {
            command.append("," + users[i]);
        }
        Statement s = this.getConnection().createStatement();
        s.executeUpdate(command.toString());
        s.close();
    }

    void grant(Connection c, String perm, String schema, String table, String user) throws SQLException {
        Statement s = c.createStatement();
        s.executeUpdate("grant " + perm + " on " + schema + "." + table + " to " + user);
        s.close();
    }

    void revoke(String perm, String schema, String table, String user) throws SQLException {
        this.revoke(perm, schema, table, new String[]{user});
    }

    void revoke(String revoker, String perm, String schema, String table, String user) throws SQLException {
        Connection c = this.openUserConnection(revoker);
        this.revoke(c, perm, schema, table, user);
        c.close();
    }

    void revoke(String perm, String schema, String table, String[] users) throws SQLException {
        StringBuffer command = new StringBuffer("revoke " + perm + " on " + schema + "." + table + " from " + users[0]);
        for (int i = 1; i < users.length; ++i) {
            command.append("," + users[i]);
        }
        if (perm.equalsIgnoreCase("execute")) {
            command.append(" restrict");
        }
        Statement s = this.createStatement();
        s.executeUpdate(command.toString());
        s.close();
    }

    void revoke(Connection c, String perm, String schema, String table, String user) throws SQLException {
        Statement s = c.createStatement();
        s.execute("revoke " + perm + " on " + schema + "." + table + " from " + user + (perm.equalsIgnoreCase("execute") ? " restrict" : ""));
        s.close();
    }

    public static int s1F1() {
        return 1;
    }

    public static int s2F1a() {
        return 1;
    }

    public static int s2F2() {
        return 1;
    }

    public static void s1F1P() {
    }

    public static void s1P1() {
    }

    public void assertAllPrivileges(boolean hasPrivilege, String user, String schema, String table, String[] columns) throws SQLException {
        this.assertSelectPrivilege(hasPrivilege, user, schema, table, columns);
        this.assertDeletePrivilege(hasPrivilege, user, schema, table);
        this.assertInsertPrivilege(hasPrivilege, user, schema, table, columns);
        this.assertUpdatePrivilege(hasPrivilege, user, schema, table, columns);
        this.assertReferencesPrivilege(hasPrivilege, user, schema, table, columns);
        this.assertTriggerPrivilege(hasPrivilege, user, schema, table);
    }

    public void assertSelectPrivilege(boolean hasPrivilege, String user, String schema, String table, String[] columns) throws SQLException {
        Connection c = this.openUserConnection(user);
        Statement s = c.createStatement();
        try {
            boolean b = s.execute("select " + GrantRevokeTest.columnListAsString(columns) + " from " + schema + "." + table);
            GrantRevokeTest.assertTrue((String)"expected no SELECT permission on table", (boolean)hasPrivilege);
        }
        catch (SQLException e) {
            if (!hasPrivilege) {
                GrantRevokeTest.assertSQLState("42502", e);
            }
            GrantRevokeTest.printStackTrace(e);
            GrantRevokeTest.fail("Unexpected lack of select privilege", e);
        }
        s.close();
        c.close();
        this.assertPrivilegeMetadata(hasPrivilege, "SELECT", user, schema, table, columns);
    }

    public void assertDeletePrivilege(boolean hasPrivilege, String user, String schema, String table) throws SQLException {
        Connection c = this.openUserConnection(user);
        Statement s = c.createStatement();
        try {
            boolean b = s.execute("delete from " + schema + "." + table);
            GrantRevokeTest.assertTrue((String)"expected no DELETE permission on table", (boolean)hasPrivilege);
        }
        catch (SQLException e) {
            if (!hasPrivilege) {
                GrantRevokeTest.assertSQLState("42500", e);
            }
            GrantRevokeTest.printStackTrace(e);
            GrantRevokeTest.fail("Unexpected lack of delete privilege", e);
        }
        s.close();
        c.close();
        this.assertPrivilegeMetadata(hasPrivilege, "DELETE", user, schema, table, null);
    }

    public void assertInsertPrivilege(boolean hasPrivilege, String user, String schema, String table, String[] columns) throws SQLException {
        Connection c = this.openUserConnection(user);
        Statement s = c.createStatement();
        try {
            StringBuffer command = new StringBuffer("insert into " + schema + "." + table + " values (");
            ResultSet rs = c.getMetaData().getColumns(null, schema, table, null);
            boolean first = true;
            while (rs.next()) {
                if (first) {
                    first = false;
                } else {
                    command.append(",");
                }
                GrantRevokeTest.appendColumnValue(command, rs.getInt(5));
            }
            rs.close();
            command.append(")");
            int i = s.executeUpdate(command.toString());
            GrantRevokeTest.assertTrue((String)"expected no INSERT permission on table", (boolean)hasPrivilege);
        }
        catch (SQLException e) {
            if (!hasPrivilege) {
                GrantRevokeTest.assertSQLState("42500", e);
            }
            GrantRevokeTest.fail("Unexpected lack of insert privilege on " + JDBC.escape(schema, table) + " by " + user, e);
        }
        s.close();
        c.close();
        this.assertPrivilegeMetadata(hasPrivilege, "INSERT", user, schema, table, columns);
    }

    public void assertUpdatePrivilege(boolean hasPrivilege, String user, String schema, String table, String[] columns) throws SQLException {
        String[] checkColumns = columns == null ? this.getAllColumns(schema, table) : columns;
        Connection c = this.openUserConnection(user);
        Statement s = c.createStatement();
        int columnCount = 0;
        for (int i = 0; i < checkColumns.length; ++i) {
            boolean checkCount = false;
            try {
                try {
                    ResultSet countRS = s.executeQuery("select count(" + checkColumns[i] + ") from " + schema + "." + table);
                    if (!countRS.next()) {
                        GrantRevokeTest.fail((String)("Could not get count on " + checkColumns[i] + " to verify update"));
                    }
                    columnCount = countRS.getInt(1);
                    checkCount = true;
                }
                catch (SQLException e) {
                    GrantRevokeTest.assertSQLState("42502", e);
                }
                StringBuffer command = new StringBuffer("update " + schema + "." + table + " set " + checkColumns[i] + "=");
                ResultSet rs = c.getMetaData().getColumns(null, schema, table, checkColumns[i]);
                if (!rs.next()) {
                    GrantRevokeTest.fail((String)("Could not get column metadata for " + checkColumns[i]));
                }
                GrantRevokeTest.appendColumnValue(command, rs.getInt(5));
                rs.close();
                int actualCount = s.executeUpdate(command.toString());
                if (hasPrivilege && checkCount) {
                    GrantRevokeTest.assertEquals((int)columnCount, (int)actualCount);
                }
                GrantRevokeTest.assertTrue((String)"expected no UPDATE permission on table", (boolean)hasPrivilege);
                continue;
            }
            catch (SQLException e) {
                if (!hasPrivilege) {
                    GrantRevokeTest.assertSQLState("42502", e);
                    continue;
                }
                GrantRevokeTest.printStackTrace(e);
                GrantRevokeTest.fail("Unexpected lack of privilege to update on " + JDBC.escape(schema, table) + " by " + user, e);
            }
        }
        s.close();
        c.close();
        this.assertPrivilegeMetadata(hasPrivilege, "UPDATE", user, schema, table, columns);
    }

    public void assertReferencesPrivilege(boolean hasPrivilege, String user, String schema, String table, String[] columns) throws SQLException {
        this.assertPrivilegeMetadata(hasPrivilege, "REFERENCES", user, schema, table, columns);
    }

    public void assertTriggerPrivilege(boolean hasPrivilege, String user, String schema, String table) throws SQLException {
        Connection c = this.openUserConnection(user);
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        try {
            int i = s.executeUpdate("create trigger \"" + table + "Trig\" after insert on " + schema + "." + table + " for each row values 1");
            if (hasPrivilege) {
                GrantRevokeTest.assertEquals((int)0, (int)i);
            }
            GrantRevokeTest.assertTrue((String)"expected no TRIGGER permission on table", (boolean)hasPrivilege);
        }
        catch (SQLException e) {
            if (!hasPrivilege) {
                GrantRevokeTest.assertSQLState("42500", e);
            }
            GrantRevokeTest.printStackTrace(e);
            GrantRevokeTest.fail("Unexpected lack of trigger privilege on " + JDBC.escape(schema, table) + " by " + user, e);
        }
        c.rollback();
        s.close();
        c.close();
        this.assertPrivilegeMetadata(hasPrivilege, "TRIGGER", user, schema, table, null);
    }

    public void assertFunctionPrivilege(boolean hasPrivilege, String user, String schema, String function, boolean forProcedure) throws SQLException {
        Connection c = this.openUserConnection(user);
        String functioncall = "values " + schema + "." + function + "()";
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = c.prepareStatement(functioncall);
            rs = ps.executeQuery();
            GrantRevokeTest.assertTrue((String)"expected no EXECUTE permission on function", (boolean)hasPrivilege);
        }
        catch (SQLException e) {
            if (!hasPrivilege) {
                if (forProcedure) {
                    GrantRevokeTest.assertSQLState("42Y03", e);
                } else {
                    GrantRevokeTest.assertSQLState("42504", e);
                }
            }
            GrantRevokeTest.printStackTrace(e);
            GrantRevokeTest.fail("Unexpected lack of function execute privilege", e);
        }
        if (ps != null) {
            ps.close();
        }
        if (rs != null) {
            rs.close();
        }
        c.close();
    }

    public void assertProcedurePrivilege(boolean hasPrivilege, String user, String schema, String procedure) throws SQLException {
        Connection c = this.openUserConnection(user);
        String procedurecall = "call " + schema + "." + procedure + "()";
        CallableStatement ps = c.prepareCall(procedurecall);
        ResultSet rs = null;
        try {
            ps.execute();
            rs = ps.getResultSet();
            GrantRevokeTest.assertTrue((String)"expected no EXECUTE permission on procedure", (boolean)hasPrivilege);
        }
        catch (SQLException e) {
            if (!hasPrivilege) {
                GrantRevokeTest.assertSQLState("42504", e);
            }
            GrantRevokeTest.printStackTrace(e);
            GrantRevokeTest.fail("Unexpected lack of procedure execute privilege", e);
        }
        ps.close();
        if (rs != null) {
            rs.close();
        }
        c.close();
    }

    public void assertPrivilegeMetadata(boolean hasPrivilege, String type, String user, String schema, String table, String[] columns) throws SQLException {
        Connection c = this.openUserConnection(user);
        DatabaseMetaData dm = c.getMetaData();
        schema = JDBC.identifierToCNF(schema);
        table = JDBC.identifierToCNF(table);
        ResultSet rs = dm.getTablePrivileges(null, schema, table);
        boolean found = false;
        if (columns == null) {
            while (rs.next()) {
                String privUser;
                GrantRevokeTest.assertEquals((String)rs.getString(4), (String)"TEST_DBO");
                GrantRevokeTest.assertEquals((String)rs.getString(7), (String)"NO");
                if (!rs.getString(6).equals(type) || !(privUser = rs.getString(5)).equals(user) && !privUser.equals("PUBLIC")) continue;
                found = true;
            }
            GrantRevokeTest.assertEquals((boolean)hasPrivilege, (boolean)found);
            rs.close();
        }
        ResultSet cp = null;
        if (columns != null) {
            for (int i = 0; i < columns.length; ++i) {
                cp = dm.getColumnPrivileges(null, schema.toUpperCase(), table.toUpperCase(), columns[i].toUpperCase());
                found = false;
                while (cp.next()) {
                    String privUser;
                    GrantRevokeTest.assertEquals((String)"TEST_DBO", (String)cp.getString(5));
                    GrantRevokeTest.assertEquals((String)"NO", (String)cp.getString(8));
                    if (!cp.getString(7).equals(type) || !(privUser = cp.getString(6)).equals(user) && !privUser.equals("PUBLIC")) continue;
                    found = true;
                }
                if (!hasPrivilege) continue;
                GrantRevokeTest.assertTrue((boolean)found);
            }
        }
        if (cp != null) {
            cp.close();
        }
        c.close();
    }

    static void appendColumnValue(StringBuffer sb, int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                sb.append("0");
                break;
            }
            case 1: 
            case 12: {
                sb.append("' '");
                break;
            }
            case 91: {
                sb.append("CURRENT_DATE");
                break;
            }
            case 92: {
                sb.append("CURRENT_TIME");
                break;
            }
            case 93: {
                sb.append("CURRENT_TIMESTAMP");
                break;
            }
            default: {
                sb.append("null");
            }
        }
    }

    static String columnListAsString(String[] columns) {
        if (columns == null) {
            return "*";
        }
        StringBuffer sb = new StringBuffer(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            sb.append("," + columns[i]);
        }
        return sb.toString();
    }

    String[] getAllColumns(String schema, String table) throws SQLException {
        DatabaseMetaData dbmd = this.getConnection().getMetaData();
        ArrayList<String> columnList = new ArrayList<String>();
        ResultSet rs = dbmd.getColumns(null, schema, table, null);
        while (rs.next()) {
            columnList.add(rs.getString(4));
        }
        return columnList.toArray(new String[columnList.size()]);
    }

    String getColumnDataType(String schema, String table, String column) throws SQLException {
        DatabaseMetaData dm = this.getConnection().getMetaData();
        ResultSet rs = dm.getColumns(null, schema, table, column);
        int type = 0;
        while (rs.next()) {
            type = rs.getInt(5);
        }
        rs.close();
        return JDBC.sqlNameFromJdbc(type);
    }
}

