/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.client;

import org.apache.derbyTesting.system.oe.client.Submitter;

public class MultiThreadSubmitter {
    public static long multiRun(Submitter[] submitters, Object[] displays, int count) {
        int i;
        Thread[] threads = new Thread[submitters.length];
        for (int i2 = 0; i2 < submitters.length; ++i2) {
            submitters[i2].clearTransactionCount();
            Object displayData = displays == null ? null : displays[i2];
            threads[i2] = MultiThreadSubmitter.newThread(i2, submitters[i2], displayData, count);
        }
        long start = System.currentTimeMillis();
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        for (i = 0; i < threads.length; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        long end = System.currentTimeMillis();
        return end - start;
    }

    private static Thread newThread(int threadId, final Submitter submitter, final Object displayData, final int count) {
        Thread t = new Thread("OE_Thread:" + threadId){

            @Override
            public void run() {
                try {
                    submitter.runTransactions(displayData, count);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        return t;
    }
}

