/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.AuthenticationTest;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class PoolDSAuthenticationTest
extends AuthenticationTest {
    public PoolDSAuthenticationTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("ConnectionPoolDataSource not available with JSR169; empty test");
        }
        BaseTestSuite suite = new BaseTestSuite("PoolDSAuthenticationTest");
        suite.addTest(PoolDSAuthenticationTest.baseSuite("PoolDSAuthenticationTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(PoolDSAuthenticationTest.baseSuite("PoolDSAuthenticationTest:client")));
        return suite;
    }

    public static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite("PoolDSAuthenticationTest");
        PoolDSAuthenticationTest test = new PoolDSAuthenticationTest("testConnectShutdownAuthentication");
        PoolDSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new PoolDSAuthenticationTest("testUserFunctions");
        PoolDSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new PoolDSAuthenticationTest("testNotFullAccessUsers");
        PoolDSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new PoolDSAuthenticationTest("testChangePasswordAndDatabasePropertiesOnly");
        PoolDSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new PoolDSAuthenticationTest("testGreekCharacters");
        PoolDSAuthenticationTest.setBaseProps(suite, (Test)test);
        test = new PoolDSAuthenticationTest("testSystemShutdown");
        PoolDSAuthenticationTest.setBaseProps(suite, (Test)test);
        return TestConfiguration.singleUseDatabaseDecorator((Test)suite);
    }

    @Override
    protected void assertConnectionOK(String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        pds.getPooledConnection(user, password).close();
    }

    @Override
    protected void assertConnectionWOUPOK(String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(pds, "user", user);
        JDBCDataSource.setBeanProperty(pds, "password", password);
        pds.getPooledConnection().close();
    }

    @Override
    protected void assertConnectionFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        try {
            pds.getPooledConnection(user, password);
            PoolDSAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertConnectionWOUPFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(pds, "user", user);
        JDBCDataSource.setBeanProperty(pds, "password", password);
        try {
            pds.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"Connection should've been refused/failed");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertShutdownUsingSetShutdownOK(String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(pds, "shutdownDatabase", "shutdown");
        try {
            pds.getPooledConnection(user, password);
            PoolDSAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState("08006", e);
        }
    }

    @Override
    protected void assertShutdownUsingConnAttrsOK(String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(pds, "connectionAttributes", "shutdown=true");
        try {
            pds.getPooledConnection(user, password);
            PoolDSAuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState("08006", e);
        }
    }

    @Override
    protected void assertShutdownWOUPOK(String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(pds, "user", user);
        JDBCDataSource.setBeanProperty(pds, "password", password);
        JDBCDataSource.setBeanProperty(pds, "shutdownDatabase", "shutdown");
        try {
            pds.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected a failed shutdown connection");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState("08006", e);
        }
    }

    @Override
    protected void assertShutdownFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(pds, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        try {
            pds.getPooledConnection(user, password);
            PoolDSAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertShutdownWOUPFail(String expectedSqlState, String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.setBeanProperty(pds, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(pds, "user", user);
        JDBCDataSource.setBeanProperty(pds, "password", password);
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        try {
            pds.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected failed shutdown");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState(expectedSqlState, e);
        }
    }

    @Override
    protected void assertSystemShutdownOK(String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.clearStringBeanProperty(pds, "databaseName");
        JDBCDataSource.setBeanProperty(pds, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(pds, "user", user);
        JDBCDataSource.setBeanProperty(pds, "password", password);
        try {
            pds.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected system shutdown resulting in XJ015 error");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState("XJ015", e);
        }
    }

    @Override
    protected void assertSystemShutdownFail(String expectedError, String dbName, String user, String password) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        JDBCDataSource.clearStringBeanProperty(pds, "databaseName");
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        JDBCDataSource.setBeanProperty(pds, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(pds, "user", user);
        JDBCDataSource.setBeanProperty(pds, "password", password);
        try {
            pds.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected shutdown to fail");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState(expectedError, e);
        }
    }

    @Override
    public void assertConnectionFail(String dbName) throws SQLException {
        ConnectionPoolDataSource pds = J2EEDataSource.getConnectionPoolDataSource();
        if (PoolDSAuthenticationTest.usingDerbyNetClient()) {
            JDBCDataSource.setBeanProperty(pds, "user", "APP");
        } else {
            JDBCDataSource.clearStringBeanProperty(pds, "user");
        }
        JDBCDataSource.clearStringBeanProperty(pds, "password");
        JDBCDataSource.setBeanProperty(pds, "databaseName", dbName);
        try {
            pds.getPooledConnection();
            PoolDSAuthenticationTest.fail((String)"expected connection to fail");
        }
        catch (SQLException e) {
            PoolDSAuthenticationTest.assertSQLState("08004", e);
        }
    }
}

