/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;

public class ShutdownMaster
extends BaseJDBCTestCase {
    private static ReplicationRun repRun = new ReplicationRun("ShutdownMaster");
    static String jvmVersion = null;
    static String derbyVersion = null;
    static String masterServerHost = null;
    static int masterServerPort = -1;
    static String masterDatabasePath = null;
    static String slaveServerHost = null;
    static int slaveServerPort = -1;
    static String slaveDatabasePath = null;

    public ShutdownMaster(String testcaseName) {
        super(testcaseName);
    }

    static void setEnv() throws Exception {
        repRun.initEnvironment();
        masterServerHost = ReplicationRun.masterServerHost;
        masterServerPort = ReplicationRun.masterServerPort;
        slaveServerHost = ReplicationRun.slaveServerHost;
        slaveServerPort = ReplicationRun.slaveServerPort;
        jvmVersion = ReplicationRun.masterJvmVersion;
        derbyVersion = ReplicationRun.derbyMasterVersion;
        masterDatabasePath = ReplicationRun.masterDatabasePath;
        slaveDatabasePath = ReplicationRun.slaveDatabasePath;
    }

    void shutdown(String url, boolean dbOnly, boolean killServer) throws SQLException, IOException, InterruptedException {
        System.out.println("**** ShutdownMaster.shutdown() " + this.getTestConfiguration().getJDBCClient().getJDBCDriverName() + " url: " + url + " dbOnly: " + dbOnly + " killServer: " + killServer);
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("create table t (i integer primary key, vc varchar(20))");
        PreparedStatement pSt = this.prepareStatement("insert into t values (?,?)");
        boolean expectNoConnection = false;
        for (int i = 0; i < 1000; ++i) {
            String state;
            String msg;
            int errCode;
            try {
                pSt.setInt(1, i);
                pSt.setString(2, "i" + i);
                pSt.execute();
            }
            catch (SQLException se) {
                errCode = se.getErrorCode();
                msg = se.getMessage();
                state = se.getSQLState();
                System.out.println("execute Got SQLException: " + errCode + " " + state + " " + msg);
                if (expectNoConnection && errCode == 40000 && state.equalsIgnoreCase("08006")) {
                    System.out.println("As expected - connection terminated. Quit.");
                    return;
                }
                throw se;
            }
            System.out.println("i: " + i);
            if (i != 500) continue;
            if (killServer) {
                repRun.killMaster(masterServerHost, masterServerPort);
                expectNoConnection = true;
                continue;
            }
            if (url == null) {
                System.out.println("**** stopServer: " + masterServerHost + ":" + masterServerPort);
                repRun.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
                expectNoConnection = true;
                continue;
            }
            System.out.println("**** DriverManager.getConnection(\"" + url + ";shutdown=true\");");
            try {
                DriverManager.getConnection(url + ";shutdown=true");
                continue;
            }
            catch (SQLException se) {
                errCode = se.getErrorCode();
                msg = se.getMessage();
                state = se.getSQLState();
                String expectedState = dbOnly ? "08006" : "XJ015";
                int expectedCode = dbOnly ? 45000 : 50000;
                System.out.println("shutdown Got SQLException: " + errCode + " " + state + " " + msg);
                if (errCode == expectedCode && state.equalsIgnoreCase(expectedState)) {
                    System.out.println("As expected.");
                    expectNoConnection = true;
                    continue;
                }
                throw se;
            }
        }
        ShutdownMaster.assertTrue((String)"Should never reach this point in the ShutdownMaster test with PoC V2d!", (boolean)false);
        ResultSet rs = s.executeQuery("select count(*) from t");
        rs.next();
        int count = rs.getInt(1);
        System.out.println("count: " + count);
    }
}

