/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LiveLockTest
extends BaseJDBCTestCase {
    private LinkedList<Exception> listExceptions = new LinkedList();
    private Object syncObject = new Object();
    private boolean updateDone = false;

    public LiveLockTest(String name) {
        super(name);
    }

    public void testLiveLock() throws Exception {
        Thread[] t = this.createThreads();
        this.waitForThreads(t);
        this.checkExceptions();
    }

    private void checkExceptions() throws Exception {
        Iterator iterator = this.listExceptions.iterator();
        if (iterator.hasNext()) {
            Exception e = (Exception)iterator.next();
            throw e;
        }
    }

    private void waitForThreads(Thread[] t) {
        for (int i = 0; i < t.length; ++i) {
            try {
                t[i].join();
                continue;
            }
            catch (InterruptedException e) {
                LiveLockTest.fail((String)"FAIL - InterruptedException  thrown waiting for the threads");
            }
        }
    }

    private Thread[] createThreads() {
        Thread[] t = new Thread[]{new Thread(new Runnable(){

            @Override
            public void run() {
                LiveLockTest.this.selectWorker(0);
            }
        }, "SelectThread1"), new Thread(new Runnable(){

            @Override
            public void run() {
                LiveLockTest.this.selectWorker(1000);
            }
        }, "SelectThread2"), new Thread(new Runnable(){

            @Override
            public void run() {
                LiveLockTest.this.updateWorker();
            }
        }, "UpdateThread")};
        t[0].start();
        t[1].start();
        t[2].start();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectWorker(int delay) {
        Connection threadConnection = null;
        try {
            if (delay > 0) {
                Thread.sleep(delay);
            }
            threadConnection = this.openDefaultConnection();
            Statement stmt = threadConnection.createStatement();
            threadConnection.setAutoCommit(false);
            threadConnection.setTransactionIsolation(4);
            int tries = 0;
            while (!this.isUpdateDone()) {
                ResultSet rs = stmt.executeQuery("select * from t");
                while (rs.next()) {
                }
                Thread.sleep(4000L);
                threadConnection.commit();
                if (++tries != 10) continue;
                LiveLockTest.fail((String)"Update did not occur after 10 selects");
            }
        }
        catch (Exception e) {
            Object object = this.syncObject;
            synchronized (object) {
                this.listExceptions.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWorker() {
        Connection threadConnection = null;
        try {
            Thread.sleep(2000L);
            threadConnection = this.openDefaultConnection();
            Statement stmt = threadConnection.createStatement();
            stmt.executeUpdate("UPDATE T SET I = 456 where I = 456");
            Object object = this.syncObject;
            synchronized (object) {
                this.setUpdateDone(true);
                threadConnection.commit();
            }
        }
        catch (Exception e) {
            Object object = this.syncObject;
            synchronized (object) {
                this.listExceptions.add(e);
            }
        }
    }

    public static Test suite() {
        Test suite = TestConfiguration.embeddedSuite(LiveLockTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts(suite, 1, 10)){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.executeUpdate("CREATE TABLE T (I INT)");
                s.executeUpdate("INSERT INTO T VALUES(456)");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpdateDone() {
        Object object = this.syncObject;
        synchronized (object) {
            return this.updateDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUpdateDone(boolean updateDone) {
        Object object = this.syncObject;
        synchronized (object) {
            this.updateDone = updateDone;
        }
    }
}

