/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.jdbc.PositionedStoreStream;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class PositionedStoreStreamTest
extends BaseTestCase {
    public PositionedStoreStreamTest(String name) {
        super(name);
    }

    public void testPositionAfterEOFRead() throws IOException, StandardException {
        LoopingAlphabetStream in = new LoopingAlphabetStream(10L);
        PositionedStoreStream pss = new PositionedStoreStream((InputStream)in);
        PositionedStoreStreamTest.assertEquals((long)0L, (long)pss.getPosition());
        for (int i = 0; i < 10; ++i) {
            pss.read();
            PositionedStoreStreamTest.assertEquals((long)(i + 1), (long)pss.getPosition());
        }
        PositionedStoreStreamTest.assertEquals((long)10L, (long)pss.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)pss.read());
        PositionedStoreStreamTest.assertEquals((long)10L, (long)pss.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)pss.read());
        PositionedStoreStreamTest.assertEquals((long)0L, (long)pss.skip(199L));
        PositionedStoreStreamTest.assertEquals((long)10L, (long)pss.getPosition());
        pss.resetStream();
        PositionedStoreStreamTest.assertEquals((long)0L, (long)pss.getPosition());
    }

    public void testPositionAfterEOFReadArray() throws IOException, StandardException {
        LoopingAlphabetStream in = new LoopingAlphabetStream(10L);
        PositionedStoreStream pss = new PositionedStoreStream((InputStream)in);
        PositionedStoreStreamTest.assertEquals((long)0L, (long)pss.getPosition());
        byte[] two = new byte[2];
        for (int i = 0; i < 10; i += 2) {
            PositionedStoreStreamTest.assertEquals((int)2, (int)pss.read(two, 0, 2));
            PositionedStoreStreamTest.assertEquals((long)(i + 2), (long)pss.getPosition());
        }
        PositionedStoreStreamTest.assertEquals((long)10L, (long)pss.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)pss.read(two, 0, 2));
        PositionedStoreStreamTest.assertEquals((long)10L, (long)pss.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)pss.read(two, 0, 2));
        PositionedStoreStreamTest.assertEquals((long)0L, (long)pss.skip(21L));
        PositionedStoreStreamTest.assertEquals((int)-1, (int)pss.read());
        PositionedStoreStreamTest.assertEquals((long)10L, (long)pss.getPosition());
        pss.resetStream();
        PositionedStoreStreamTest.assertEquals((long)0L, (long)pss.getPosition());
    }

    public void testReadEverythingInOneGo() throws IOException, StandardException {
        LoopingAlphabetStream in = new LoopingAlphabetStream(127L);
        PositionedStoreStream pss = new PositionedStoreStream((InputStream)in);
        byte[] b = new byte[256];
        for (int i = 0; i < 3; ++i) {
            Arrays.fill(b, (byte)-1);
            PositionedStoreStreamTest.assertEquals((int)127, (int)pss.read(b, 0, 256));
            PositionedStoreStreamTest.assertEquals((int)-1, (int)pss.read(b, 127, 10));
            PositionedStoreStreamTest.assertEquals((int)-1, (int)b[127]);
            PositionedStoreStreamTest.assertTrue((-1 != b[126] ? 1 : 0) != 0);
            PositionedStoreStreamTest.assertEquals((int)97, (int)b[0]);
            pss.reposition(0L);
        }
    }

    public void testRepositionForwards() throws IOException, StandardException {
        LoopingAlphabetStream inComp;
        long length = 20L;
        LoopingAlphabetStream in = new LoopingAlphabetStream(20L);
        PositionedStoreStream pss = new PositionedStoreStream((InputStream)in);
        PositionedStoreStreamTest.assertEquals((long)0L, (long)pss.getPosition());
        int i = 0;
        while ((long)i < 20L) {
            inComp = new LoopingAlphabetStream(20L);
            pss.reposition((long)i);
            inComp.skip(i);
            PositionedStoreStreamTest.assertEquals((int)((InputStream)inComp).read(), (int)pss.read());
            ++i;
        }
        i = 1;
        while ((long)i < 20L) {
            inComp = new LoopingAlphabetStream(20L);
            pss.reposition((long)i);
            inComp.skip(i);
            PositionedStoreStreamTest.assertEquals((int)((InputStream)inComp).read(), (int)pss.read());
            i += 2;
        }
    }

    public void testRepositionBackwards() throws IOException, StandardException {
        LoopingAlphabetStream inComp;
        int i;
        long length = 20L;
        LoopingAlphabetStream in = new LoopingAlphabetStream(20L);
        PositionedStoreStream pss = new PositionedStoreStream((InputStream)in);
        PositionedStoreStreamTest.assertEquals((long)0L, (long)pss.getPosition());
        for (i = 20; i >= 0; --i) {
            inComp = new LoopingAlphabetStream(20L);
            pss.reposition((long)i);
            inComp.skip(i);
            PositionedStoreStreamTest.assertEquals((int)((InputStream)inComp).read(), (int)pss.read());
        }
        for (i = 19; i >= 0; i -= 2) {
            inComp = new LoopingAlphabetStream(20L);
            pss.reposition((long)i);
            inComp.skip(i);
            PositionedStoreStreamTest.assertEquals((int)((InputStream)inComp).read(), (int)pss.read());
        }
    }

    public void testSimpleReadSequence() throws IOException, StandardException {
        LoopingAlphabetStream in = new LoopingAlphabetStream(26L);
        PositionedStoreStream pss = new PositionedStoreStream((InputStream)in);
        PositionedStoreStreamTest.assertEquals((int)97, (int)pss.read());
        pss.reposition(9L);
        PositionedStoreStreamTest.assertEquals((int)106, (int)pss.read());
        pss.reposition(10L);
        PositionedStoreStreamTest.assertEquals((int)107, (int)pss.read());
        pss.reposition(9L);
        PositionedStoreStreamTest.assertEquals((int)106, (int)pss.read());
        pss.reposition(25L);
        PositionedStoreStreamTest.assertEquals((int)122, (int)pss.read());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)pss.read());
        pss.reposition(1L);
        PositionedStoreStreamTest.assertEquals((int)98, (int)pss.read());
        pss.reposition(1L);
        PositionedStoreStreamTest.assertEquals((int)98, (int)pss.read());
    }

    public void testDerby3735() throws IOException, StandardException {
        LoopingAlphabetStream in = new LoopingAlphabetStream(2L);
        PositionedStoreStream pss = new PositionedStoreStream((InputStream)in);
        byte[] b = new byte[2];
        for (int i = 0; i < 10; ++i) {
            pss.read(b);
            PositionedStoreStreamTest.println("Position at iteration " + i + ": " + pss.getPosition());
        }
        pss.reposition(0L);
    }

    public void testDerby3781() throws IOException, StandardException {
        long size = 10L;
        LoopingAlphabetStream in = new LoopingAlphabetStream(10L);
        PositionedStoreStream pss = new PositionedStoreStream((InputStream)in);
        PositionedStoreStreamTest.assertEquals((String)"Invalid initial position", (long)0L, (long)pss.getPosition());
        pss.reposition(9L);
        PositionedStoreStreamTest.assertEquals((long)9L, (long)pss.getPosition());
        PositionedStoreStreamTest.assertEquals((int)106, (int)pss.read());
        PositionedStoreStreamTest.assertEquals((long)10L, (long)pss.getPosition());
        PositionedStoreStreamTest.assertEquals((int)-1, (int)pss.read());
        pss.reposition(5L);
        PositionedStoreStreamTest.assertEquals((long)5L, (long)pss.getPosition());
        try {
            pss.reposition(20L);
            PositionedStoreStreamTest.fail((String)"Should have failed with EOFException");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        pss.reposition(9L);
        PositionedStoreStreamTest.assertEquals((long)9L, (long)pss.getPosition());
        PositionedStoreStreamTest.assertEquals((int)106, (int)pss.read());
    }

    public static Test suite() {
        return new BaseTestSuite(PositionedStoreStreamTest.class, "PositionedStoreStreamTest");
    }
}

