/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.math.BigInteger;

final class ConsistencyToken {
    private final byte[] bytes;
    private int hash = 0;

    ConsistencyToken(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ConsistencyToken)) {
            return false;
        }
        ConsistencyToken ct = (ConsistencyToken)o;
        int len = this.bytes.length;
        if (len != ct.bytes.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.bytes[i] == ct.bytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            int len = this.bytes.length;
            for (int i = 0; i < len; ++i) {
                h ^= this.bytes[i];
            }
            this.hash = h;
        }
        return h;
    }

    public String toString() {
        return new BigInteger(this.bytes).toString();
    }
}

