/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

class SYSFILESRowFactory
extends CatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSFILES";
    private static final int SYSFILES_COLUMN_COUNT = 4;
    private static final int ID_COL_NUM = 1;
    private static final String ID_COL_NAME = "FILEID";
    private static final int SCHEMA_ID_COL_NUM = 2;
    private static final String SCHEMA_ID_COL_NAME = "SCHEMAID";
    private static final int NAME_COL_NUM = 3;
    private static final String NAME_COL_NAME = "FILENAME";
    private static final int GENERATION_ID_COL_NUM = 4;
    private static final String GENERATION_ID_COL_NAME = "GENERATIONID";
    static final int SYSFILES_INDEX1_ID = 0;
    static final int SYSFILES_INDEX2_ID = 1;
    private static final int[][] indexColumnPositions = new int[][]{{3, 2}, {1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"80000000-00d3-e222-873f-000a0a0b1900", "80000000-00d3-e222-9920-000a0a0b1900", "80000000-00d3-e222-a373-000a0a0b1900", "80000000-00d3-e222-be7b-000a0a0b1900"};

    SYSFILESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(4, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String id_S = null;
        String schemaId_S = null;
        String SQLname = null;
        long generationId = 0L;
        if (td != null) {
            FileInfoDescriptor descriptor = (FileInfoDescriptor)td;
            id_S = descriptor.getUUID().toString();
            schemaId_S = descriptor.getSchemaDescriptor().getUUID().toString();
            SQLname = descriptor.getName();
            generationId = descriptor.getGenerationId();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(4);
        row.setColumn(1, new SQLChar(id_S));
        row.setColumn(2, new SQLChar(schemaId_S));
        row.setColumn(3, new SQLVarchar(SQLname));
        row.setColumn(4, new SQLLongint(generationId));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        if (row.nColumns() != 4) {
            SanityManager.THROWASSERT("Wrong number of columns for a SYSFILES row: " + row.nColumns());
        }
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        DataValueDescriptor col = row.getColumn(1);
        String id_S = col.getString();
        UUID id = this.getUUIDFactory().recreateUUID(id_S);
        col = row.getColumn(2);
        String schemaId_S = col.getString();
        UUID schemaId = this.getUUIDFactory().recreateUUID(schemaId_S);
        SchemaDescriptor schemaDescriptor = dd.getSchemaDescriptor(schemaId, null);
        if (schemaDescriptor == null) {
            SanityManager.THROWASSERT("Missing schema for FileInfo: " + id_S);
        }
        col = row.getColumn(3);
        String name = col.getString();
        col = row.getColumn(4);
        long generationId = col.getLong();
        FileInfoDescriptor result = ddg.newFileInfoDescriptor(id, schemaDescriptor, name, generationId);
        return result;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn(ID_COL_NAME, false), SystemColumnImpl.getUUIDColumn(SCHEMA_ID_COL_NAME, false), SystemColumnImpl.getIdentifierColumn(NAME_COL_NAME, false), SystemColumnImpl.getColumn(GENERATION_ID_COL_NAME, -5, false)};
    }
}

