/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.shared.common.sanity.SanityManager;

public class StatementRolePermission
extends StatementPermission {
    private String roleName;
    private int privType;

    public StatementRolePermission(String roleName, int privType) {
        this.roleName = roleName;
        this.privType = privType;
    }

    @Override
    public void check(LanguageConnectionContext lcc, boolean forGrant, Activation activation) throws StandardException {
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        switch (this.privType) {
            case 19: {
                throw StandardException.newException("4251A", "CREATE ROLE");
            }
            case 20: {
                throw StandardException.newException("4251A", "DROP ROLE");
            }
        }
        SanityManager.THROWASSERT("Unexpected value (" + this.privType + ") for privType");
    }

    @Override
    public PermissionsDescriptor getPermissionDescriptor(String authid, DataDictionary dd) throws StandardException {
        return null;
    }

    private String getPrivName() {
        switch (this.privType) {
            case 19: {
                return "CREATE_ROLE";
            }
            case 20: {
                return "DROP_ROLE";
            }
        }
        return "?";
    }

    public String toString() {
        return "StatementRolePermission: " + this.roleName + " " + this.getPrivName();
    }
}

