/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryListOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;
import org.apache.derby.shared.common.sanity.SanityManager;

class BetweenOperatorNode
extends BinaryListOperatorNode {
    BetweenOperatorNode(ValueNode leftOperand, ValueNodeList betweenValues, ContextManager cm) throws StandardException {
        super(leftOperand, BetweenOperatorNode.vetValues(betweenValues), "BETWEEN", null, cm);
    }

    private static ValueNodeList vetValues(ValueNodeList betweenValues) {
        ValueNodeList betweenVals = betweenValues;
        SanityManager.ASSERT(betweenVals.size() == 2, "betweenValues.size() (" + betweenVals.size() + ") is expected to be 2");
        return betweenValues;
    }

    @Override
    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        SanityManager.ASSERT(this.rightOperandList.size() == 2, "rightOperandList.size() (" + this.rightOperandList.size() + ") is expected to be 2");
        if (!underNotNode) {
            return this;
        }
        ContextManager cm = this.getContextManager();
        BinaryRelationalOperatorNode leftBCO = new BinaryRelationalOperatorNode(4, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), false, cm);
        leftBCO.bindComparisonOperator();
        ValueNode leftClone = this.leftOperand instanceof ColumnReference ? this.leftOperand.getClone() : this.leftOperand;
        BinaryRelationalOperatorNode rightBCO = new BinaryRelationalOperatorNode(2, leftClone, (ValueNode)this.rightOperandList.elementAt(1), false, cm);
        rightBCO.bindComparisonOperator();
        OrNode newOr = new OrNode(leftBCO, rightBCO, cm);
        newOr.postBindFixup();
        leftBCO.setBetweenSelectivity();
        rightBCO.setBetweenSelectivity();
        return newOr;
    }

    @Override
    ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        super.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (!(this.leftOperand instanceof ColumnReference)) {
            return this;
        }
        ValueNode leftClone1 = this.leftOperand.getClone();
        ContextManager cm = this.getContextManager();
        BooleanConstantNode trueNode = new BooleanConstantNode(true, cm);
        BinaryRelationalOperatorNode lessEqual = new BinaryRelationalOperatorNode(3, leftClone1, (ValueNode)this.rightOperandList.elementAt(1), false, cm);
        lessEqual.bindComparisonOperator();
        AndNode newAnd = new AndNode(lessEqual, trueNode, cm);
        newAnd.postBindFixup();
        BinaryRelationalOperatorNode greaterEqual = new BinaryRelationalOperatorNode(1, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), false, cm);
        greaterEqual.bindComparisonOperator();
        newAnd = new AndNode(greaterEqual, newAnd, cm);
        newAnd.postBindFixup();
        lessEqual.setBetweenSelectivity();
        greaterEqual.setBetweenSelectivity();
        return newAnd;
    }

    @Override
    void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.rightOperandList.size() == 2, "rightOperandList.size() (" + this.rightOperandList.size() + ") is expected to be 2");
        ContextManager cm = this.getContextManager();
        BinaryRelationalOperatorNode leftBCO = new BinaryRelationalOperatorNode(1, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(0), false, cm);
        leftBCO.bindComparisonOperator();
        BinaryRelationalOperatorNode rightBCO = new BinaryRelationalOperatorNode(3, this.leftOperand, (ValueNode)this.rightOperandList.elementAt(1), false, cm);
        rightBCO.bindComparisonOperator();
        AndNode newAnd = new AndNode(leftBCO, rightBCO, cm);
        newAnd.postBindFixup();
        newAnd.generateExpression(acb, mb);
    }
}

