/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

class GrantRoleNode
extends DDLStatementNode {
    private List<String> roles;
    private List<String> grantees;

    GrantRoleNode(List<String> roles, List<String> grantees, ContextManager cm) throws StandardException {
        super(null, cm);
        this.roles = roles;
        this.grantees = grantees;
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getGrantRoleConstantAction(this.roles, this.grantees);
    }

    @Override
    public String toString() {
        StringBuilder sb1 = new StringBuilder();
        for (String role : this.roles) {
            if (sb1.length() > 0) {
                sb1.append(", ");
            }
            sb1.append(role);
        }
        StringBuilder sb2 = new StringBuilder();
        for (String grantee : this.grantees) {
            if (sb2.length() > 0) {
                sb2.append(", ");
            }
            sb2.append(grantee);
        }
        return super.toString() + sb1.toString() + " TO: " + sb2.toString() + "\n";
    }

    @Override
    public String statementToString() {
        return "GRANT role";
    }
}

