/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.conglomerate;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanInfo;
import org.apache.derby.iapi.store.access.conglomerate.ScanManager;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.store.access.conglomerate.GenericController;
import org.apache.derby.impl.store.access.conglomerate.OpenConglomerate;
import org.apache.derby.impl.store.access.conglomerate.RowPosition;
import org.apache.derby.shared.common.sanity.SanityManager;

public abstract class GenericScanController
extends GenericController
implements ScanManager {
    public static final int SCAN_INIT = 1;
    public static final int SCAN_INPROGRESS = 2;
    public static final int SCAN_DONE = 3;
    public static final int SCAN_HOLD_INIT = 4;
    public static final int SCAN_HOLD_INPROGRESS = 5;
    private FormatableBitSet init_scanColumnList;
    private DataValueDescriptor[] init_startKeyValue;
    private int init_startSearchOperator;
    private Qualifier[][] init_qualifier;
    private DataValueDescriptor[] init_stopKeyValue;
    private int init_stopSearchOperator;
    private FetchDescriptor init_fetchDesc;
    private int scan_state;
    protected boolean rowLocationsInvalidated = false;
    private long reusableRecordIdSequenceNumber = 0L;
    protected RowPosition scan_position;
    protected int stat_numpages_visited = 0;
    protected int stat_numrows_visited = 0;
    protected int stat_numrows_qualified = 0;

    private final void repositionScanForUpateOper() throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S", new Object[0]);
        }
        if (!this.open_conglom.latchPage(this.scan_position)) {
            throw StandardException.newException("XSAM6.S", this.open_conglom.getContainer().getId(), this.scan_position.current_rh.getPageNumber(), this.scan_position.current_rh.getId());
        }
        if (this.open_conglom.isUseUpdateLocks()) {
            this.open_conglom.lockPositionForWrite(this.scan_position, true);
        }
    }

    protected void positionAtInitScan(DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, RowPosition pos) throws StandardException {
        this.init_startKeyValue = startKeyValue;
        if (RowUtil.isRowEmpty(this.init_startKeyValue)) {
            this.init_startKeyValue = null;
        }
        this.init_startSearchOperator = startSearchOperator;
        if (qualifier != null && qualifier.length == 0) {
            qualifier = null;
        }
        this.init_qualifier = qualifier;
        this.init_fetchDesc = new FetchDescriptor(this.open_conglom.getRuntimeMem().get_scratch_row(this.open_conglom.getRawTran()).length, this.init_scanColumnList, this.init_qualifier);
        this.init_stopKeyValue = stopKeyValue;
        if (RowUtil.isRowEmpty(this.init_stopKeyValue)) {
            this.init_stopKeyValue = null;
        }
        this.init_stopSearchOperator = stopSearchOperator;
        pos.init();
        if (this.init_scanColumnList != null) {
            int i;
            FormatableBitSet required_cols = qualifier != null ? RowUtil.getQualifierBitSet(qualifier) : new FormatableBitSet(0);
            if (this.init_startKeyValue != null) {
                required_cols.grow(this.init_startKeyValue.length);
                for (i = 0; i < this.init_startKeyValue.length; ++i) {
                    required_cols.set(i);
                }
            }
            if (this.init_stopKeyValue != null) {
                required_cols.grow(this.init_stopKeyValue.length);
                for (i = 0; i < this.init_stopKeyValue.length; ++i) {
                    required_cols.set(i);
                }
            }
            FormatableBitSet required_cols_and_scan_list = (FormatableBitSet)required_cols.clone();
            required_cols_and_scan_list.and(this.init_scanColumnList);
            required_cols.grow(this.init_scanColumnList.size());
            if (!required_cols_and_scan_list.equals(required_cols)) {
                SanityManager.THROWASSERT("Some column specified in a Btree  qualifier/start/stop list is not represented in the scanColumnList.\n:required_cols_and_scan_list = " + required_cols_and_scan_list + "\n;required_cols = " + required_cols + "\n;init_scanColumnList = " + this.init_scanColumnList);
            }
        }
        this.scan_state = 1;
    }

    protected void positionAtResumeScan(RowPosition pos) throws StandardException {
        SanityManager.ASSERT(this.scan_position.current_rh != null, this.toString());
        this.open_conglom.latchPageAndRepositionScan(this.scan_position);
    }

    protected void positionAtStartForForwardScan(RowPosition pos) throws StandardException {
        if (pos.current_rh == null) {
            pos.current_page = this.open_conglom.getContainer().getFirstPage();
            SanityManager.ASSERT(pos.current_page.getPageNumber() == 1L);
            if (pos.current_page.recordCount() < 1) {
                SanityManager.THROWASSERT("record count = " + pos.current_page.recordCount());
            }
            pos.current_slot = 0;
        } else {
            this.open_conglom.latchPageAndRepositionScan(pos);
            --pos.current_slot;
        }
        pos.current_rh = null;
        this.stat_numpages_visited = 1;
        this.scan_state = 2;
    }

    protected void positionAtNextPage(RowPosition pos) throws StandardException {
        if (pos.current_page != null) {
            long pageid = pos.current_page.getPageNumber();
            pos.unlatch();
            pos.current_page = this.open_conglom.getContainer().getNextPage(pageid);
            pos.current_slot = -1;
        }
    }

    protected void positionAtDoneScan(RowPosition pos) throws StandardException {
        pos.unlatch();
        if (this.scan_position.current_rh != null) {
            this.open_conglom.unlockPositionAfterRead(this.scan_position);
            this.scan_position.current_rh = null;
        }
        this.scan_state = 3;
    }

    @Override
    public void reopenScanByRowLocation(RowLocation startRowLocation, Qualifier[][] qualifier) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    protected RowPosition allocateScanPosition() throws StandardException {
        return new RowPosition();
    }

    protected int fetchRows(DataValueDescriptor[][] row_array, RowLocation[] rowloc_array, BackingStoreHashtable hash_table, long max_rowcnt, int[] key_column_numbers) throws StandardException {
        int ret_row_count = 0;
        Object[] fetch_row = null;
        if (max_rowcnt == -1L) {
            max_rowcnt = Long.MAX_VALUE;
        }
        if (row_array != null) {
            SanityManager.ASSERT(row_array[0] != null, "first array slot in fetchNextGroup() must be non-null.");
            SanityManager.ASSERT(hash_table == null);
        } else {
            SanityManager.ASSERT(hash_table != null);
        }
        if (this.scan_state == 2) {
            this.positionAtResumeScan(this.scan_position);
        } else if (this.scan_state == 1) {
            this.positionAtStartForForwardScan(this.scan_position);
        } else if (this.scan_state == 5) {
            this.reopenAfterEndTransaction();
            SanityManager.ASSERT(this.scan_position.current_rh != null, this.toString());
            this.open_conglom.latchPageAndRepositionScan(this.scan_position);
            this.scan_state = 2;
        } else if (this.scan_state == 4) {
            this.reopenAfterEndTransaction();
            this.positionAtStartForForwardScan(this.scan_position);
        } else {
            SanityManager.ASSERT(this.scan_state == 3);
            return 0;
        }
        while (this.scan_position.current_page != null) {
            while (this.scan_position.current_slot + 1 < this.scan_position.current_page.recordCount()) {
                if (this.scan_position.current_rh != null) {
                    this.open_conglom.unlockPositionAfterRead(this.scan_position);
                }
                if (fetch_row == null) {
                    if (hash_table == null) {
                        if (row_array[ret_row_count] == null) {
                            row_array[ret_row_count] = this.open_conglom.getRuntimeMem().get_row_for_export(this.open_conglom.getRawTran());
                        }
                        fetch_row = row_array[ret_row_count];
                    } else {
                        fetch_row = this.open_conglom.getRuntimeMem().get_row_for_export(this.open_conglom.getRawTran());
                    }
                }
                this.scan_position.positionAtNextSlot();
                boolean lock_granted_while_latch_held = this.open_conglom.lockPositionForRead(this.scan_position, null, true, true);
                if (!lock_granted_while_latch_held) {
                    if (this.scan_position.current_page == null) break;
                    if (this.scan_position.current_slot == -1) {
                        SanityManager.ASSERT(this.scan_position.current_rh == null);
                        continue;
                    }
                }
                ++this.stat_numrows_visited;
                SanityManager.ASSERT(this.scan_position.current_rh != null);
                if (this.scan_position.current_slot != this.scan_position.current_page.getSlotNumber(this.scan_position.current_rh)) {
                    SanityManager.THROWASSERT("current_slot = " + this.scan_position.current_slot + "current_rh = " + this.scan_position.current_rh + "current_rh.slot = " + this.scan_position.current_page.getSlotNumber(this.scan_position.current_rh));
                }
                boolean bl = this.scan_position.current_rh_qualified = this.scan_position.current_page.fetchFromSlot(this.scan_position.current_rh, this.scan_position.current_slot, fetch_row, this.init_fetchDesc, false) != null;
                if (!this.scan_position.current_rh_qualified) continue;
                SanityManager.ASSERT(this.scan_position.current_slot == this.scan_position.current_page.getSlotNumber(this.scan_position.current_rh));
                ++ret_row_count;
                ++this.stat_numrows_qualified;
                if (hash_table == null) {
                    if (rowloc_array != null) {
                        this.setRowLocationArray(rowloc_array, ret_row_count - 1, this.scan_position);
                    }
                    fetch_row = null;
                } else {
                    RowLocation rowLocation;
                    RowLocation rowLocation2 = rowLocation = hash_table.includeRowLocations() ? this.makeRowLocation(this.scan_position) : null;
                    if (hash_table.putRow(false, (DataValueDescriptor[])fetch_row, rowLocation)) {
                        fetch_row = null;
                    }
                }
                if (max_rowcnt > (long)ret_row_count) continue;
                this.scan_position.unlatch();
                SanityManager.ASSERT(this.scan_position.current_rh != null);
                return ret_row_count;
            }
            this.positionAtNextPage(this.scan_position);
            ++this.stat_numpages_visited;
        }
        this.positionAtDoneScan(this.scan_position);
        --this.stat_numpages_visited;
        return ret_row_count;
    }

    protected void reopenScanByRecordHandle(RecordHandle startRecordHandle, Qualifier[][] qualifier) throws StandardException {
        this.scan_state = !this.open_conglom.getHold() ? 1 : 4;
        this.scan_position.current_rh = startRecordHandle;
    }

    protected abstract void setRowLocationArray(RowLocation[] var1, int var2, RowPosition var3) throws StandardException;

    protected abstract RowLocation makeRowLocation(RowPosition var1) throws StandardException;

    public void init(OpenConglomerate open_conglom, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator) throws StandardException {
        super.init(open_conglom);
        this.scan_position = open_conglom.getRuntimeMem().get_scratch_row_position();
        this.init_scanColumnList = scanColumnList;
        this.positionAtInitScan(startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, this.scan_position);
        this.reusableRecordIdSequenceNumber = open_conglom.getContainer().getReusableRecordIdSequenceNumber();
    }

    public final int getNumPagesVisited() {
        return this.stat_numpages_visited;
    }

    public final int getNumRowsVisited() {
        return this.stat_numrows_visited;
    }

    public final int getNumRowsQualified() {
        return this.stat_numrows_qualified;
    }

    public final FormatableBitSet getScanColumnList() {
        return this.init_scanColumnList;
    }

    public final DataValueDescriptor[] getStartKeyValue() {
        return this.init_startKeyValue;
    }

    public final int getStartSearchOperator() {
        return this.init_startSearchOperator;
    }

    public final DataValueDescriptor[] getStopKeyValue() {
        return this.init_stopKeyValue;
    }

    public final int getStopSearchOperator() {
        return this.init_stopSearchOperator;
    }

    public final Qualifier[][] getQualifier() {
        return this.init_qualifier;
    }

    public final int getScanState() {
        return this.scan_state;
    }

    public final void setScanState(int state) {
        this.scan_state = state;
    }

    public final RowPosition getScanPosition() {
        return this.scan_position;
    }

    public final void setScanPosition(RowPosition pos) {
        this.scan_position = pos;
    }

    private void closeScan() throws StandardException {
        super.close();
        if (this.open_conglom.getXactMgr() != null) {
            this.open_conglom.getXactMgr().closeMe(this);
        }
        this.init_qualifier = null;
        this.init_scanColumnList = null;
        this.init_startKeyValue = null;
        this.init_stopKeyValue = null;
    }

    @Override
    public void close() throws StandardException {
        this.positionAtDoneScan(this.scan_position);
        this.closeScan();
    }

    protected final boolean reopenAfterEndTransaction() throws StandardException {
        if (!this.open_conglom.getHold()) {
            return false;
        }
        ContainerHandle container = this.open_conglom.reopen();
        switch (this.scan_state) {
            case 2: 
            case 3: 
            case 5: {
                if (container.getReusableRecordIdSequenceNumber() == this.reusableRecordIdSequenceNumber) break;
                this.rowLocationsInvalidated = true;
                break;
            }
            case 1: 
            case 4: {
                this.reusableRecordIdSequenceNumber = container.getReusableRecordIdSequenceNumber();
                break;
            }
        }
        return true;
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) throws StandardException {
        if (!this.open_conglom.getHold() || closeHeldScan) {
            this.scan_state = 3;
            this.closeScan();
            return true;
        }
        super.close();
        if (this.scan_state == 2) {
            this.scan_state = 5;
        } else if (this.scan_state == 1) {
            this.scan_state = 4;
        }
        return false;
    }

    @Override
    public boolean delete() throws StandardException {
        this.repositionScanForUpateOper();
        boolean ret_val = true;
        if (this.scan_position.current_page.isDeletedAtSlot(this.scan_position.current_slot)) {
            ret_val = false;
        } else {
            this.scan_position.current_page.deleteAtSlot(this.scan_position.current_slot, true, null);
            if (this.scan_position.current_page.nonDeletedRecordCount() == 0) {
                this.queueDeletePostCommitWork(this.scan_position);
            }
        }
        this.scan_position.unlatch();
        return ret_val;
    }

    @Override
    public void didNotQualify() throws StandardException {
    }

    @Override
    public void fetchSet(long max_rowcnt, int[] key_column_numbers, BackingStoreHashtable hash_table) throws StandardException {
        this.fetchRows(null, null, hash_table, max_rowcnt, key_column_numbers);
    }

    @Override
    public void reopenScan(DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator) throws StandardException {
        if (!this.open_conglom.getHold()) {
            SanityManager.ASSERT(!this.open_conglom.isClosed(), "GenericScanController.reopenScan() called on a non-held closed scan.");
        }
        this.scan_state = !this.open_conglom.getHold() ? 1 : 4;
        this.scan_position.current_rh = null;
    }

    @Override
    public boolean replace(DataValueDescriptor[] row, FormatableBitSet validColumns) throws StandardException {
        boolean ret_val;
        this.repositionScanForUpateOper();
        Page page = this.scan_position.current_page;
        int slot = this.scan_position.current_slot;
        SanityManager.ASSERT(this.open_conglom.getContainer().getLockingPolicy().getMode() != 1 || this.open_conglom.isUseUpdateLocks(), "Current mode of container requires row locking.");
        SanityManager.ASSERT(slot == page.getSlotNumber(this.scan_position.current_rh));
        if (page.isDeletedAtSlot(slot)) {
            ret_val = false;
        } else {
            page.updateAtSlot(slot, row, validColumns);
            ret_val = true;
        }
        this.scan_position.unlatch();
        return ret_val;
    }

    @Override
    public boolean doesCurrentPositionQualify() throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S", new Object[0]);
        }
        if (!this.open_conglom.latchPage(this.scan_position)) {
            return false;
        }
        Object[] row = this.open_conglom.getRuntimeMem().get_scratch_row(this.open_conglom.getRawTran());
        boolean ret_val = this.scan_position.current_page.fetchFromSlot(this.scan_position.current_rh, this.scan_position.current_slot, row, this.init_fetchDesc, false) != null;
        this.scan_position.unlatch();
        return ret_val;
    }

    @Override
    public void fetchWithoutQualify(DataValueDescriptor[] row) throws StandardException {
        this.fetch(row, false);
    }

    @Override
    public boolean isHeldAfterCommit() throws StandardException {
        return this.scan_state == 4 || this.scan_state == 5;
    }

    @Override
    public void fetch(DataValueDescriptor[] row) throws StandardException {
        this.fetch(row, true);
    }

    private void fetch(DataValueDescriptor[] row, boolean qualify) throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S", new Object[0]);
        }
        if (!this.open_conglom.latchPage(this.scan_position)) {
            throw StandardException.newException("XSAM6.S", this.open_conglom.getContainer().getId(), this.scan_position.current_rh.getPageNumber(), this.scan_position.current_rh.getId());
        }
        RecordHandle rh = this.scan_position.current_page.fetchFromSlot(this.scan_position.current_rh, this.scan_position.current_slot, row, qualify ? this.init_fetchDesc : null, false);
        this.scan_position.unlatch();
        if (rh == null) {
            throw StandardException.newException("XSAM6.S", this.open_conglom.getContainer().getId(), this.scan_position.current_rh.getPageNumber(), this.scan_position.current_rh.getId());
        }
    }

    @Override
    public void fetchLocation(RowLocation templateLocation) throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public ScanInfo getScanInfo() throws StandardException {
        throw StandardException.newException("XSCB3.S", new Object[0]);
    }

    @Override
    public boolean isCurrentPositionDeleted() throws StandardException {
        if (this.scan_state != 2) {
            throw StandardException.newException("XSAM5.S", new Object[0]);
        }
        if (!this.open_conglom.latchPage(this.scan_position)) {
            return true;
        }
        boolean ret_val = this.scan_position.current_page.isDeletedAtSlot(this.scan_position.current_slot);
        this.scan_position.unlatch();
        return ret_val;
    }
}

