/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.LoadError;

public class Import
extends ImportAbstract {
    private static int _importCounter;
    private static Hashtable<Integer, Import> _importers;
    private String inputFileName;
    private static short skip;

    public Import(String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, int noOfColumnsExpected, String columnTypes, boolean lobsInExtFile, int importCounter, String columnTypeNames, String udtClassNamesString) throws SQLException {
        try {
            this.inputFileName = inputFileName;
            this.noOfColumnsExpected = noOfColumnsExpected;
            this.tableColumnTypesStr = columnTypes;
            this.columnTypeNamesString = columnTypeNames;
            this.udtClassNamesString = udtClassNamesString;
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(characterDelimiter, columnDelimiter, codeset);
            this.lobsInExtFile = lobsInExtFile;
            _importers.put(importCounter, this);
            this.doImport();
        }
        catch (Exception e) {
            throw this.importError(e);
        }
    }

    private void doImport() throws Exception {
        if (this.inputFileName == null) {
            throw LoadError.dataFileNull();
        }
        this.doAllTheWork();
    }

    public static void importTable(Connection connection, String schemaName, String tableName, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lobsInExtFile, short ... extraArgs) throws SQLException {
        try {
            if (lobsInExtFile) {
                SecurityUtil.authorize(Securable.IMPORT_TABLE_LOBS_FROM_EXTFILE);
            } else {
                SecurityUtil.authorize(Securable.IMPORT_TABLE);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        if (extraArgs.length > 0) {
            skip = extraArgs[0];
            if (skip < 0) {
                throw PublicAPI.wrapStandardException(StandardException.newException("42XAV", new Object[0]));
            }
        } else {
            skip = 0;
        }
        Import.performImport(connection, schemaName, null, null, tableName, inputFileName, columnDelimiter, characterDelimiter, codeset, replace, lobsInExtFile);
    }

    public static void importData(Connection connection, String schemaName, String tableName, String insertColumnList, String columnIndexes, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lobsInExtFile, short ... extraArgs) throws SQLException {
        try {
            if (lobsInExtFile) {
                SecurityUtil.authorize(Securable.IMPORT_DATA_LOBS_FROM_EXTFILE);
            } else {
                SecurityUtil.authorize(Securable.IMPORT_DATA);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        if (extraArgs.length > 0) {
            skip = extraArgs[0];
            if (skip < 0) {
                throw PublicAPI.wrapStandardException(StandardException.newException("42XAV", new Object[0]));
            }
        } else {
            skip = 0;
        }
        Import.performImport(connection, schemaName, insertColumnList, columnIndexes, tableName, inputFileName, columnDelimiter, characterDelimiter, codeset, replace, lobsInExtFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performImport(Connection connection, String schemaName, String insertColumnList, String columnIndexes, String tableName, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lobsInExtFile) throws SQLException {
        Integer importCounter = Import.bumpImportCounter();
        try {
            if (connection == null) {
                throw LoadError.connectionNull();
            }
            if (tableName == null) {
                throw LoadError.entityNameMissing();
            }
            ColumnInfo columnInfo = new ColumnInfo(connection, schemaName, tableName, insertColumnList, columnIndexes, "COLUMN", Import.readHeaders(inputFileName, characterDelimiter, columnDelimiter, codeset));
            String columnTypeNames = null;
            String udtClassNames = null;
            try {
                columnTypeNames = columnInfo.getColumnTypeNames();
                udtClassNames = columnInfo.getUDTClassNames();
            }
            catch (Throwable t) {
                throw Import.formatImportError(_importers.get(importCounter), inputFileName, t);
            }
            StringBuffer sb = new StringBuffer("new ");
            sb.append("org.apache.derby.impl.load.Import");
            sb.append("(");
            sb.append(Import.quoteStringArgument(inputFileName));
            sb.append(",");
            sb.append(Import.quoteStringArgument(columnDelimiter));
            sb.append(",");
            sb.append(Import.quoteStringArgument(characterDelimiter));
            sb.append(",");
            sb.append(Import.quoteStringArgument(codeset));
            sb.append(", ");
            sb.append(columnInfo.getExpectedNumberOfColumnsInFile());
            sb.append(", ");
            sb.append(Import.quoteStringArgument(columnInfo.getExpectedVtiColumnTypesAsString()));
            sb.append(", ");
            sb.append(lobsInExtFile);
            sb.append(", ");
            sb.append(importCounter);
            sb.append(", ");
            sb.append(Import.quoteStringArgument(columnTypeNames));
            sb.append(", ");
            sb.append(Import.quoteStringArgument(udtClassNames));
            sb.append(" )");
            String importvti = sb.toString();
            String entityName = IdUtil.mkQualifiedName(schemaName, tableName);
            String insertModeValue = replace > 0 ? "replace" : "bulkInsert";
            String cNamesWithCasts = columnInfo.getColumnNamesWithCasts();
            String insertColumnNames = columnInfo.getInsertColumnNames();
            insertColumnNames = insertColumnNames != null ? "(" + insertColumnNames + ") " : "";
            String insertSql = "INSERT INTO " + entityName + insertColumnNames + " --DERBY-PROPERTIES insertMode=" + insertModeValue + "\n SELECT " + cNamesWithCasts + " from " + importvti + " AS importvti";
            PreparedStatement ips = connection.prepareStatement(insertSql);
            Statement statement = connection.createStatement();
            String lockSql = "LOCK TABLE " + entityName + " IN EXCLUSIVE MODE";
            statement.executeUpdate(lockSql);
            try {
                ips.executeUpdate();
            }
            catch (Throwable t) {
                throw Import.formatImportError(_importers.get(importCounter), inputFileName, t);
            }
            statement.close();
            ips.close();
        }
        finally {
            _importers.remove(importCounter);
        }
    }

    private static String[] readHeaders(String inputFileName, String characterDelimiter, String columnDelimiter, String codeset) throws SQLException {
        try {
            if (skip > 0) {
                ControlInfo controlFR = new ControlInfo();
                controlFR.setControlProperties(characterDelimiter, columnDelimiter, codeset);
                ImportReadData importReadData = new ImportReadData(inputFileName, controlFR, 0);
                String[] fullColumnName = new String[importReadData.numberOfColumns];
                String[] temp = new String[importReadData.numberOfColumns];
                for (int i = 0; i < skip; ++i) {
                    importReadData.readNextRow(temp);
                    for (int j = 0; j < importReadData.numberOfColumns; ++j) {
                        if (i == 0) {
                            fullColumnName[j] = temp[j];
                            continue;
                        }
                        if (temp[j] == null) continue;
                        fullColumnName[j] = fullColumnName[j] + " " + temp[j];
                    }
                }
                return fullColumnName;
            }
            return null;
        }
        catch (Exception e) {
            throw LoadError.unexpectedError(e);
        }
    }

    @Override
    ImportReadData getImportReadData() throws Exception {
        return new ImportReadData(this.inputFileName, this.controlFileReader, skip);
    }

    private static synchronized int bumpImportCounter() {
        return ++_importCounter;
    }

    private static SQLException formatImportError(Import importer, String inputFile, Throwable t) {
        int lineNumber = -1;
        if (importer != null) {
            lineNumber = importer.getCurrentLineNumber();
        }
        StandardException se = StandardException.newException("XIE0R.S", lineNumber, inputFile, t.getMessage());
        se.initCause(t);
        return PublicAPI.wrapStandardException(se);
    }

    private static String quoteStringArgument(String string) {
        if (string == null) {
            return "NULL";
        }
        return StringUtil.quoteStringLiteral(string);
    }

    static {
        _importers = new Hashtable();
    }
}

