/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermDescriptor;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.impl.sql.catalog.PermissionsCatalogRowFactory;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.sanity.SanityManager;

public class SYSPERMSRowFactory
extends PermissionsCatalogRowFactory {
    private static final String TABLENAME_STRING = "SYSPERMS";
    private static final int SYSPERMS_COLUMN_COUNT = 7;
    private static final int SYSPERMS_PERMISSIONID = 1;
    private static final int SYSPERMS_OBJECTTYPE = 2;
    private static final int SYSPERMS_OBJECTID = 3;
    private static final int SYSPERMS_PERMISSION = 4;
    private static final int SYSPERMS_GRANTOR = 5;
    private static final int SYSPERMS_GRANTEE = 6;
    private static final int SYSPERMS_IS_GRANTABLE = 7;
    private static final int[][] indexColumnPositions = new int[][]{{1}, {3}, {6, 3, 5}};
    public static final int PERMS_UUID_IDX_NUM = 0;
    public static final int PERMS_OBJECTID_IDX_NUM = 1;
    public static final int GRANTEE_OBJECTID_GRANTOR_INDEX_NUM = 2;
    private static final boolean[] uniqueness = new boolean[]{true, false, true};
    private static final String[] uuids = new String[]{"9810800c-0121-c5e1-a2f5-00000043e718", "6ea6ffac-0121-c5e3-f286-00000043e718", "5cc556fc-0121-c5e6-4e43-00000043e718", "7a92cf84-0122-51e6-2c5e-00000047b548", "9810800c-0125-8de5-3aa0-0000001999e8"};

    SYSPERMSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(7, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecIndexRow buildIndexKeyRow(int indexNumber, PermissionsDescriptor perm) throws StandardException {
        ExecIndexRow row = null;
        switch (indexNumber) {
            case 2: {
                row = this.getExecutionFactory().getIndexableRow(2);
                row.setColumn(1, this.getAuthorizationID(perm.getGrantee()));
                String protectedObjectsIDStr = ((PermDescriptor)perm).getPermObjectId().toString();
                row.setColumn(2, new SQLChar(protectedObjectsIDStr));
                break;
            }
            case 0: {
                row = this.getExecutionFactory().getIndexableRow(1);
                String permUUIDStr = ((PermDescriptor)perm).getUUID().toString();
                row.setColumn(1, new SQLChar(permUUIDStr));
            }
        }
        return row;
    }

    @Override
    public int getPrimaryKeyIndexNumber() {
        return 2;
    }

    @Override
    public int orPermissions(ExecRow row, PermissionsDescriptor perm, boolean[] colsChanged) throws StandardException {
        return 0;
    }

    @Override
    public int removePermissions(ExecRow row, PermissionsDescriptor perm, boolean[] colsChanged) throws StandardException {
        return -1;
    }

    @Override
    void setUUIDOfThePassedDescriptor(ExecRow row, PermissionsDescriptor perm) throws StandardException {
        DataValueDescriptor existingPermDVD = row.getColumn(1);
        perm.setUUID(this.getUUIDFactory().recreateUUID(existingPermDVD.getString()));
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        String permIdString = null;
        String objectType = "SEQUENCE";
        String objectIdString = null;
        String permission = "USAGE";
        String grantor = null;
        String grantee = null;
        boolean grantable = false;
        if (td != null) {
            PermDescriptor sd = (PermDescriptor)td;
            UUID pid = sd.getUUID();
            if (pid == null) {
                pid = this.getUUIDFactory().createUUID();
                sd.setUUID(pid);
            }
            permIdString = pid.toString();
            objectType = sd.getObjectType();
            UUID oid = sd.getPermObjectId();
            objectIdString = oid.toString();
            permission = sd.getPermission();
            grantor = sd.getGrantor();
            grantee = sd.getGrantee();
            grantable = sd.isGrantable();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(7);
        row.setColumn(1, new SQLChar(permIdString));
        row.setColumn(2, new SQLVarchar(objectType));
        row.setColumn(3, new SQLChar(objectIdString));
        row.setColumn(4, new SQLChar(permission));
        row.setColumn(5, new SQLVarchar(grantor));
        row.setColumn(6, new SQLVarchar(grantee));
        row.setColumn(7, new SQLChar(grantable ? "Y" : "N"));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        SanityManager.ASSERT(row.nColumns() == 7, "Wrong number of columns for a SYSPERMS row");
        DataValueDescriptor col = row.getColumn(1);
        String permIdString = col.getString();
        col = row.getColumn(2);
        String objectType = col.getString();
        col = row.getColumn(3);
        String objectIdString = col.getString();
        col = row.getColumn(4);
        String permission = col.getString();
        col = row.getColumn(5);
        String grantor = col.getString();
        col = row.getColumn(6);
        String grantee = col.getString();
        col = row.getColumn(7);
        String isGrantable = col.getString();
        PermDescriptor descriptor = ddg.newPermDescriptor(this.getUUIDFactory().recreateUUID(permIdString), objectType, this.getUUIDFactory().recreateUUID(objectIdString), permission, grantor, grantee, isGrantable.equals("Y"));
        return descriptor;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("UUID", false), SystemColumnImpl.getColumn("OBJECTTYPE", 12, false, 36), SystemColumnImpl.getUUIDColumn("OBJECTID", false), SystemColumnImpl.getColumn("PERMISSION", 1, false, 36), SystemColumnImpl.getIdentifierColumn("GRANTOR", false), SystemColumnImpl.getIdentifierColumn("GRANTEE", false), SystemColumnImpl.getIndicatorColumn("ISGRANTABLE")};
    }
}

