/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.ProjectRestrictResultSet;
import org.apache.derby.shared.common.sanity.SanityManager;

class RowCountResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    final NoPutResultSet source;
    private final boolean runTimeStatsOn;
    private long offset;
    private long fetchFirst;
    private final GeneratedMethod offsetMethod;
    private final GeneratedMethod fetchFirstMethod;
    private final boolean hasJDBClimitClause;
    private boolean virginal;
    private long rowsFetched;

    RowCountResultSet(NoPutResultSet s, Activation a, int resultSetNumber, GeneratedMethod offsetMethod, GeneratedMethod fetchFirstMethod, boolean hasJDBClimitClause, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.offsetMethod = offsetMethod;
        this.fetchFirstMethod = fetchFirstMethod;
        this.hasJDBClimitClause = hasJDBClimitClause;
        this.source = s;
        this.virginal = true;
        this.rowsFetched = 0L;
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "RowCountResultSet not open, cannot reopen");
        this.source.reopenCore();
        this.virginal = true;
        this.rowsFetched = 0L;
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ExecRow getNextRowCore() throws StandardException {
        void var1_8;
        if (this.isXplainOnlyMode()) {
            return null;
        }
        Object var1_1 = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.virginal) {
            if (this.offsetMethod != null) {
                DataValueDescriptor offVal = (DataValueDescriptor)this.offsetMethod.invoke(this.activation);
                if (!offVal.isNotNull().getBoolean()) throw StandardException.newException("2201Z", "OFFSET");
                this.offset = offVal.getLong();
                if (this.offset < 0L) {
                    throw StandardException.newException("2201X", Long.toString(this.offset));
                }
                this.offset = offVal.getLong();
            } else {
                this.offset = 0L;
            }
            if (this.fetchFirstMethod != null) {
                DataValueDescriptor fetchFirstVal = (DataValueDescriptor)this.fetchFirstMethod.invoke(this.activation);
                if (!fetchFirstVal.isNotNull().getBoolean()) throw StandardException.newException("2201Z", "FETCH FIRST/NEXT");
                this.fetchFirst = fetchFirstVal.getLong();
                if (this.hasJDBClimitClause && this.fetchFirst == 0L) {
                    this.fetchFirst = Long.MAX_VALUE;
                }
                if (this.fetchFirst < 1L) {
                    throw StandardException.newException("2201W", Long.toString(this.fetchFirst));
                }
            }
            if (this.offset > 0L) {
                ExecRow execRow;
                this.virginal = false;
                long offsetCtr = this.offset;
                while ((execRow = this.source.getNextRowCore()) != null && --offsetCtr >= 0L) {
                    ++this.rowsFiltered;
                }
            } else if (this.fetchFirstMethod != null && this.rowsFetched >= this.fetchFirst) {
                Object var1_4 = null;
            } else {
                ExecRow execRow = this.source.getNextRowCore();
            }
        } else if (this.fetchFirstMethod != null && this.rowsFetched >= this.fetchFirst) {
            Object var1_6 = null;
        } else {
            ExecRow execRow = this.source.getNextRowCore();
        }
        if (var1_8 != null) {
            ++this.rowsFetched;
            ++this.rowsSeen;
        }
        this.setCurrentRow((ExecRow)var1_8);
        if (!this.runTimeStatsOn) return var1_8;
        if (!this.isTopResultSet) {
            StatementContext sc = this.activation.getLanguageConnectionContext().getStatementContext();
            this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return var1_8;
    }

    @Override
    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of RowCountResultSet repeated");
        }
        this.virginal = true;
        this.rowsFetched = 0L;
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public final void clearCurrentRow() {
        this.currentRow = null;
        this.activation.clearCurrentRow(this.resultSetNumber);
        this.source.clearCurrentRow();
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getCurrentRow();
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    public ProjectRestrictResultSet getUnderlyingProjectRestrictRS() {
        if (this.source instanceof ProjectRestrictResultSet) {
            return (ProjectRestrictResultSet)this.source;
        }
        return null;
    }
}

