/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.IgnoreFilter;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.CurrentOfNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.DeleteNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.HalfOuterJoinNode;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.MergeNode;
import org.apache.derby.impl.sql.compile.NumericConstantNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class MatchingClauseNode
extends QueryTreeNode {
    private static final String CURRENT_OF_NODE_NAME = "$MERGE_CURRENT";
    private ValueNode _matchingRefinement;
    private ResultColumnList _updateColumns;
    private ResultColumnList _insertColumns;
    private ResultColumnList _insertValues;
    private DMLModStatementNode _dml;
    private ResultColumnList _thenColumns;
    private int _clauseNumber;
    private String _actionMethodName;
    private String _resultSetFieldName;
    private String _rowMakingMethodName;

    private MatchingClauseNode(ValueNode matchingRefinement, ResultColumnList updateColumns, ResultColumnList insertColumns, ResultColumnList insertValues, ContextManager cm) throws StandardException {
        super(cm);
        this._matchingRefinement = matchingRefinement;
        this._updateColumns = updateColumns;
        this._insertColumns = insertColumns;
        this._insertValues = insertValues;
    }

    static MatchingClauseNode makeUpdateClause(ValueNode matchingRefinement, ResultColumnList updateColumns, ContextManager cm) throws StandardException {
        return new MatchingClauseNode(matchingRefinement, updateColumns, null, null, cm);
    }

    static MatchingClauseNode makeDeleteClause(ValueNode matchingRefinement, ContextManager cm) throws StandardException {
        return new MatchingClauseNode(matchingRefinement, null, null, null, cm);
    }

    static MatchingClauseNode makeInsertClause(ValueNode matchingRefinement, ResultColumnList insertColumns, ResultColumnList insertValues, ContextManager cm) throws StandardException {
        return new MatchingClauseNode(matchingRefinement, null, insertColumns, insertValues, cm);
    }

    boolean isUpdateClause() {
        return this._updateColumns != null;
    }

    boolean isInsertClause() {
        return this._insertValues != null;
    }

    boolean isDeleteClause() {
        return !this.isUpdateClause() && !this.isInsertClause();
    }

    ResultColumnList getThenColumns() {
        return this._thenColumns;
    }

    void bind(DataDictionary dd, MergeNode mergeNode, FromList fullFromList, FromBaseTable targetTable) throws StandardException {
        this.forbidSubqueries();
        this._thenColumns = new ResultColumnList(this.getContextManager());
        if (this.isDeleteClause()) {
            this.bindDelete(dd, fullFromList, targetTable);
        }
        if (this.isUpdateClause()) {
            this.bindUpdate(dd, mergeNode, fullFromList, targetTable);
        }
        if (this.isInsertClause()) {
            this.bindInsert(dd, mergeNode, fullFromList, targetTable);
        }
    }

    void bindRefinement(MergeNode mergeNode, FromList fullFromList) throws StandardException {
        if (this._matchingRefinement != null) {
            FromList fromList = fullFromList;
            if (this.isInsertClause()) {
                fromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
                fromList.addElement((ResultSetNode)fullFromList.elementAt(0));
            }
            mergeNode.bindExpression(this._matchingRefinement, fromList);
        }
    }

    void getColumnsInExpressions(MergeNode mergeNode, HashMap<String, ColumnReference> drivingColumnMap) throws StandardException {
        if (this._matchingRefinement != null) {
            mergeNode.getColumnsInExpression(drivingColumnMap, this._matchingRefinement, 0);
        }
        if (this.isUpdateClause()) {
            TableName targetTableName = mergeNode.getTargetTable().getTableName();
            for (ResultColumn rc : this._updateColumns) {
                mergeNode.getColumnsInExpression(drivingColumnMap, rc.getExpression(), 0);
                ColumnReference leftCR = new ColumnReference(rc.getName(), targetTableName, this.getContextManager());
                mergeNode.addColumn(drivingColumnMap, leftCR, 2);
            }
        } else if (this.isInsertClause()) {
            for (ResultColumn rc : this._insertValues) {
                mergeNode.getColumnsInExpression(drivingColumnMap, rc.getExpression(), 0);
            }
        } else if (this.isDeleteClause()) {
            mergeNode.getColumnsFromList(drivingColumnMap, this._thenColumns, 2);
        }
    }

    private void bindUpdate(DataDictionary dd, MergeNode mergeNode, FromList fullFromList, FromBaseTable targetTable) throws StandardException {
        ResultColumnList setClauses = this.realiasSetClauses(targetTable);
        this.bindSetClauses(mergeNode, fullFromList, targetTable, setClauses);
        TableName tableName = targetTable.getTableNameField();
        FromList selectFromList = fullFromList;
        SelectNode selectNode = new SelectNode(setClauses, selectFromList, null, null, null, null, null, this.getContextManager());
        this._dml = new UpdateNode(tableName, selectNode, this, this.getContextManager());
        this._dml.bindStatement();
        boolean wasSkippingTypePrivileges = this.getCompilerContext().skipTypePrivileges(true);
        ResultColumnList beforeColumns = new ResultColumnList(this.getContextManager());
        ResultColumnList afterColumns = new ResultColumnList(this.getContextManager());
        ResultColumnList fullUpdateRow = this.getBoundSelectUnderUpdate().getResultColumns();
        int rowSize = fullUpdateRow.size() / 2;
        for (int i = 0; i < rowSize; ++i) {
            ResultColumn origBeforeRC = (ResultColumn)fullUpdateRow.elementAt(i);
            ResultColumn origAfterRC = (ResultColumn)fullUpdateRow.elementAt(i + rowSize);
            ResultColumn beforeRC = origBeforeRC.cloneMe();
            ResultColumn afterRC = origAfterRC.cloneMe();
            beforeColumns.addResultColumn(beforeRC);
            afterColumns.addResultColumn(afterRC);
        }
        this.buildThenColumnsForUpdate(fullFromList, targetTable, fullUpdateRow, beforeColumns, afterColumns);
        this.getCompilerContext().skipTypePrivileges(wasSkippingTypePrivileges);
    }

    private ResultColumnList realiasSetClauses(FromBaseTable targetTable) throws StandardException {
        ResultColumnList rcl = new ResultColumnList(this.getContextManager());
        for (int i = 0; i < this._updateColumns.size(); ++i) {
            ResultColumn setRC = (ResultColumn)this._updateColumns.elementAt(i);
            TableName tableName = targetTable.getTableName();
            ColumnReference newTargetColumn = new ColumnReference(setRC.getReference().getColumnName(), tableName, this.getContextManager());
            newTargetColumn.setMergeTableID(2);
            ResultColumn newRC = new ResultColumn(newTargetColumn, setRC.getExpression(), this.getContextManager());
            rcl.addResultColumn(newRC);
        }
        return rcl;
    }

    private ResultSetNode getBoundSelectUnderUpdate() throws StandardException {
        ResultSetNode candidate = this._dml.resultSet;
        while (candidate != null) {
            if (candidate instanceof SelectNode) {
                return candidate;
            }
            if (!(candidate instanceof SingleChildResultSetNode)) break;
            candidate = ((SingleChildResultSetNode)candidate).getChildResult();
        }
        throw StandardException.newException("0A000.S", new Object[0]);
    }

    private void bindSetClauses(MergeNode mergeNode, FromList fullFromList, FromTable targetTable, ResultColumnList setClauses) throws StandardException {
        setClauses.replaceOrForbidDefaults(targetTable.getTableDescriptor(), this._updateColumns, true);
        this.bindExpressions(setClauses, fullFromList);
        for (int i = 0; i < this._updateColumns.size(); ++i) {
            ResultColumn rc = (ResultColumn)this._updateColumns.elementAt(i);
            ColumnReference cr = rc.getReference();
            cr.setMergeTableID(2);
        }
        List<ColumnReference> colRefs = this.getColumnReferences(this._updateColumns);
        for (ColumnReference cr : colRefs) {
            mergeNode.associateColumn(fullFromList, cr, 0);
        }
    }

    private void buildThenColumnsForUpdate(FromList fullFromList, FromTable targetTable, ResultColumnList fullRow, ResultColumnList beforeRow, ResultColumnList afterValues) throws StandardException {
        TableDescriptor td = targetTable.getTableDescriptor();
        HashSet<String> changedColumns = this.getChangedColumnNames();
        HashSet<String> changedGeneratedColumns = this.getChangedGeneratedColumnNames(td, changedColumns);
        this._thenColumns = fullRow.copyListAndObjects();
        for (int i = 0; i < this._thenColumns.size(); ++i) {
            DefaultInfoImpl defaultInfo;
            DataValueDescriptor numericValue;
            ResultColumn origRC = (ResultColumn)this._thenColumns.elementAt(i);
            boolean isAfterColumn = i >= beforeRow.size();
            boolean isRowLocation = this.isRowLocation(origRC);
            ValueNode origExpr = origRC.getExpression();
            if (isRowLocation) continue;
            String columnName = origRC.getName();
            ColumnDescriptor cd = td.getColumnDescriptor(columnName);
            boolean changed = false;
            if (cd.isAutoincrement() && origRC.getExpression() instanceof NumericConstantNode && (numericValue = ((NumericConstantNode)origRC.getExpression()).getValue()) == null) {
                ResultColumn newRC = this.makeAutoGenRC(targetTable, origRC, i + 1);
                newRC.setVirtualColumnId(origRC.getVirtualColumnId());
                this._thenColumns.setElementAt(newRC, i);
                continue;
            }
            if (!origRC.isAutoincrement() && origRC.getExpression() instanceof VirtualColumnNode) {
                origRC.setExpression(new UntypedNullConstantNode(this.getContextManager()));
            }
            if (cd.hasGenerationClause()) {
                if (isAfterColumn && changedGeneratedColumns.contains(columnName)) {
                    origRC.setExpression(new UntypedNullConstantNode(this.getContextManager()));
                    continue;
                }
                ColumnReference cr = new ColumnReference(columnName, targetTable.getTableName(), this.getContextManager());
                origRC.setExpression(cr);
                origRC.setColumnDescriptor(null, null);
                continue;
            }
            if (isAfterColumn) {
                for (int ic = 0; ic < beforeRow.size(); ++ic) {
                    ResultColumn icRC = (ResultColumn)beforeRow.elementAt(ic);
                    if (!columnName.equals(icRC.getName())) continue;
                    ResultColumn newRC = null;
                    ResultColumn valueRC = (ResultColumn)afterValues.elementAt(ic);
                    if (valueRC.wasDefaultColumn() || valueRC.getExpression() instanceof UntypedNullConstantNode) {
                        if (!cd.isAutoincrement()) {
                            ValueNode expr = origRC.getExpression();
                            if (!(expr instanceof ColumnReference)) continue;
                            origRC.setExpression(new UntypedNullConstantNode(this.getContextManager()));
                            continue;
                        }
                        newRC = this.makeAutoGenRC(targetTable, origRC, i + 1);
                    } else {
                        newRC = valueRC.cloneMe();
                        newRC.setType(origRC.getTypeServices());
                    }
                    newRC.setVirtualColumnId(origRC.getVirtualColumnId());
                    this._thenColumns.setElementAt(newRC, i);
                    changed = true;
                    break;
                }
            }
            if (!(changed || (defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo()) == null || defaultInfo.isGeneratedColumn() || cd.isAutoincrement())) {
                this._thenColumns.setDefault(origRC, cd, defaultInfo);
                changed = true;
            }
            ResultColumn finalRC = (ResultColumn)this._thenColumns.elementAt(i);
            finalRC.setName(cd.getColumnName());
            finalRC.resetAutoincrementGenerated();
        }
    }

    private HashSet<String> getChangedColumnNames() throws StandardException {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < this._updateColumns.size(); ++i) {
            String columnName = ((ResultColumn)this._updateColumns.elementAt(i)).getName();
            result.add(columnName);
        }
        return result;
    }

    private HashSet<String> getChangedGeneratedColumnNames(TableDescriptor targetTableDescriptor, HashSet<String> changedColumnNames) throws StandardException {
        HashSet<String> result = new HashSet<String>();
        block0: for (ColumnDescriptor cd : targetTableDescriptor.getColumnDescriptorList()) {
            String[] referencedColumns;
            if (!cd.hasGenerationClause()) continue;
            if (changedColumnNames.contains(cd.getColumnName())) {
                result.add(cd.getColumnName());
                continue;
            }
            for (String referencedColumnName : referencedColumns = cd.getDefaultInfo().getReferencedColumnNames()) {
                if (!changedColumnNames.contains(referencedColumnName)) continue;
                result.add(referencedColumnName);
                continue block0;
            }
        }
        return result;
    }

    private void bindDelete(DataDictionary dd, FromList fullFromList, FromBaseTable targetTable) throws StandardException {
        IgnoreFilter ignorePermissions = new IgnoreFilter();
        this.getCompilerContext().addPrivilegeFilter(ignorePermissions);
        FromBaseTable deleteTarget = new FromBaseTable(targetTable.getTableNameField(), null, null, null, this.getContextManager());
        FromList dummyFromList = new FromList(this.getContextManager());
        dummyFromList.addFromTable(deleteTarget);
        dummyFromList.bindTables(dd, new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager()));
        CurrentOfNode currentOfNode = CurrentOfNode.makeForMerge(CURRENT_OF_NODE_NAME, deleteTarget, this.getContextManager());
        FromList fromList = new FromList(this.getContextManager());
        fromList.addFromTable(currentOfNode);
        SelectNode selectNode = new SelectNode(null, fromList, null, null, null, null, null, this.getContextManager());
        this._dml = new DeleteNode(targetTable.getTableNameField(), selectNode, this, this.getContextManager());
        this.getCompilerContext().removePrivilegeFilter(ignorePermissions);
        this._dml.bindStatement();
        this.buildThenColumnsForDelete();
    }

    private void buildThenColumnsForDelete() throws StandardException {
        ResultColumnList dmlSignature = this._dml.resultSet.getResultColumns();
        for (int i = 0; i < dmlSignature.size(); ++i) {
            ResultColumn newRC;
            ResultColumn origRC = (ResultColumn)dmlSignature.elementAt(i);
            ValueNode expression = origRC.getExpression();
            if (expression instanceof ColumnReference) {
                ColumnReference cr = (ColumnReference)((ColumnReference)expression).getClone();
                newRC = new ResultColumn(cr, (ValueNode)cr, this.getContextManager());
            } else {
                newRC = origRC.cloneMe();
            }
            this._thenColumns.addResultColumn(newRC);
        }
    }

    private void bindInsert(DataDictionary dd, MergeNode mergeNode, FromList fullFromList, FromBaseTable targetTable) throws StandardException {
        ResultColumnList selectList = new ResultColumnList(this.getContextManager());
        for (int i = 0; i < this._insertValues.size(); ++i) {
            ResultColumn rc = (ResultColumn)this._insertValues.elementAt(i);
            selectList.addResultColumn(rc.cloneMe());
        }
        selectList.replaceOrForbidDefaults(targetTable.getTableDescriptor(), this._insertColumns, true);
        this.bindExpressions(selectList, fullFromList);
        this.bindInsertValues(fullFromList, targetTable);
        FromList sourceTableFromList = new FromList(this.getOptimizerFactory().doJoinOrderOptimization(), this.getContextManager());
        sourceTableFromList.addElement((ResultSetNode)fullFromList.elementAt(0));
        this.bindExpressions(this._insertValues, sourceTableFromList);
        SelectNode selectNode = new SelectNode(selectList, fullFromList, null, null, null, null, null, this.getContextManager());
        this._dml = new InsertNode(targetTable.getTableNameField(), this._insertColumns, selectNode, this, null, null, null, null, false, this.getContextManager());
        this._dml.bindStatement();
        this.buildThenColumnsForInsert(fullFromList, targetTable, this._dml.resultSet.getResultColumns(), this._insertColumns, this._insertValues);
    }

    private void bindInsertValues(FromList fullFromList, FromTable targetTable) throws StandardException {
        TableDescriptor td = targetTable.getTableDescriptor();
        if (this._insertColumns == null) {
            this._insertColumns = this.buildFullColumnList(td);
        }
        if (this._insertColumns.size() != this._insertValues.size()) {
            throw StandardException.newException("42802", new Object[0]);
        }
        for (int i = 0; i < this._insertValues.size(); ++i) {
            ResultColumn rc = (ResultColumn)this._insertValues.elementAt(i);
            String columnName = ((ResultColumn)this._insertColumns.elementAt(i)).getName();
            ValueNode expr = rc.getExpression();
            ColumnDescriptor cd = td.getColumnDescriptor(columnName);
            if (cd == null) continue;
            if (cd.isAutoincAlways() && !(expr instanceof DefaultNode)) {
                throw StandardException.newException("42Z23", columnName);
            }
            if (!cd.isAutoincrement() || !(expr instanceof UntypedNullConstantNode)) continue;
            throw StandardException.newException("23502", columnName);
        }
        this._insertValues.replaceOrForbidDefaults(targetTable.getTableDescriptor(), this._insertColumns, true);
        this.bindExpressions(this._insertValues, fullFromList);
    }

    private ResultColumnList buildFullColumnList(TableDescriptor td) throws StandardException {
        ResultColumnList result = new ResultColumnList(this.getContextManager());
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor colDesc = cdl.elementAt(index);
            ColumnReference columnRef = new ColumnReference(colDesc.getColumnName(), null, this.getContextManager());
            ResultColumn resultColumn = new ResultColumn(columnRef, null, this.getContextManager());
            result.addResultColumn(resultColumn);
        }
        return result;
    }

    private void buildThenColumnsForInsert(FromList fullFromList, FromTable targetTable, ResultColumnList fullRow, ResultColumnList insertColumns, ResultColumnList insertValues) throws StandardException {
        boolean wasSkippingTypePrivileges = this.getCompilerContext().skipTypePrivileges(true);
        TableDescriptor td = targetTable.getTableDescriptor();
        this._thenColumns = fullRow.copyListAndObjects();
        for (int i = 0; i < this._thenColumns.size(); ++i) {
            DefaultInfoImpl defaultInfo;
            ResultColumn origRC = (ResultColumn)this._thenColumns.elementAt(i);
            String columnName = origRC.getName();
            ColumnDescriptor cd = td.getColumnDescriptor(columnName);
            boolean changed = false;
            if (!origRC.isAutoincrement() && origRC.getExpression() instanceof VirtualColumnNode) {
                origRC.setExpression(new UntypedNullConstantNode(this.getContextManager()));
            }
            if (cd.hasGenerationClause()) {
                origRC.setExpression(new UntypedNullConstantNode(this.getContextManager()));
                continue;
            }
            for (int ic = 0; ic < insertColumns.size(); ++ic) {
                ResultColumn icRC = (ResultColumn)insertColumns.elementAt(ic);
                if (!columnName.equals(icRC.getName())) continue;
                ResultColumn newRC = null;
                ResultColumn valueRC = (ResultColumn)insertValues.elementAt(ic);
                if (valueRC.wasDefaultColumn() || valueRC.getExpression() instanceof UntypedNullConstantNode) {
                    if (!cd.isAutoincrement()) {
                        ValueNode expr = origRC.getExpression();
                        if (!(expr instanceof ColumnReference)) continue;
                        origRC.setExpression(new UntypedNullConstantNode(this.getContextManager()));
                        continue;
                    }
                    newRC = this.makeAutoGenRC(targetTable, origRC, i + 1);
                } else {
                    newRC = valueRC.cloneMe();
                    newRC.setType(origRC.getTypeServices());
                }
                newRC.setVirtualColumnId(origRC.getVirtualColumnId());
                this._thenColumns.setElementAt(newRC, i);
                changed = true;
                break;
            }
            if (!(changed || (defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo()) == null || defaultInfo.isGeneratedColumn() || cd.isAutoincrement())) {
                this._thenColumns.setDefault(origRC, cd, defaultInfo);
                changed = true;
            }
            ResultColumn finalRC = (ResultColumn)this._thenColumns.elementAt(i);
            finalRC.setName(cd.getColumnName());
        }
        this.getCompilerContext().skipTypePrivileges(wasSkippingTypePrivileges);
    }

    private ResultColumn makeAutoGenRC(FromTable targetTable, ResultColumn origRC, int virtualColumnID) throws StandardException {
        String columnName = origRC.getName();
        ColumnReference autoGenCR = new ColumnReference(columnName, targetTable.getTableName(), this.getContextManager());
        ResultColumn autoGenRC = new ResultColumn(autoGenCR, null, this.getContextManager());
        VirtualColumnNode autoGenVCN = new VirtualColumnNode(targetTable, autoGenRC, virtualColumnID, this.getContextManager());
        ResultColumn newRC = new ResultColumn(autoGenCR, (ValueNode)autoGenVCN, this.getContextManager());
        newRC.setType(origRC.getTypeServices());
        return newRC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindExpressions(ResultColumnList rcl, FromList fromList) throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        int previousReliability = cc.getReliability();
        boolean wasSkippingTypePrivileges = cc.skipTypePrivileges(true);
        cc.setReliability(previousReliability | 0x2000);
        try {
            rcl.bindExpressions(fromList, new SubqueryList(this.getContextManager()), new ArrayList<AggregateNode>());
        }
        finally {
            cc.setReliability(previousReliability);
            cc.skipTypePrivileges(wasSkippingTypePrivileges);
        }
    }

    private void forbidSubqueries() throws StandardException {
        this.forbidSubqueries(this._matchingRefinement);
        this.forbidSubqueries(this._updateColumns);
        this.forbidSubqueries(this._insertColumns);
        this.forbidSubqueries(this._insertValues);
    }

    private void forbidSubqueries(ResultColumnList rcl) throws StandardException {
        if (rcl != null) {
            for (int i = 0; i < rcl.size(); ++i) {
                this.forbidSubqueries((ValueNode)rcl.elementAt(i));
            }
        }
    }

    private void forbidSubqueries(ValueNode expr) throws StandardException {
        if (expr != null) {
            CollectNodesVisitor<SubqueryNode> getSubqueries = new CollectNodesVisitor<SubqueryNode>(SubqueryNode.class);
            expr.accept(getSubqueries);
            if (getSubqueries.getList().size() > 0) {
                throw StandardException.newException("42XAO", new Object[0]);
            }
        }
    }

    void optimize() throws StandardException {
        this._dml.optimizeStatement();
    }

    ConstantAction makeConstantAction(ActivationClassBuilder acb) throws StandardException {
        String refinementName = null;
        if (this._matchingRefinement != null) {
            MethodBuilder userExprFun = acb.newUserExprFun();
            this._matchingRefinement.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            refinementName = userExprFun.getName();
        }
        return this.getGenericConstantActionFactory().getMatchingClauseConstantAction(this.getClauseType(), refinementName, this.buildThenColumnSignature(), this._rowMakingMethodName, this._resultSetFieldName, this._actionMethodName, this._dml.makeConstantAction());
    }

    private int getClauseType() {
        if (this.isUpdateClause()) {
            return 1;
        }
        if (this.isInsertClause()) {
            return 0;
        }
        return 2;
    }

    private ResultDescription buildThenColumnSignature() throws StandardException {
        ResultColumnDescriptor[] cells = this._thenColumns.makeResultDescriptors();
        return this.getLanguageConnectionContext().getLanguageFactory().getResultDescription(cells, "MERGE");
    }

    void generate(ActivationClassBuilder acb, ResultColumnList selectList, ResultSetNode generatedScan, HalfOuterJoinNode hojn, int clauseNumber) throws StandardException {
        this._clauseNumber = clauseNumber;
        this.adjustMatchingRefinement(selectList, generatedScan);
        this.generateInsertUpdateRow(acb, selectList, generatedScan, hojn);
        this._actionMethodName = "mergeActionMethod_" + this._clauseNumber;
        MethodBuilder mb = acb.getClassBuilder().newMethodBuilder(1, "org.apache.derby.iapi.sql.ResultSet", this._actionMethodName);
        mb.addThrownException("org.apache.derby.shared.common.error.StandardException");
        this.remapConstraints();
        this._dml.generate(acb, mb);
        mb.methodReturn();
        mb.complete();
    }

    private void remapConstraints() throws StandardException {
        ValueNode checkConstraints;
        if (this.isDeleteClause()) {
            return;
        }
        ValueNode valueNode = checkConstraints = this.isInsertClause() ? ((InsertNode)this._dml).checkConstraints : ((UpdateNode)this._dml).checkConstraints;
        if (checkConstraints != null) {
            List<ColumnReference> colRefs = this.getColumnReferences(checkConstraints);
            for (ColumnReference cr : colRefs) {
                cr.getSource().setResultSetNumber(0);
            }
        }
    }

    void generateResultSetField(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this._resultSetFieldName = "mergeResultSetField_" + this._clauseNumber;
        LocalField resultSetField = acb.newFieldDeclaration(1, "org.apache.derby.iapi.sql.execute.NoPutResultSet", this._resultSetFieldName);
        mb.getField(resultSetField);
    }

    private void generateInsertUpdateRow(ActivationClassBuilder acb, ResultColumnList selectList, ResultSetNode generatedScan, HalfOuterJoinNode hojn) throws StandardException {
        this.adjustThenColumns(selectList, generatedScan, hojn);
        this._rowMakingMethodName = "mergeRowMakingMethod_" + this._clauseNumber;
        MethodBuilder mb = acb.getClassBuilder().newMethodBuilder(1, "org.apache.derby.iapi.sql.execute.ExecRow", this._rowMakingMethodName);
        mb.addThrownException("org.apache.derby.shared.common.error.StandardException");
        this._thenColumns.generateEvaluatedRow(acb, mb, false, true);
    }

    private void adjustMatchingRefinement(ResultColumnList selectList, ResultSetNode generatedScan) throws StandardException {
        if (this._matchingRefinement != null) {
            this.useGeneratedScan(selectList, generatedScan, this._matchingRefinement);
        }
    }

    private void adjustThenColumns(ResultColumnList selectList, ResultSetNode generatedScan, HalfOuterJoinNode hojn) throws StandardException {
        ResultColumnList leftJoinResult = generatedScan.getResultColumns();
        this.useGeneratedScan(selectList, generatedScan, this._thenColumns);
        int lastRCSlot = this._thenColumns.size() - 1;
        ResultColumn lastRC = (ResultColumn)this._thenColumns.elementAt(lastRCSlot);
        if (this.isRowLocation(lastRC)) {
            ResultColumn lastLeftJoinRC = (ResultColumn)leftJoinResult.elementAt(leftJoinResult.size() - 1);
            ValueNode value = lastLeftJoinRC.getExpression();
            String columnName = lastLeftJoinRC.getName();
            ColumnReference rowLocationCR = new ColumnReference(columnName, hojn.getTableName(), this.getContextManager());
            rowLocationCR.setSource(lastLeftJoinRC);
            ResultColumn rowLocationRC = new ResultColumn(columnName, (ValueNode)rowLocationCR, this.getContextManager());
            this._thenColumns.removeElementAt(lastRCSlot);
            this._thenColumns.addResultColumn(rowLocationRC);
        }
    }

    private void useGeneratedScan(ResultColumnList selectList, ResultSetNode generatedScan, QueryTreeNode node) throws StandardException {
        ResultColumnList leftJoinResult = generatedScan.getResultColumns();
        for (ColumnReference cr : this.getColumnReferences(node)) {
            ResultColumn leftJoinRC = (ResultColumn)leftJoinResult.elementAt(this.getSelectListOffset(selectList, cr) - 1);
            cr.setSource(leftJoinRC);
        }
    }

    private int getSelectListOffset(ResultColumnList selectList, ValueNode thenExpression) throws StandardException {
        int selectCount = selectList.size();
        if (thenExpression instanceof ColumnReference) {
            ColumnReference thenCR = (ColumnReference)thenExpression;
            String thenCRName = thenCR.getColumnName();
            int thenCRMergeTableID = this.getMergeTableID(thenCR);
            for (int sidx = 0; sidx < selectCount; ++sidx) {
                ColumnReference selectCR;
                ResultColumn selectRC = (ResultColumn)selectList.elementAt(sidx);
                ValueNode selectExpression = selectRC.getExpression();
                ColumnReference columnReference = selectCR = selectExpression instanceof ColumnReference ? (ColumnReference)selectExpression : null;
                if (selectCR == null || this.getMergeTableID(selectCR) != thenCRMergeTableID || !thenCRName.equals(selectCR.getColumnName())) continue;
                return sidx + 1;
            }
            SanityManager.THROWASSERT("Can't find select list column corresponding to " + thenCR.getSQLColumnName() + " with merge table id = " + thenCRMergeTableID);
        } else if (thenExpression instanceof CurrentRowLocationNode) {
            return selectCount;
        }
        return -1;
    }

    private int getMergeTableID(ColumnReference cr) {
        int mergeTableID = cr.getMergeTableID();
        SanityManager.ASSERT(mergeTableID == 1 || mergeTableID == 2, "Column " + cr.getSQLColumnName() + " has illegal MERGE table id: " + mergeTableID);
        return mergeTableID;
    }

    @Override
    void acceptChildren(Visitor v) throws StandardException {
        super.acceptChildren(v);
        if (this._matchingRefinement != null) {
            this._matchingRefinement.accept(v);
        }
        if (this._updateColumns != null) {
            this._updateColumns.accept(v);
        }
        if (this._insertColumns != null) {
            this._insertColumns.accept(v);
        }
        if (this._insertValues != null) {
            this._insertValues.accept(v);
        }
        if (this._dml != null) {
            this._dml.accept(v);
        }
    }

    @Override
    void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this._matchingRefinement != null) {
            this.printLabel(depth, "matchingRefinement: ");
            this._matchingRefinement.treePrint(depth + 1);
        }
        if (this._updateColumns != null) {
            this.printLabel(depth, "updateColumns: ");
            this._updateColumns.treePrint(depth + 1);
        }
        if (this._insertColumns != null) {
            this.printLabel(depth, "insertColumns: ");
            this._insertColumns.treePrint(depth + 1);
        }
        if (this._insertValues != null) {
            this.printLabel(depth, "insertValues: ");
            this._insertValues.treePrint(depth + 1);
        }
    }

    @Override
    public String toString() {
        if (this.isUpdateClause()) {
            return "UPDATE";
        }
        if (this.isInsertClause()) {
            return "INSERT";
        }
        return "DELETE";
    }

    private List<ColumnReference> getColumnReferences(QueryTreeNode expression) throws StandardException {
        CollectNodesVisitor<ColumnReference> getCRs = new CollectNodesVisitor<ColumnReference>(ColumnReference.class);
        expression.accept(getCRs);
        return getCRs.getList();
    }

    private boolean isRowLocation(ResultColumn rc) throws StandardException {
        if (rc.getExpression() instanceof CurrentRowLocationNode) {
            return true;
        }
        DataTypeDescriptor dtd = rc.getTypeServices();
        return dtd != null && dtd.getTypeId().isRefTypeId();
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return MatchingClauseNode.referencesSessionSchema(this._matchingRefinement) || MatchingClauseNode.referencesSessionSchema(this._updateColumns) || MatchingClauseNode.referencesSessionSchema(this._insertColumns) || MatchingClauseNode.referencesSessionSchema(this._insertValues);
    }

    private static boolean referencesSessionSchema(QueryTreeNode node) throws StandardException {
        return node != null && node.referencesSessionSchema();
    }
}

