/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.OnlineBackup;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class OnlineBackupTest3 {
    private static final String TEST_DATABASE_NAME = "wombat";
    private static final String BACKUP_PATH = "extinout/onlinebackuptest3";

    public static void main(String[] argv) throws Throwable {
        OnlineBackupTest3 test = new OnlineBackupTest3();
        ij.getPropertyArg((String[])argv);
        try {
            test.runTest();
        }
        catch (SQLException sqle) {
            OnlineBackupTest3.dumpSQLException(sqle);
        }
    }

    private void runTest() throws Exception {
        this.logMessage("Begin Online Backup Test3");
        Connection conn = ij.startJBMS();
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1(a int ) ");
        stmt.execute("insert into t1 values(1)");
        stmt.execute("insert into t1 values(2)");
        stmt.execute("create table customer(id int , name varchar(100))");
        stmt.execute("insert into customer values(1, 'ABC')");
        stmt.execute("insert into customer values(2, 'XYZ')");
        String crproc = "create procedure addCustomer(id INT, name VARCHAR(100)) MODIFIES SQL DATA external name 'org.apache.derbyTesting.backupRestore.Customer.addCustomer'  language java parameter style java ";
        stmt.execute(crproc);
        String dvfunc = "create function dv(P1 INT) RETURNS INT NO SQL  external name 'dbytesting.CodeInAJar.doubleMe'  language java parameter style java ";
        stmt.execute(dvfunc);
        conn.commit();
        this.logMessage("Initial Setup Complete");
        this.installJarTest();
        this.removeJarTest();
        this.logMessage("End Online Backup Test3");
    }

    void shutdown(String dbName) {
        try {
            TestUtil.getConnection(dbName, "shutdown=true");
        }
        catch (SQLException se) {
            if (se.getSQLState() != null && se.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            }
            OnlineBackupTest3.dumpSQLException(se);
        }
    }

    void logMessage(String str) {
        System.out.println(str);
    }

    private static void dumpSQLException(SQLException sqle) {
        JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
        sqle.printStackTrace(System.out);
    }

    private int countRows(Connection conn, String tableName) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT count(*) from " + tableName);
        rs.next();
        int noRows = rs.getInt(1);
        rs.close();
        s.close();
        return noRows;
    }

    void installJarTest() throws Exception {
        this.logMessage("Begin Install Jar Test");
        Connection conn1 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        conn1.setAutoCommit(false);
        Statement conn1_stmt = conn1.createStatement();
        Connection conn2 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        conn2.setAutoCommit(false);
        Statement conn2_stmt = conn2.createStatement();
        conn1_stmt.execute("call sqlj.install_jar('extin/brtestjar.jar', 'math_routines', 0)");
        try {
            conn2_stmt.execute("call SYSCS_UTIL.SYSCS_BACKUP_DATABASE_NOWAIT('extinout/mybackup')");
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
        }
        OnlineBackup backup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        Thread backupThread = new Thread((Runnable)backup, "BACKUP1");
        backupThread.start();
        backup.waitForBackupToBegin();
        this.logMessage("Backup-1 Started");
        Thread.sleep(1000L);
        if (!backup.isRunning()) {
            this.logMessage("Backup is not waiting for unlogged install jar action to commit");
        }
        conn1_stmt.execute("insert into t1 values(3)");
        conn1_stmt.execute("insert into t1 values(4)");
        conn1_stmt.execute("insert into t1 values(5)");
        conn1_stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', 'APP.math_routines') ");
        conn1.commit();
        this.logMessage("The transaction that was blocking the backup has ended");
        backup.waitForBackupToEnd();
        backupThread.join();
        this.logMessage("Backup-1 Completed");
        conn1_stmt.execute("create index idx1 on customer(id)");
        conn1_stmt.execute("insert into t1 values(6)");
        backup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        backupThread = new Thread((Runnable)backup, "BACKUP2");
        backupThread.start();
        backup.waitForBackupToBegin();
        this.logMessage("Backup-2 Started");
        Thread.sleep(1000L);
        if (!backup.isRunning()) {
            this.logMessage("Backup is not waiting for unlogged index action to commit");
        }
        AsyncStatementThread asyncJarActionThread = new AsyncStatementThread(conn2, "call sqlj.install_jar('extin/obtest_customer.jar', 'customer_app', 0)");
        asyncJarActionThread.start();
        this.logMessage("Started obtest_customer.jar addition in seperate thread");
        Thread.sleep(1000L);
        conn1.rollback();
        this.logMessage("The transaction that was blocking the backup has ended");
        backup.waitForBackupToEnd();
        backupThread.join();
        this.logMessage("Backup-2 Completed");
        asyncJarActionThread.join();
        this.logMessage("obtest_customer.jar addition is complete");
        conn1_stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', 'APP.customer_app:APP.math_routines') ");
        conn1.commit();
        conn1_stmt.execute("call addCustomer(3 , 'John')");
        conn1.commit();
        this.logMessage("No of rows in table t1: " + this.countRows(conn1, "T1"));
        this.logMessage("No of rows in table customer: " + this.countRows(conn1, "customer"));
        conn1.commit();
        conn2.commit();
        conn1_stmt.close();
        conn2_stmt.close();
        conn1.close();
        conn2.close();
        this.shutdown(TEST_DATABASE_NAME);
        backup.restoreFromBackup();
        this.logMessage("Restored From the Backup");
        Connection conn = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        Statement stmt = conn.createStatement();
        this.logMessage("No of rows in table t1: " + this.countRows(conn, "T1"));
        this.logMessage("No of rows in table customer: " + this.countRows(conn, "customer"));
        stmt.execute("select dv(a) from t1");
        try {
            stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', 'APP.customer_app:APP.math_routines') ");
            stmt.execute("call addCustomer(3 , 'John')");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        stmt.close();
        conn.close();
        this.shutdown(TEST_DATABASE_NAME);
        this.logMessage("End Of Install Jar Test.");
    }

    void removeJarTest() throws Exception {
        this.logMessage("Begin Remove Jar Test");
        Connection conn1 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        conn1.setAutoCommit(false);
        Statement conn1_stmt = conn1.createStatement();
        Connection conn2 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        conn2.setAutoCommit(false);
        Statement conn2_stmt = conn2.createStatement();
        try {
            conn1_stmt.execute("call sqlj.install_jar('extin/obtest_customer.jar', 'customer_app', 0)");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn1_stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', '')");
        conn1.commit();
        conn1_stmt.execute("call sqlj.remove_jar('APP.math_routines', 0)");
        try {
            conn2_stmt.execute("call SYSCS_UTIL.SYSCS_BACKUP_DATABASE_NOWAIT('extinout/mybackup')");
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
        }
        OnlineBackup backup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        Thread backupThread = new Thread((Runnable)backup, "BACKUP3");
        backupThread.start();
        backup.waitForBackupToBegin();
        this.logMessage("Backup-3 Started");
        Thread.sleep(1000L);
        if (!backup.isRunning()) {
            this.logMessage("Backup is not waiting for unlogged remove jar action to commit");
        }
        conn1_stmt.execute("insert into t1 values(10)");
        conn1_stmt.execute("insert into t1 values(11)");
        conn1.commit();
        this.logMessage("The transaction that was blocking the backup has ended");
        backup.waitForBackupToEnd();
        backupThread.join();
        this.logMessage("Backup-3 Completed");
        conn1_stmt.execute("create index idx1 on customer(id)");
        conn1_stmt.execute("insert into t1 values(12)");
        backup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        backupThread = new Thread((Runnable)backup, "BACKUP4");
        backupThread.start();
        backup.waitForBackupToBegin();
        this.logMessage("Backup-4 Started");
        Thread.sleep(1000L);
        if (!backup.isRunning()) {
            this.logMessage("Backup is not waiting for unlogged index action to commit");
        }
        AsyncStatementThread asyncJarActionThread = new AsyncStatementThread(conn2, "call sqlj.remove_jar('APP.customer_app', 0)");
        asyncJarActionThread.start();
        this.logMessage("Started obtest_customer.jar remove in seperate thread");
        Thread.sleep(1000L);
        conn1.rollback();
        this.logMessage("The transaction that was blocking the backup has ended");
        backup.waitForBackupToEnd();
        backupThread.join();
        this.logMessage("Backup-4 Completed");
        asyncJarActionThread.join();
        this.logMessage("obtest_customer.jar remove is complete");
        conn1_stmt.execute("insert into t1 values(13)");
        this.logMessage("No of rows in table t1: " + this.countRows(conn1, "T1"));
        this.logMessage("No of rows in table customer: " + this.countRows(conn1, "customer"));
        conn1.commit();
        conn2.commit();
        conn1_stmt.close();
        conn2_stmt.close();
        conn1.close();
        conn2.close();
        this.shutdown(TEST_DATABASE_NAME);
        backup.restoreFromBackup();
        this.logMessage("Restored From the Backup");
        Connection conn = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        Statement stmt = conn.createStatement();
        this.logMessage("No of rows in table t1: " + this.countRows(conn, "T1"));
        this.logMessage("No of rows in table customer: " + this.countRows(conn, "customer"));
        try {
            stmt.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', 'APP.math_routines') ");
        }
        catch (SQLException sqle) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
        }
        stmt.close();
        conn.close();
        this.shutdown(TEST_DATABASE_NAME);
        this.logMessage("End Of Remove Jar Test.");
    }

    class AsyncStatementThread
    extends Thread {
        Connection conn;
        String stmt;

        AsyncStatementThread(Connection conn, String stmt) {
            this.conn = conn;
            this.stmt = stmt;
        }

        @Override
        public void run() {
            Statement aStatement = null;
            try {
                aStatement = this.conn.createStatement();
                aStatement.execute(this.stmt);
                aStatement.close();
                this.conn.commit();
            }
            catch (SQLException sqle) {
                JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sqle);
                sqle.printStackTrace(System.out);
            }
            aStatement = null;
        }
    }
}

