/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.i18n;

import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Locale;
import junit.extensions.TestSetup;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UrlLocaleTest
extends BaseJDBCTestCase {
    public UrlLocaleTest(String name) {
        super(name);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        TestConfiguration.getCurrent().shutdownEngine();
        String driverClass = TestConfiguration.getCurrent().getJDBCClient().getJDBCDriverName();
        Class<?> clazz = Class.forName(driverClass);
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public void testURLLocale() throws SQLException, MalformedURLException {
        Statement s = this.createStatement();
        s.executeUpdate("call checkRDefaultLoc()");
        Object url = UrlLocaleTest.getReadWriteJDBCURL("swissdb");
        url = (String)url + ";create=true;territory=fr_CH";
        Connection locConn = DriverManager.getConnection((String)url);
        UrlLocaleTest.createLocaleProcedures(locConn);
        Statement locStatement = locConn.createStatement();
        locStatement.executeUpdate("call checkDatabaseLoc('fr_CH')");
        locStatement.close();
        locConn.close();
        url = UrlLocaleTest.getReadWriteJDBCURL("hindi");
        url = (String)url + ";create=true;territory=hi_IN";
        locConn = DriverManager.getConnection((String)url);
        UrlLocaleTest.createLocaleProcedures(locConn);
        locStatement = locConn.createStatement();
        locStatement.executeUpdate("call checkDatabaseLoc('hi_IN')");
        locStatement.close();
        locConn.close();
        url = UrlLocaleTest.getReadWriteJDBCURL("Israel");
        url = (String)url + ";create=true;territory=en_IL_JavaOS";
        locConn = DriverManager.getConnection((String)url);
        UrlLocaleTest.createLocaleProcedures(locConn);
        locStatement = locConn.createStatement();
        locStatement.executeUpdate("call checkDatabaseLoc('en_IL_JavaOS')");
        locStatement.close();
        locConn.close();
        url = UrlLocaleTest.getReadWriteJDBCURL("bacon");
        url = (String)url + ";create=true;territory=da";
        locConn = DriverManager.getConnection((String)url);
        UrlLocaleTest.createLocaleProcedures(locConn);
        locStatement = locConn.createStatement();
        locStatement.executeUpdate("call checkDatabaseLoc('da')");
        locStatement.close();
        locConn.close();
    }

    public void testUrlLocaleNegative() throws SQLException {
        Object url = UrlLocaleTest.getReadWriteJDBCURL("fail1");
        url = (String)url + ";create=true;territory=";
        this.checkInvalidTerritoryFormat((String)url);
        url = UrlLocaleTest.getReadWriteJDBCURL("fail1");
        try {
            DriverManager.getConnection((String)url);
            UrlLocaleTest.fail((String)("Database connect " + (String)url + " should fail because db does not exist"));
        }
        catch (SQLException se) {
            UrlLocaleTest.assertSQLState("XJ004", se);
        }
        this.checkInvalidTerritoryFormat("en_");
        this.checkInvalidTerritoryFormat("en_d");
        this.checkInvalidTerritoryFormat("en-US");
    }

    public void messageLocale_unknown() throws SQLException {
        Object url = UrlLocaleTest.getReadWriteJDBCURL("rrTTdb");
        url = (String)url + ";create=true";
        Connection locConn = DriverManager.getConnection((String)url);
        Statement s = locConn.createStatement();
        UrlLocaleTest.createLocaleProcedures(locConn);
        s.executeUpdate("call checkDefaultLoc()");
        s.executeUpdate("call checkDatabaseLoc('rr_TT')");
        try {
            s.executeUpdate("create table t1 oops (i int)");
        }
        catch (SQLException se) {
            UrlLocaleTest.assertSQLState("42X01", se);
            UrlLocaleTest.assertTrue((String)"Expected English Message with \"Encountered\" ", (se.getMessage().indexOf("Encountered") != -1 ? 1 : 0) != 0);
        }
        s.executeUpdate("create table t2 (i int)");
        s.executeUpdate("create index i2_a on t2(i)");
        s.executeUpdate("create index i2_b on t2(i)");
        SQLWarning sqlw = s.getWarnings();
        UrlLocaleTest.assertSQLState("01504", sqlw);
        UrlLocaleTest.assertTrue((String)"Expected English warning", (sqlw.getMessage().indexOf("duplicate") != -1 ? 1 : 0) != 0);
        s.close();
        locConn.close();
    }

    public void messageLocale_Germany() throws SQLException {
        Object url = UrlLocaleTest.getReadWriteJDBCURL("qqPPdb");
        url = (String)url + ";create=true;territory=qq_PP_testOnly";
        Connection locConn = DriverManager.getConnection((String)url);
        Statement s = locConn.createStatement();
        s.executeUpdate("create table t2 (i int)");
        s.executeUpdate("create index i2_a on t2(i)");
        try {
            s.executeUpdate("create table t1 oops (i int)");
        }
        catch (SQLException se) {
            UrlLocaleTest.assertSQLState("42X01", se);
            UrlLocaleTest.assertTrue((String)"Expected qq_PP Message with \"Encountered\" ", (se.getMessage().indexOf("Encountered") != -1 ? 1 : 0) != 0);
        }
        s.executeUpdate("create index i2_b on t2(i)");
        SQLWarning sqlw = s.getWarnings();
        UrlLocaleTest.assertSQLState("01504", sqlw);
        UrlLocaleTest.assertTrue((String)"Expected German warning with Duplikat", (sqlw.getMessage().indexOf(" Duplikat") != -1 ? 1 : 0) != 0);
        try {
            s.executeUpdate("drop table t3");
        }
        catch (SQLException se) {
            UrlLocaleTest.assertSQLState("42Y55", se);
            UrlLocaleTest.assertTrue((String)"Expected German Message with vorhanden", (se.getMessage().indexOf("vorhanden") != -1 ? 1 : 0) != 0);
        }
        url = UrlLocaleTest.getReadWriteJDBCURL("enUSdb");
        url = (String)url + ";create=true;territory=en_US";
        locConn = DriverManager.getConnection((String)url);
        s = locConn.createStatement();
        s.executeUpdate("create table t2 (i int)");
        s.executeUpdate("create index i2_a on t2(i)");
        try {
            s.executeUpdate("create table t1 oops (i int)");
        }
        catch (SQLException se) {
            UrlLocaleTest.assertSQLState("42X01", se);
            UrlLocaleTest.assertTrue((String)"Expected English message with \"Encountered\" ", (se.getMessage().indexOf("Encountered") != -1 ? 1 : 0) != 0);
        }
        s.executeUpdate("create index i2_b on t2(i)");
        sqlw = s.getWarnings();
        UrlLocaleTest.assertSQLState("01504", sqlw);
        UrlLocaleTest.assertTrue((String)"Expected English warning with duplicate", (sqlw.getMessage().indexOf("duplicate") != -1 ? 1 : 0) != 0);
        try {
            s.executeUpdate("drop table t3");
        }
        catch (SQLException se) {
            UrlLocaleTest.assertSQLState("42Y55", se);
            UrlLocaleTest.assertTrue((String)"Expected English Message with performed", (se.getMessage().indexOf("performed") != -1 ? 1 : 0) != 0);
        }
    }

    private void checkInvalidTerritoryFormat(String territory) {
        try {
            Object url = UrlLocaleTest.getReadWriteJDBCURL("fail3");
            url = (String)url + ";create=true;territory=" + territory;
            DriverManager.getConnection((String)url);
            UrlLocaleTest.fail((String)("connection without territory: " + (String)url + "should have failed"));
        }
        catch (SQLException se) {
            UrlLocaleTest.assertSQLState("XJ041", se);
            UrlLocaleTest.assertSQLState("XBM0X", se.getNextException());
        }
    }

    private static String getReadWriteJDBCURL(String dbname) {
        return TestConfiguration.getCurrent().getJDBCUrl(SupportFilesSetup.getReadWriteFileName(dbname));
    }

    private static void createLocaleProcedures(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.executeUpdate("create procedure checkDatabaseLoc(in locale char(12)) parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.i18n.DefaultLocale.checkDatabaseLocale'");
        s.executeUpdate("create procedure checkRDefaultLoc() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.i18n.DefaultLocale.checkRDefaultLocale'");
        s.executeUpdate("create procedure checkDefaultLoc() parameter style java language java external name 'org.apache.derbyTesting.functionTests.tests.i18n.DefaultLocale.checkDefaultLocale'");
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite();
        suite.addTestSuite(UrlLocaleTest.class);
        suite.addTest((Test)new LocaleTestSetup((Test)new UrlLocaleTest("messageLocale_unknown"), Locale.of("rr", "TT")));
        suite.addTest((Test)new LocaleTestSetup((Test)new UrlLocaleTest("messageLocale_Germany"), Locale.GERMANY));
        TestSetup tsuite = new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                UrlLocaleTest.createLocaleProcedures(s.getConnection());
            }
        };
        tsuite = new SupportFilesSetup((Test)tsuite);
        return tsuite;
    }
}

