/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Vector;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbc4.BlobClobTestSetup;
import org.apache.derbyTesting.functionTests.tests.jdbc4.ExemptClobMD;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ClobTest
extends BaseJDBCTestCase {
    private Clob clob = null;
    private static final ExemptClobMD[] emd = new ExemptClobMD[]{new ExemptClobMD("getCharacterStream", new Class[]{Long.TYPE, Long.TYPE}, true, true), new ExemptClobMD("setString", new Class[]{Long.TYPE, String.class}, false, true), new ExemptClobMD("truncate", new Class[]{Long.TYPE}, false, true), new ExemptClobMD("free", null, true, true)};
    private HashMap<Method, ExemptClobMD> excludedMethodSet = new HashMap();
    private static final String LOCK_TIMEOUT = "40XL1";

    public ClobTest(String name) {
        super(name);
    }

    public void setUp() throws SQLException {
        this.getConnection().setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.clob != null) {
            this.clob.free();
            this.clob = null;
        }
        this.excludedMethodSet = null;
        super.tearDown();
    }

    void buildHashSet() {
        Class<Clob> iface = Clob.class;
        for (int i = 0; i < emd.length; ++i) {
            try {
                Method m = iface.getMethod(emd[i].getMethodName(), emd[i].getParams());
                this.excludedMethodSet.put(m, emd[i]);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                ClobTest.fail((String)"The method could not be found in the interface");
            }
        }
    }

    public void testFreeAfterImplicitFree() throws SQLException {
        Connection conn = this.getConnection();
        this.clob = BlobClobTestSetup.getSampleClob(conn);
        conn.commit();
        this.clob.free();
    }

    public void testFreeandMethodsAfterCallingFree() throws IllegalAccessException, InvocationTargetException, SQLException {
        this.clob = BlobClobTestSetup.getSampleClob(this.getConnection());
        this.buildHashSet();
        InputStream asciiStream = this.clob.getAsciiStream();
        Reader charStream = this.clob.getCharacterStream();
        this.clob.free();
        this.clob.free();
        this.buildMethodList(this.clob);
    }

    void buildMethodList(Object LOB) throws IllegalAccessException, InvocationTargetException {
        boolean valid = true;
        Vector<Method> methodList = new Vector<Method>();
        Class<Clob> clazz = Clob.class;
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (this.checkIfExempted(methods[i])) continue;
            valid = this.checkIfMethodThrowsSQLException(LOB, methods[i]);
            if (!valid) {
                methodList.add(methods[i]);
            }
            valid = true;
        }
        if (!methodList.isEmpty()) {
            int c = 0;
            Object failureMessage = "The Following methods don't throw required exception - ";
            for (Method m : methodList) {
                if (++c == methodList.size() && c != 1) {
                    failureMessage = (String)failureMessage + " & ";
                } else if (c != 1) {
                    failureMessage = (String)failureMessage + " , ";
                }
                failureMessage = (String)failureMessage + m.getName();
            }
            ClobTest.fail((String)failureMessage);
        }
    }

    boolean checkIfExempted(Method m) {
        ExemptClobMD md = this.excludedMethodSet.get(m);
        boolean isExempted = false;
        if (md != null) {
            if (ClobTest.usingDerbyNetClient()) {
                isExempted = md.getIfClientFramework();
            } else if (ClobTest.usingEmbedded()) {
                isExempted = md.getIfEmbeddedFramework();
            } else {
                ClobTest.fail((String)"Unknown test environment/framework");
            }
        }
        return isExempted;
    }

    boolean checkIfMethodThrowsSQLException(Object LOB, Method method) throws IllegalAccessException, InvocationTargetException {
        try {
            method.invoke(LOB, this.getNullValues(method.getParameterTypes()));
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof SQLException) {
                return ((SQLException)cause).getSQLState().equals("XJ215");
            }
            throw ite;
        }
        return false;
    }

    Object[] getNullValues(Class<?>[] params) {
        Object[] args = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            args[i] = this.getNullValueForType(params[i]);
        }
        return args;
    }

    Object getNullValueForType(Class type) {
        if (!type.isPrimitive()) {
            return null;
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (type == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (type == Byte.TYPE) {
            return (byte)0;
        }
        if (type == Short.TYPE) {
            return (short)0;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        ClobTest.fail((String)("Don't know how to handle type " + String.valueOf(type)));
        return null;
    }

    public void testGetCharacterStreamLong() throws Exception {
        String str1 = "This is a test String. This is a test String";
        StringReader r1 = new StringReader(str1);
        PreparedStatement ps = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setCharacterStream(2, r1);
        ps.execute();
        ps.close();
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select CLOBDATA from BLOBCLOB where ID=" + id);
        rs.next();
        Clob clob = rs.getClob(1);
        Reader r_1 = clob.getCharacterStream(2L, 5L);
        String str2 = str1.substring(1, 6);
        StringReader r_2 = new StringReader(str2);
        ClobTest.assertEquals(r_2, r_1);
        rs.close();
        st.close();
    }

    public void testGetCharacterStreamLongLastCharLatin() throws IOException, SQLException {
        CharAlphabet alphabet = CharAlphabet.modernLatinLowercase();
        int length = 5000;
        PreparedStatement ps = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)length, alphabet), length);
        ps.execute();
        ps.close();
        this.getCharacterStreamLongLastChar(id, length, alphabet);
    }

    public void testGetCharacterStreamLongLastCharCJK() throws IOException, SQLException {
        CharAlphabet alphabet = CharAlphabet.cjkSubset();
        int length = 9001;
        PreparedStatement ps = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader((long)length, alphabet), length);
        ps.execute();
        ps.close();
        this.getCharacterStreamLongLastChar(id, length, alphabet);
    }

    private void getCharacterStreamLongLastChar(int id, int length, CharAlphabet alphabet) throws IOException, SQLException {
        LoopingAlphabetReader cmpReader = new LoopingAlphabetReader((long)length, alphabet);
        cmpReader.skip(length - 1);
        char srcLastChar = (char)((Reader)cmpReader).read();
        ClobTest.assertTrue((((Reader)cmpReader).read() == -1 ? 1 : 0) != 0);
        PreparedStatement ps = this.prepareStatement("select CLOBDATA from BLOBCLOB where ID=?");
        ps.setInt(1, id);
        int charsToRead = length;
        ResultSet rs = ps.executeQuery();
        rs.next();
        Reader reader = rs.getClob(1).getCharacterStream(length - charsToRead + 1, charsToRead);
        char lastCharRead = ClobTest.getLastCharInStream(reader, charsToRead);
        ClobTest.assertEquals((char)srcLastChar, (char)lastCharRead);
        reader.close();
        rs.close();
        charsToRead = length / 4;
        rs = ps.executeQuery();
        rs.next();
        reader = rs.getClob(1).getCharacterStream(length - charsToRead + 1, charsToRead);
        lastCharRead = ClobTest.getLastCharInStream(reader, charsToRead);
        ClobTest.assertEquals((char)srcLastChar, (char)lastCharRead);
        reader.close();
        rs.close();
        charsToRead = 1;
        rs = ps.executeQuery();
        rs.next();
        reader = rs.getClob(1).getCharacterStream(length - charsToRead + 1, charsToRead);
        lastCharRead = ClobTest.getLastCharInStream(reader, charsToRead);
        ClobTest.assertEquals((char)srcLastChar, (char)lastCharRead);
        reader.close();
        rs.close();
    }

    public void testGetCharacterStreamLongOnLargeClob() throws Exception {
        this.getConnection().setAutoCommit(false);
        int size = 33000;
        StringBuilder sb = new StringBuilder(33000);
        for (int i = 0; i < 33000; i += 10) {
            sb.append("1234567890");
        }
        int id = BlobClobTestSetup.getID();
        PreparedStatement ps = this.prepareStatement("insert into blobclob(id, clobdata) values (?,cast(? as clob))");
        ps.setInt(1, id);
        ps.setString(2, sb.toString());
        ps.executeUpdate();
        ps.close();
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("select clobdata from blobclob where id = " + id);
        ClobTest.assertTrue((boolean)rs.next());
        Clob c = rs.getClob(1);
        BufferedReader r = new BufferedReader(c.getCharacterStream(4L, 3L));
        ClobTest.assertEquals((String)"456", (String)r.readLine());
        r.close();
        c.free();
        rs.close();
        s.close();
        this.rollback();
    }

    public void testGetCharacterStreamLongExceptionConditions() throws SQLException {
        String str1 = "This is a test String. This is a test String";
        StringReader r1 = new StringReader(str1);
        PreparedStatement ps = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setCharacterStream(2, r1);
        ps.execute();
        ps.close();
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select CLOBDATA from BLOBCLOB where ID=" + id);
        rs.next();
        Clob clob = rs.getClob(1);
        try {
            clob.getCharacterStream(-2L, 5L);
            ClobTest.fail((String)"FAIL: Expected SQLException for pos being negative not thrown");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ070", sqle);
        }
        try {
            clob.getCharacterStream(clob.length() + 1L, 5L);
            ClobTest.fail((String)"FAIL: Expected SQLException for position being greater than length of LOB not thrown");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ087", sqle);
        }
        try {
            clob.getCharacterStream(2L, -5L);
            ClobTest.fail((String)"Fail: expected exception for the length being negative not thrown");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ071", sqle);
        }
        try {
            clob.getCharacterStream(clob.length() - 4L, 10L);
            ClobTest.fail((String)"Fail: expected exception for the sum of position and length being greater than the LOB size not thrown");
        }
        catch (SQLException sqle) {
            ClobTest.assertSQLState("XJ087", sqle);
        }
    }

    public void testGetAsciiStreamCreateClob() throws Exception {
        String str = "Hi I am the insert String";
        ByteArrayInputStream str_is = new ByteArrayInputStream(str.getBytes("US-ASCII"));
        Clob clob = this.getConnection().createClob();
        InputStream is = clob.getAsciiStream();
        clob.setString(1L, str);
        ClobTest.assertEquals(str_is, is);
    }

    public void testGetCharacterStreamCreateClob() throws Exception {
        String str = "Hi I am the insert String";
        StringReader r_string = new StringReader(str);
        Clob clob = this.getConnection().createClob();
        Reader r_clob = clob.getCharacterStream();
        clob.setString(1L, str);
        ClobTest.assertEquals(r_string, r_clob);
    }

    public void testGetAsciiStreamClobUpdates() throws Exception {
        String str1 = "Hi I am the insert string";
        byte[] str1_bytes = str1.getBytes();
        String str2 = "Hi I am the update string";
        Clob clob = this.getConnection().createClob();
        InputStream is_BeforeWrite = clob.getAsciiStream();
        OutputStream os = clob.setAsciiStream(1L);
        os.write(str1_bytes);
        clob.setString(str1_bytes.length + 1, str2);
        InputStream is_AfterWrite = clob.getAsciiStream();
        ClobTest.assertEquals(is_BeforeWrite, is_AfterWrite);
    }

    public void testGetCharacterStreamClobUpdates() throws Exception {
        String str1 = "Hi I am the insert string";
        String str2 = "Hi I am the update string";
        Clob clob = this.getConnection().createClob();
        Reader r_BeforeWrite = clob.getCharacterStream();
        Writer w = clob.setCharacterStream(1L);
        char[] chars_str1 = new char[str1.length()];
        str2.getChars(0, str1.length(), chars_str1, 0);
        w.write(chars_str1);
        clob.setString(str1.length() + 1, str2);
        Reader r_AfterWrite = clob.getCharacterStream();
        ClobTest.assertEquals(r_BeforeWrite, r_AfterWrite);
    }

    public void testLockingAfterFree() throws SQLException {
        int id = this.initializeLongClob();
        this.executeParallelUpdate(id, true);
        this.clob.free();
        this.executeParallelUpdate(id, false);
        this.commit();
    }

    public void testLockingAfterFreeWithRR() throws SQLException {
        this.getConnection().setTransactionIsolation(4);
        int id = this.initializeLongClob();
        this.executeParallelUpdate(id, true);
        this.clob.free();
        this.executeParallelUpdate(id, true);
        this.commit();
        this.executeParallelUpdate(id, false);
    }

    public void testLockingAfterFreeWithDirtyReads() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        int id = this.initializeLongClob();
        this.executeParallelUpdate(id, true);
        this.clob.free();
        this.executeParallelUpdate(id, false);
        this.commit();
    }

    public void testInsertAndFetchZeroLength() throws IOException, SQLException {
        this.insertAndFetchTest(0L);
    }

    public void testInsertAndFetchVerySmall() throws IOException, SQLException {
        this.insertAndFetchTest(7L);
    }

    public void testInsertAndFetchSmall() throws IOException, SQLException {
        this.insertAndFetchTest(1587L);
    }

    public void testInsertAndFetchMedium() throws IOException, SQLException {
        this.insertAndFetchTest(32000L);
    }

    public void testInsertAndFetchMediumPlus() throws IOException, SQLException {
        this.insertAndFetchTest(64000L);
    }

    public void testInsertAndFetchLarge() throws IOException, SQLException {
        this.insertAndFetchTest(128022L);
    }

    public void testInsertAndFetchLarger() throws IOException, SQLException {
        this.insertAndFetchTest(0x300000L);
    }

    private void insertAndFetchTest(long length) throws IOException, SQLException {
        PreparedStatement ps = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(length), length);
        long tsStart = System.currentTimeMillis();
        ps.execute();
        ClobTest.println("Inserted " + length + " chars (length specified) in " + (System.currentTimeMillis() - tsStart) + " ms");
        Statement stmt = this.createStatement();
        tsStart = System.currentTimeMillis();
        ResultSet rs = stmt.executeQuery("select CLOBDATA from BLOBCLOB where id = " + id);
        ClobTest.assertTrue((String)"Clob not inserted", (boolean)rs.next());
        Clob aClob = rs.getClob(1);
        ClobTest.assertEquals((String)"Invalid length", (long)length, (long)aClob.length());
        ClobTest.println("Fetched length (" + length + ") in " + (System.currentTimeMillis() - tsStart) + " ms");
        rs.close();
        id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setCharacterStream(2, new LoopingAlphabetReader(length));
        tsStart = System.currentTimeMillis();
        ps.executeUpdate();
        ClobTest.println("Inserted " + length + " chars (length unspecified) in " + (System.currentTimeMillis() - tsStart) + " ms");
        rs = stmt.executeQuery("select CLOBDATA from BLOBCLOB where id = " + id);
        ClobTest.assertTrue((String)"Clob not inserted", (boolean)rs.next());
        aClob = rs.getClob(1);
        ClobTest.assertEquals((String)"Invalid length", (long)length, (long)aClob.length());
        ClobTest.println("Fetched length (" + length + ") in " + (System.currentTimeMillis() - tsStart) + " ms");
        rs.close();
        this.rollback();
    }

    private int initializeLongClob() throws SQLException {
        int lobLength = 40000;
        PreparedStatement ps = this.prepareStatement("insert into BLOBCLOB(ID, CLOBDATA) values(?,?)");
        int id = BlobClobTestSetup.getID();
        ps.setInt(1, id);
        ps.setCharacterStream(2, (Reader)new LoopingAlphabetReader(40000L), 40000);
        ps.execute();
        ps.close();
        this.commit();
        Statement st = this.createStatement();
        ResultSet rs = st.executeQuery("select CLOBDATA from BLOBCLOB where ID=" + id);
        rs.next();
        this.clob = rs.getClob(1);
        rs.close();
        st.close();
        return id;
    }

    private void executeParallelUpdate(int id, boolean timeoutExpected) throws SQLException {
        Connection conn2 = this.openDefaultConnection();
        Statement stmt2 = conn2.createStatement();
        try {
            stmt2.executeUpdate("update BLOBCLOB set BLOBDATA = cast(X'FFFFFF' as blob) where ID=" + id);
            stmt2.close();
            conn2.commit();
            conn2.close();
            if (timeoutExpected) {
                ClobTest.fail((String)"FAIL - should have gotten lock timeout");
            }
        }
        catch (SQLException se) {
            stmt2.close();
            conn2.rollback();
            conn2.close();
            if (timeoutExpected) {
                ClobTest.assertSQLState(LOCK_TIMEOUT, se);
            }
            throw se;
        }
    }

    public static char getLastCharInStream(Reader reader, int expectedCount) throws IOException {
        int read = 0;
        char[] buf = new char[256];
        ClobTest.assertTrue((buf.length > 0 ? 1 : 0) != 0);
        while (true) {
            int readThisTime;
            if ((readThisTime = reader.read(buf, 0, buf.length)) < 0) {
                ClobTest.assertEquals((String)"Invalid return value from stream", (int)-1, (int)readThisTime);
                ClobTest.fail((String)("Reached EOF prematurely, expected " + expectedCount + ", got " + read));
            } else if (readThisTime == 0) {
                ClobTest.fail((String)("Stream breaks contract, read zero chars: " + String.valueOf(reader)));
            }
            if ((read += readThisTime) == expectedCount) {
                return buf[readThisTime - 1];
            }
            if (read <= expectedCount) continue;
            ClobTest.fail((String)("Too many chars in stream, expected " + expectedCount + "have " + read + "(EOF not reached/confirmed)"));
        }
    }

    public static Test suite() {
        return new BlobClobTestSetup(DatabasePropertyTestSetup.setLockTimeouts(TestConfiguration.defaultSuite(ClobTest.class, false), 2, 4));
    }
}

