/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Random;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.DBFiller;
import org.apache.derbyTesting.perf.clients.Runner;

public class SequenceGeneratorConcurrency {
    public static String makeSequenceName(int sequence) {
        return "seq_" + sequence;
    }

    public static String makeTableName(int sequence, int table) {
        return "t_" + sequence + "_" + table;
    }

    public static PreparedStatement prepareStatement(Connection conn, boolean debugging, String text) throws SQLException {
        if (debugging) {
            SequenceGeneratorConcurrency.debugPrint(text);
        }
        return conn.prepareStatement(text);
    }

    public static void debugPrint(String text) {
        SequenceGeneratorConcurrency.print("DEBUG: " + text);
    }

    public static void print(String text) {
        System.out.println(text);
    }

    public static final class SGClient
    implements Client {
        private LoadOptions _loadOptions;
        private Connection _conn;
        private PreparedStatement[][] _psArray;
        private Random _randomNumberGenerator;
        private int _clientNumber = _clientCount++;
        private int _transactionCount = 0;
        private int _errorCount = 0;
        private HashMap<String, int[]> _errorLog = new HashMap();
        private static int _clientCount = 0;
        private static int _totalErrorCount = 0;
        private static int _totalTransactionCount = 0;

        public SGClient() {
            this._loadOptions = new LoadOptions();
            this._psArray = new PreparedStatement[this._loadOptions.getNumberOfGenerators()][this._loadOptions.getTablesPerGenerator() + 1];
            this._randomNumberGenerator = new Random();
            if (this._loadOptions.debugging()) {
                SequenceGeneratorConcurrency.debugPrint("Creating client " + this._clientNumber + " with " + this._loadOptions.toString());
            }
        }

        @Override
        public void init(Connection conn) throws SQLException {
            this._conn = conn;
            int numberOfGenerators = this._loadOptions.getNumberOfGenerators();
            int tablesPerGenerator = this._loadOptions.getTablesPerGenerator();
            boolean debugging = this._loadOptions.debugging();
            boolean runIdentityTest = this._loadOptions.runIdentityTest();
            for (int sequence = 0; sequence < numberOfGenerators; ++sequence) {
                String sequenceName = SequenceGeneratorConcurrency.makeSequenceName(sequence);
                for (int table = 0; table <= tablesPerGenerator; ++table) {
                    String tableName = SequenceGeneratorConcurrency.makeTableName(sequence, table);
                    String valuesClause = "values ( next value for " + sequenceName + " )";
                    PreparedStatement ps = table == 0 ? (!runIdentityTest ? SequenceGeneratorConcurrency.prepareStatement(this._conn, debugging, valuesClause) : SequenceGeneratorConcurrency.prepareStatement(this._conn, debugging, "values (1)")) : (!runIdentityTest ? SequenceGeneratorConcurrency.prepareStatement(this._conn, debugging, "insert into " + tableName + "( a ) " + valuesClause) : SequenceGeneratorConcurrency.prepareStatement(this._conn, debugging, "insert into " + tableName + "( a ) values(1)"));
                    this._psArray[sequence][table] = ps;
                }
            }
            this._conn.setAutoCommit(false);
        }

        @Override
        public void doWork() throws SQLException {
            int rowNumber;
            int sequence = this.getPositiveRandomNumber() % this._loadOptions.getNumberOfGenerators();
            int tablesPerGenerator = this._loadOptions.getTablesPerGenerator();
            int table = tablesPerGenerator == 0 ? 0 : this.getPositiveRandomNumber() % tablesPerGenerator + 1;
            int insertsPerTransaction = this._loadOptions.getInsertsPerTransaction();
            boolean debugging = this._loadOptions.debugging();
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                for (rowNumber = 0; rowNumber < insertsPerTransaction; ++rowNumber) {
                    rs = null;
                    ps = null;
                    ps = this._psArray[sequence][table];
                    if (table == 0) {
                        rs = ps.executeQuery();
                        rs.next();
                        rs = this.close(rs, debugging);
                        continue;
                    }
                    ps.executeUpdate();
                }
            }
            catch (Throwable t) {
                SequenceGeneratorConcurrency.debugPrint("Error on client " + this._clientNumber + " on sequence " + sequence + " in transaction " + this._transactionCount + " on row " + rowNumber + ": " + t.getMessage());
                this.addError(t);
                rs = this.close(rs, debugging);
                this._conn.rollback();
                return;
            }
            this._conn.commit();
            ++this._transactionCount;
        }

        private ResultSet close(ResultSet rs, boolean debugging) {
            block3: {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException se) {
                    if (!debugging) break block3;
                    SequenceGeneratorConcurrency.debugPrint("Oops! " + se.getMessage());
                }
            }
            return null;
        }

        private PreparedStatement close(PreparedStatement ps, boolean debugging) {
            block3: {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                }
                catch (SQLException se) {
                    if (!debugging) break block3;
                    SequenceGeneratorConcurrency.debugPrint("Oops! " + se.getMessage());
                }
            }
            return null;
        }

        private int getPositiveRandomNumber() {
            int raw = this._randomNumberGenerator.nextInt();
            if (raw < 0) {
                return -raw;
            }
            return raw;
        }

        @Override
        public void printReport(PrintStream out) {
            for (String key : this._errorLog.keySet()) {
                int[] value = this._errorLog.get(key);
                String message = "    Client " + this._clientNumber + " saw " + value[0] + " instances of this error: " + key;
                out.println(message);
            }
            _totalErrorCount += this._errorCount;
            _totalTransactionCount += this._transactionCount;
            if (this._clientNumber == _clientCount - 1) {
                out.println("\n");
                out.println(this._loadOptions.toString());
                out.println(_totalErrorCount + " errors, including warmup phase.");
                out.println(_totalTransactionCount + " successful transactions, including warmup phase.");
            }
        }

        private void addError(Throwable t) {
            ++this._errorCount;
            String key = t.getClass().getName() + ": " + t.getMessage();
            int[] value = this._errorLog.get(key);
            if (value != null) {
                value[0] = value[0] + 1;
            } else {
                this._errorLog.put(key, new int[]{1});
            }
        }
    }

    public static final class Filler
    implements DBFiller {
        private LoadOptions _loadOptions = new LoadOptions();

        @Override
        public void fill(Connection conn) throws SQLException {
            int numberOfGenerators = this._loadOptions.getNumberOfGenerators();
            int tablesPerGenerator = this._loadOptions.getTablesPerGenerator();
            boolean runIdentityTest = this._loadOptions.runIdentityTest();
            for (int sequence = 0; sequence < numberOfGenerators; ++sequence) {
                if (!runIdentityTest) {
                    this.runDDL(conn, "create sequence " + SequenceGeneratorConcurrency.makeSequenceName(sequence));
                }
                for (int table = 1; table <= tablesPerGenerator; ++table) {
                    if (runIdentityTest) {
                        this.runDDL(conn, "create table " + SequenceGeneratorConcurrency.makeTableName(sequence, table) + "( a int, b int generated always as identity)");
                        continue;
                    }
                    this.runDDL(conn, "create table " + SequenceGeneratorConcurrency.makeTableName(sequence, table) + "( a int )");
                }
            }
        }

        private void runDDL(Connection conn, String ddl) throws SQLException {
            PreparedStatement ps = SequenceGeneratorConcurrency.prepareStatement(conn, this._loadOptions.debugging(), ddl);
            ps.execute();
            ps.close();
        }
    }

    public static final class LoadOptions {
        private int _numberOfGenerators = Runner.getLoadOpt("numberOfGenerators", 1);
        private int _tablesPerGenerator = Runner.getLoadOpt("tablesPerGenerator", 1);
        private int _insertsPerTransaction = Runner.getLoadOpt("insertsPerTransaction", 1);
        private boolean _runIdentityTest = Runner.getLoadOpt("identityTest", 0) == 1;
        private boolean _debugging = Runner.getLoadOpt("debugging", 0) == 1;

        public int getNumberOfGenerators() {
            return this._numberOfGenerators;
        }

        public int getTablesPerGenerator() {
            return this._tablesPerGenerator;
        }

        public int getInsertsPerTransaction() {
            return this._insertsPerTransaction;
        }

        public boolean debugging() {
            return this._debugging;
        }

        public boolean runIdentityTest() {
            return this._runIdentityTest;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("LoadOptions( ");
            buffer.append(" generators = " + this._numberOfGenerators);
            buffer.append(", tablesPerGenerator = " + this._tablesPerGenerator);
            buffer.append(", insertsPerTransaction = " + this._insertsPerTransaction);
            buffer.append(", identityTest = " + this._runIdentityTest);
            buffer.append(", debugging = " + this._debugging);
            buffer.append(" )");
            return buffer.toString();
        }
    }
}

