/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.IndexInput;

class DerbyIndexInput
extends IndexInput {
    private StorageFile _file;
    private StorageRandomAccessFile _sraf;
    private final ArrayList<IndexInput> _slices = new ArrayList();
    private final long _offset;
    private final long _length;
    private boolean _closed = false;

    DerbyIndexInput(StorageFile file) throws IOException {
        this(file, file.getPath(), 0L, null);
    }

    private DerbyIndexInput(StorageFile file, String description, long offset, Long length) throws IOException {
        super(description);
        this.setConstructorFields(file);
        this._offset = offset;
        this._length = length == null ? this._sraf.length() - offset : length;
    }

    private void setConstructorFields(StorageFile file) throws IOException {
        this._file = file;
        this._sraf = this._file.getRandomAccessFile("r");
    }

    public IndexInput clone() {
        try {
            IndexInput clone = this.slice(this._file.getPath(), 0L, this._length);
            clone.seek(this.getFilePointer());
            return clone;
        }
        catch (IOException ioe) {
            throw this.wrap(ioe);
        }
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        this.checkIfClosed();
        if (offset < 0L || length < 0L || offset > this._length - length) {
            throw new IllegalArgumentException();
        }
        DerbyIndexInput slice = new DerbyIndexInput(this._file, sliceDescription, this._offset + offset, length);
        this._slices.add(slice);
        slice.seek(0L);
        return slice;
    }

    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._sraf.close();
            for (IndexInput slice : this._slices) {
                slice.close();
            }
            this._slices.clear();
            this._file = null;
            this._sraf = null;
        }
    }

    public long getFilePointer() {
        this.checkIfClosed();
        try {
            return this._sraf.getFilePointer() - this._offset;
        }
        catch (IOException ioe) {
            throw this.wrap(ioe);
        }
    }

    public long length() {
        this.checkIfClosed();
        return this._length;
    }

    public void seek(long pos) throws IOException {
        this.checkIfClosed();
        this._sraf.seek(this._offset + pos);
    }

    public byte readByte() throws IOException {
        this.checkEndOfFile(1);
        return this._sraf.readByte();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int increment;
        this.checkEndOfFile(len);
        for (int bytesRead = 0; bytesRead < len && (increment = this._sraf.read(b, offset + bytesRead, len - bytesRead)) >= 0; bytesRead += increment) {
        }
    }

    private void checkEndOfFile(int length) throws EOFException {
        long available = this._length - this.getFilePointer();
        if ((long)length > available) {
            throw new EOFException();
        }
    }

    private void checkIfClosed() {
        if (this._closed) {
            throw new AlreadyClosedException(this.toString());
        }
    }

    private RuntimeException wrap(Throwable t) {
        return new RuntimeException(t.getMessage(), t);
    }
}

