/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.stream;

import java.io.IOException;
import org.apache.torque.generator.configuration.source.EntityReferences;
import org.apache.torque.generator.source.SourceElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSourceSaxHandler
extends DefaultHandler {
    private SourceElement element;
    private SourceElement root;
    private EntityReferences entityReferences;

    public XmlSourceSaxHandler(EntityReferences entityReferences) {
        if (entityReferences == null) {
            throw new NullPointerException("entityReferences msut not be null");
        }
        this.entityReferences = entityReferences;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        SourceElement current = new SourceElement(qName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            current.setAttribute(attributes.getQName(i), (Object)attributes.getValue(i));
        }
        if (this.element != null) {
            this.element.getChildren().add(current);
        } else {
            this.root = current;
        }
        this.element = current;
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.element = this.element.getParent();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String characterData = new String(ch, start, length);
        if (this.isWhitespace(characterData)) {
            return;
        }
        String textContent = (String)this.element.getAttribute((String)null);
        textContent = textContent != null ? textContent + characterData : characterData;
        this.element.setAttribute((String)null, (Object)textContent);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.entityReferences.resolveEntity(publicId, systemId);
    }

    public SourceElement getRoot() {
        return this.root;
    }

    private boolean isWhitespace(String toCheck) {
        for (int i = 0; i < toCheck.length(); ++i) {
            char ch = toCheck.charAt(i);
            if (ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t') continue;
            return false;
        }
        return true;
    }

    public void error(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXParseException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXParseException {
        throw exception;
    }
}

