/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.pack;

import java.util.concurrent.Callable;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ThreadSafeProgressMonitor;
import org.eclipse.jgit.storage.pack.DeltaCache;
import org.eclipse.jgit.storage.pack.DeltaWindow;
import org.eclipse.jgit.storage.pack.ObjectToPack;
import org.eclipse.jgit.storage.pack.PackConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeltaTask
implements Callable<Object> {
    private final PackConfig config;
    private final ObjectReader templateReader;
    private final DeltaCache dc;
    private final ThreadSafeProgressMonitor pm;
    private final int batchSize;
    private final int start;
    private final ObjectToPack[] list;

    DeltaTask(PackConfig config, ObjectReader reader, DeltaCache dc, ThreadSafeProgressMonitor pm, int batchSize, int start, ObjectToPack[] list) {
        this.config = config;
        this.templateReader = reader;
        this.dc = dc;
        this.pm = pm;
        this.batchSize = batchSize;
        this.start = start;
        this.list = list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        ObjectReader or = this.templateReader.newReader();
        try {
            DeltaWindow dw = new DeltaWindow(this.config, this.dc, or);
            dw.search(this.pm, this.list, this.start, this.batchSize);
        }
        finally {
            or.release();
            this.pm.endWorker();
        }
        return null;
    }
}

