/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source;

import java.util.Locale;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementAttributeIterator;
import org.apache.torque.generator.source.SourceElementNodeIterator;

public class SourceElementNodePointer
extends NodePointer {
    private static final long serialVersionUID = 1L;
    private final SourceElement sourceElement;

    protected SourceElementNodePointer(SourceElement sourceElement, Locale locale) {
        super(null, locale);
        this.sourceElement = sourceElement;
    }

    protected SourceElementNodePointer(NodePointer parent, SourceElement sourceElement) {
        super(parent);
        this.sourceElement = sourceElement;
    }

    public boolean isLeaf() {
        return this.sourceElement.getChildren().isEmpty();
    }

    public boolean isCollection() {
        return true;
    }

    public int getLength() {
        NodePointer parentPointer = this.getParent();
        if (parentPointer == null) {
            return 1;
        }
        SourceElement parentInPath = (SourceElement)this.getParent().getBaseValue();
        return parentInPath.getChildren(this.sourceElement.getName()).size();
    }

    public QName getName() {
        return new QName(null, this.sourceElement.getName());
    }

    public Object getBaseValue() {
        return this.sourceElement;
    }

    public Object getImmediateNode() {
        return this.sourceElement;
    }

    public void setValue(Object value) {
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        SourceElement sourceElement2;
        SourceElement sourceElement1 = (SourceElement)pointer1.getBaseValue();
        if (sourceElement1 == (sourceElement2 = (SourceElement)pointer2.getBaseValue())) {
            return 0;
        }
        for (SourceElement child : this.sourceElement.getChildren()) {
            if (child == sourceElement1) {
                return -1;
            }
            if (child != sourceElement2) continue;
            return 1;
        }
        return 0;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return new SourceElementNodeIterator(this, test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName qname) {
        return new SourceElementAttributeIterator(this, qname);
    }

    public boolean testSourceElement(NodeTest test) {
        return SourceElementNodePointer.testSourceElement(this.sourceElement, test);
    }

    public static boolean testSourceElement(SourceElement sourceElement, NodeTest test) {
        if (test == null) {
            return true;
        }
        if (test instanceof NodeNameTest) {
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            QName testName = nodeNameTest.getNodeName();
            boolean wildcard = nodeNameTest.isWildcard();
            String testPrefix = testName.getPrefix();
            return wildcard && testPrefix == null || wildcard || testName.getName().equals(sourceElement.getName());
        }
        if (test instanceof NodeTypeTest) {
            return ((NodeTypeTest)test).getNodeType() == 1;
        }
        return false;
    }
}

