/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.source.transform;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.torque.generator.configuration.ClassHelper;
import org.apache.torque.generator.configuration.UnitConfiguration;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.processor.string.Camelbacker;
import org.apache.torque.generator.processor.string.WrapReservedJavaWords;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.generator.source.transform.model.NoSuchPropertyException;
import org.apache.torque.generator.source.transform.model.PropertyAccess;

public class SourceElementToModelTransformer
implements SourceTransformer {
    public static final String NULL_ATTRIBUTE_FIELD_NAME = "value";
    private static final Logger log = Logger.getLogger(SourceTransformer.class);
    private final Camelbacker camelbacker = new Camelbacker();
    private final WrapReservedJavaWords reservedWordsWrapper = new WrapReservedJavaWords();
    private String modelRootClass;
    private boolean ignoreUnknownAttributes = true;
    private boolean ignoreUnknownElements = true;

    public SourceElementToModelTransformer() {
        this.camelbacker.setDefaultLowerCase(false);
        this.camelbacker.setFirstCharUppercase(false);
    }

    public SourceElementToModelTransformer(Class<?> modelRootClass) {
        this();
        this.modelRootClass = modelRootClass.getName();
    }

    public void setModelRootClass(String modelRootClass) {
        this.modelRootClass = modelRootClass;
    }

    public void setIgnoreUnknownAttributes(boolean ignoreUnknownAttributes) {
        this.ignoreUnknownAttributes = ignoreUnknownAttributes;
    }

    public void setIgnoreUnknownElements(boolean ignoreUnknownElements) {
        this.ignoreUnknownElements = ignoreUnknownElements;
    }

    @Override
    public Object transform(Object modelRoot, ControllerState controllerState) throws SourceTransformerException {
        if (this.modelRootClass == null) {
            throw new SourceTransformerException("modelRootClass must not be null for the transformer of type " + this.getClass().getName());
        }
        if (!(modelRoot instanceof SourceElement)) {
            throw new SourceTransformerException("modelRoot must be of type " + SourceElement.class.getName());
        }
        Object targetModelRoot = SourceElementToModelTransformer.getInstance(this.modelRootClass, controllerState.getUnitConfiguration());
        this.fillModelElement(targetModelRoot, (SourceElement)modelRoot, controllerState.getUnitConfiguration(), new HashMap<SourceElement, Object>());
        return targetModelRoot;
    }

    private void fillModelElement(Object model, SourceElement sourceElement, UnitConfiguration unitConfiguration, Map<SourceElement, Object> alreadyMapped) throws SourceTransformerException {
        PropertyAccess propertyAccess;
        for (String attributeName : sourceElement.getAttributeNames()) {
            Object attributeValue = sourceElement.getAttribute(attributeName);
            attributeName = this.camelbacker.process(attributeName);
            if ((attributeName = this.reservedWordsWrapper.process(attributeName)) == null) {
                attributeName = NULL_ATTRIBUTE_FIELD_NAME;
            }
            if (!(propertyAccess = new PropertyAccess(model, attributeName)).isPropertyAccessible()) {
                if (!this.ignoreUnknownAttributes) {
                    throw new NoSuchPropertyException(model, attributeName, propertyAccess.getPrefixList(), propertyAccess.getSuffixList());
                }
                log.debug((Object)("Cannot set property " + attributeName + " on class " + String.valueOf(model.getClass()) + ", skipping this property."));
                continue;
            }
            propertyAccess.setProperty(attributeValue);
        }
        for (SourceElement child : sourceElement.getChildren()) {
            String propertyName = child.getName();
            propertyName = this.camelbacker.process(propertyName);
            propertyAccess = new PropertyAccess(model, propertyName = this.reservedWordsWrapper.process(propertyName));
            if (!propertyAccess.isPropertyAccessible()) {
                if (!this.ignoreUnknownElements) {
                    throw new NoSuchPropertyException(model, propertyName, propertyAccess.getPrefixList(), propertyAccess.getSuffixList());
                }
                log.debug((Object)("Cannot set property " + propertyName + " on class " + String.valueOf(model.getClass()) + ", skipping this property."));
                continue;
            }
            Object childModelElement = alreadyMapped.get(child);
            if (childModelElement != null) {
                propertyAccess.setProperty(childModelElement);
                continue;
            }
            childModelElement = Collection.class.isAssignableFrom(propertyAccess.getPropertyType()) ? SourceElementToModelTransformer.getInstance(propertyAccess.getFirstGenericTypeArgument().getName(), unitConfiguration) : (propertyAccess.getPropertyType().isArray() ? SourceElementToModelTransformer.getInstance(propertyAccess.getPropertyType().getComponentType().getName(), unitConfiguration) : SourceElementToModelTransformer.getInstance(propertyAccess.getPropertyType().getName(), unitConfiguration));
            propertyAccess.setProperty(childModelElement);
            alreadyMapped.put(child, childModelElement);
            PropertyAccess parentPropertyAccess = new PropertyAccess(childModelElement, "parent");
            if (!parentPropertyAccess.isPropertyAccessible()) {
                String modelClassName = model.getClass().getSimpleName();
                parentPropertyAccess = new PropertyAccess(childModelElement, "parent" + modelClassName);
            }
            if (parentPropertyAccess.isPropertyAccessible()) {
                parentPropertyAccess.setProperty(model);
            }
            this.fillModelElement(childModelElement, child, unitConfiguration, alreadyMapped);
        }
    }

    protected static Object getInstance(String className, UnitConfiguration unitConfiguration) throws SourceTransformerException {
        Object result;
        if (className == null) {
            return null;
        }
        try {
            ClassLoader classLoader = unitConfiguration.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassHelper.class.getClassLoader();
            }
            Class<?> clazz = Class.forName(className, true, classLoader);
            result = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new SourceTransformerException("The class " + className + " could not be found.", e);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new SourceTransformerException("Instantiating " + className + " is not allowed", e);
        }
        catch (InstantiationException e) {
            throw new SourceTransformerException("The class " + className + " has no standard constructor.", e);
        }
        return result;
    }
}

