/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.processor.string.Camelbacker;
import org.apache.torque.generator.processor.string.WrapReservedJavaWords;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.AttributeTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.TorqueSchemaIdMethod;
import org.apache.torque.templates.TorqueSchemaInheritance;
import org.apache.torque.templates.transformer.CollectAttributeSetTrueTransformer;
import org.apache.torque.templates.transformer.om.JavaFieldAttributeName;
import org.apache.torque.templates.transformer.om.OMColumnTransformer;
import org.apache.torque.templates.transformer.om.OMReferencingForeignKeyTableTransformer;
import org.apache.torque.templates.transformer.om.TableAttributeName;
import org.apache.torque.templates.transformer.om.TableChildElementName;

public class OMTableAndViewTransformer
extends AttributeTransformer {
    private static Logger log = LogManager.getLogger(OMTableAndViewTransformer.class);
    private static final String DOT = ".";
    private static OMColumnTransformer columnTransformer = new OMColumnTransformer();
    private static OMReferencingForeignKeyTableTransformer referencingForeignKeyTableTransformer = new OMReferencingForeignKeyTableTransformer();
    private static CollectAttributeSetTrueTransformer primaryKeyTransformer = new CollectAttributeSetTrueTransformer();
    private static WrapReservedJavaWords reservedJavaWordsWrapper = new WrapReservedJavaWords();

    public OMTableAndViewTransformer() throws SourceTransformerException {
        super(OMTableAndViewTransformer.getTransformerProperties());
    }

    private static Reader getTransformerProperties() {
        try {
            return new InputStreamReader(OMTableAndViewTransformer.class.getResourceAsStream("OMTableTransformer.properties"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public SourceElement transform(Object tableModel, ControllerState controllerState) throws SourceTransformerException {
        SourceElement tableElement = (SourceElement)tableModel;
        this.checkElementName(tableElement);
        this.setUnqualifiedNameAttribute(tableElement);
        OMTableAndViewTransformer.setJavaNameAttribute(tableElement, controllerState);
        this.setFieldNameAttribute(tableElement);
        this.setIdMethodAttribute(tableElement);
        this.setSequenceAttributeIfNecessary(tableElement);
        this.setBaseClass(tableElement, controllerState);
        super.transform((Object)tableElement, controllerState);
        this.setManagerClassNameAttributes(tableElement, controllerState);
        this.setPeerImplFieldNameAttribute(tableElement);
        OMTableAndViewTransformer.setPeerImplGetterAttribute(tableElement);
        this.setPeerImplSetterAttribute(tableElement);
        this.setSaveAttributes(tableElement, controllerState);
        this.createInheritanceColumnChildIfNecessary(tableElement);
        primaryKeyTransformer.transform(tableElement, controllerState, TorqueSchemaElementName.COLUMN, TorqueSchemaAttributeName.PRIMARY_KEY, TableChildElementName.PRIMARY_KEYS);
        AtomicInteger columnPosition = new AtomicInteger(1);
        for (SourceElement element : tableElement.getChildren((SourceElementName)TorqueSchemaElementName.COLUMN)) {
            columnTransformer.transform(element, controllerState, columnPosition.get());
            columnPosition.incrementAndGet();
        }
        this.setCreateDefaultDateMethodsAttributes(tableElement);
        referencingForeignKeyTableTransformer.transform(tableElement, controllerState);
        return tableElement;
    }

    private void checkElementName(SourceElement tableElement) {
        if (!TorqueSchemaElementName.TABLE.getName().equals(tableElement.getName()) && !TorqueSchemaElementName.VIEW.getName().equals(tableElement.getName())) {
            throw new IllegalArgumentException("Illegal element Name " + tableElement.getName());
        }
    }

    public static void setJavaNameAttribute(SourceElement tableElement, ControllerState controllerState) throws SourceTransformerException {
        Object javaName = tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME);
        if (javaName == null) {
            Object inputName = tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
            if (inputName == null) {
                throw new SourceTransformerException("The required attribute " + String.valueOf((Object)TorqueSchemaAttributeName.NAME) + " on element " + tableElement.getName() + " is null");
            }
            Camelbacker javaNameCamelbacker = new Camelbacker();
            javaNameCamelbacker.setRemoveWithoutUppercase("");
            javaNameCamelbacker.setRemoveWithUppercase(javaNameCamelbacker.getRemoveWithUppercase() + DOT);
            if (!controllerState.getBooleanOption((OptionName)TemplateOptionName.OM_RETAIN_SCHEMA_NAMES_IN_JAVA_NAME)) {
                javaNameCamelbacker.setIgnorePartBefore(DOT);
            }
            javaName = javaNameCamelbacker.process(inputName.toString());
            tableElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME, javaName);
        }
        log.debug("javaName: {}", javaName);
    }

    protected void setUnqualifiedNameAttribute(SourceElement tableElement) {
        String name;
        String unqualifiedName = name = (String)tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        if (StringUtils.contains((CharSequence)name, (CharSequence)DOT)) {
            unqualifiedName = name.substring(name.indexOf(DOT) + 1);
        }
        tableElement.setAttribute((SourceAttributeName)TableAttributeName.UNQUALIFIED_NAME, (Object)unqualifiedName);
    }

    protected void setIdMethodAttribute(SourceElement tableElement) throws SourceTransformerException {
        Object idMethod = tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.ID_METHOD);
        if (idMethod == null) {
            idMethod = tableElement.getParent().getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT_ID_METHOD);
            if (idMethod == null) {
                throw new SourceTransformerException("The attribute " + String.valueOf((Object)TorqueSchemaAttributeName.DEFAULT_ID_METHOD) + " is not set on the database element  and no id method is given on table " + tableElement.getName());
            }
            tableElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.ID_METHOD, idMethod);
        }
    }

    protected void setSequenceAttributeIfNecessary(SourceElement tableElement) {
        if (!TorqueSchemaIdMethod.NATIVE.getName().equals(tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.ID_METHOD))) {
            return;
        }
        List idMethodParams = tableElement.getChildren((SourceElementName)TorqueSchemaElementName.ID_METHOD_PARAMETER);
        if (idMethodParams.isEmpty() && tableElement.getAttribute((SourceAttributeName)TableAttributeName.SEQUENCE_NAME) == null) {
            tableElement.setAttribute((SourceAttributeName)TableAttributeName.SEQUENCE_NAME, (Object)((String)tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME) + "_SEQ"));
        } else {
            tableElement.setAttribute((SourceAttributeName)TableAttributeName.SEQUENCE_NAME, ((SourceElement)idMethodParams.get(0)).getAttribute(TorqueSchemaAttributeName.VALUE.getName()));
        }
    }

    protected void setManagerClassNameAttributes(SourceElement tableElement, ControllerState controllerState) throws SourceTransformerException {
        Object interfaceName = (String)tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.INTERFACE);
        if (interfaceName == null) {
            String managerClassName = controllerState.getStringOption((OptionName)TemplateOptionName.OM_MANAGER_CLASS_NAME_PREFIX) + String.valueOf(tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME)) + controllerState.getStringOption((OptionName)TemplateOptionName.OM_MANAGER_CLASS_NAME_SUFFIX);
            tableElement.setAttribute((SourceAttributeName)TableAttributeName.MANAGER_CLASS_NAME, (Object)managerClassName);
            String baseManagerClassName = controllerState.getStringOption("torque.om.className.baseManagerClassNamePrefix") + String.valueOf(tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME)) + controllerState.getStringOption("torque.om.className.baseManagerClassNameSuffix");
            tableElement.setAttribute((SourceAttributeName)TableAttributeName.BASE_MANAGER_CLASS_NAME, (Object)baseManagerClassName);
        } else {
            if (StringUtils.isBlank((CharSequence)interfaceName)) {
                throw new SourceTransformerException("The attribute " + String.valueOf((Object)TorqueSchemaAttributeName.INTERFACE) + " is blank on table " + tableElement.getName());
            }
            int dotPosition = ((String)interfaceName).lastIndexOf(DOT);
            if (dotPosition != -1) {
                interfaceName = ((String)interfaceName).substring(dotPosition + 1);
            }
            if (StringUtils.isBlank((CharSequence)interfaceName)) {
                throw new SourceTransformerException("The attribute " + String.valueOf((Object)TorqueSchemaAttributeName.INTERFACE) + " ends with a dot on table " + tableElement.getName());
            }
            interfaceName = ((String)interfaceName).length() == 1 ? ((String)interfaceName).toUpperCase() : ((String)interfaceName).substring(0, 1).toUpperCase() + ((String)interfaceName).substring(1);
            if (tableElement.getAttribute((SourceAttributeName)TableAttributeName.MANAGER_CLASS_NAME) == null) {
                String managerClassName = String.valueOf(controllerState.getOption((OptionName)TemplateOptionName.OM_MANAGER_CLASS_NAME_PREFIX)) + (String)interfaceName + String.valueOf(controllerState.getOption((OptionName)TemplateOptionName.OM_MANAGER_CLASS_NAME_SUFFIX));
                tableElement.setAttribute((SourceAttributeName)TableAttributeName.MANAGER_CLASS_NAME, (Object)managerClassName);
            }
            if (tableElement.getAttribute((SourceAttributeName)TableAttributeName.BASE_MANAGER_CLASS_NAME) == null) {
                String baseManagerClassName = String.valueOf(controllerState.getOption("torque.om.className.baseManagerClassNamePrefix")) + (String)interfaceName + String.valueOf(controllerState.getOption("torque.om.className.baseManagerClassNameSuffix"));
                tableElement.setAttribute((SourceAttributeName)TableAttributeName.BASE_MANAGER_CLASS_NAME, (Object)baseManagerClassName);
            }
        }
    }

    public void createInheritanceColumnChildIfNecessary(SourceElement tableElement) throws SourceTransformerException {
        boolean inheritanceFound = false;
        for (SourceElement columnElement : tableElement.getChildren((SourceElementName)TorqueSchemaElementName.COLUMN)) {
            if (!TorqueSchemaInheritance.SINGLE.getValue().equals(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.INHERITANCE))) continue;
            if (inheritanceFound) {
                throw new SourceTransformerException("more than one column with " + String.valueOf((Object)TorqueSchemaAttributeName.INHERITANCE) + " set to \"single\" found in table " + String.valueOf(tableElement.getAttribute(tableElement.getName())));
            }
            SourceElement inheritanceColumnElement = new SourceElement((SourceElementName)TableChildElementName.INHERITANCE_COLUMN);
            inheritanceColumnElement.getChildren().add(columnElement);
            tableElement.getChildren().add(inheritanceColumnElement);
            inheritanceFound = true;
        }
    }

    private void setBaseClass(SourceElement tableElement, ControllerState controllerState) {
        Object baseClass = tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.BASE_CLASS);
        if (baseClass == null) {
            baseClass = tableElement.getParent().getAttribute((SourceAttributeName)TorqueSchemaAttributeName.BASE_CLASS);
        }
        if (baseClass == null) {
            baseClass = controllerState.getOption((OptionName)TemplateOptionName.OM_DB_OBJECT_DEFAULT_BASE_CLASS);
        }
        if (baseClass == null) {
            baseClass = "";
        }
        tableElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.BASE_CLASS, baseClass);
    }

    protected void setFieldNameAttribute(SourceElement tableElement) {
        if (tableElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME) != null) {
            return;
        }
        String javaName = (String)tableElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME);
        String fieldName = StringUtils.uncapitalize((String)javaName);
        fieldName = reservedJavaWordsWrapper.process(fieldName);
        tableElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME, (Object)fieldName);
    }

    protected void setPeerImplFieldNameAttribute(SourceElement tableElement) {
        if (tableElement.getAttribute((SourceAttributeName)TableAttributeName.PEER_IMPL_FIELD_NAME) != null) {
            return;
        }
        String peerImplClassName = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.PEER_IMPL_CLASS_NAME);
        String fieldName = StringUtils.uncapitalize((String)peerImplClassName);
        fieldName = reservedJavaWordsWrapper.process(fieldName);
        tableElement.setAttribute((SourceAttributeName)TableAttributeName.PEER_IMPL_FIELD_NAME, (Object)fieldName);
    }

    public static void setPeerImplGetterAttribute(SourceElement tableElement) {
        if (tableElement.getAttribute((SourceAttributeName)TableAttributeName.PEER_IMPL_GETTER) != null) {
            return;
        }
        String peerImplClassName = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.PEER_IMPL_CLASS_NAME);
        Object getter = "get" + peerImplClassName;
        getter = reservedJavaWordsWrapper.process((String)getter);
        tableElement.setAttribute((SourceAttributeName)TableAttributeName.PEER_IMPL_GETTER, getter);
    }

    protected void setPeerImplSetterAttribute(SourceElement tableElement) {
        if (tableElement.getAttribute((SourceAttributeName)TableAttributeName.PEER_IMPL_SETTER) != null) {
            return;
        }
        String peerImplClassName = (String)tableElement.getAttribute((SourceAttributeName)TableAttributeName.PEER_IMPL_CLASS_NAME);
        Object setter = "set" + peerImplClassName;
        setter = reservedJavaWordsWrapper.process((String)setter);
        tableElement.setAttribute((SourceAttributeName)TableAttributeName.PEER_IMPL_SETTER, setter);
    }

    protected void setSaveAttributes(SourceElement tableElement, ControllerState controllerState) {
        String saveMethodLocationOptionName = TemplateOptionName.OM_SAVE_METHODS_IN_DB_OBJECTS.getName();
        String saveMethodLocationAttributeName = saveMethodLocationOptionName.substring(saveMethodLocationOptionName.lastIndexOf(46) + 1);
        boolean saveMethodsInDbObjects = tableElement.getAttribute(saveMethodLocationAttributeName) != null ? Boolean.parseBoolean(tableElement.getAttribute(saveMethodLocationAttributeName).toString()) : controllerState.getBooleanOption((OptionName)TemplateOptionName.OM_SAVE_METHODS_IN_DB_OBJECTS);
        if (!saveMethodsInDbObjects) {
            tableElement.setAttribute((SourceAttributeName)TableAttributeName.SAVE_METHOD_INPUT_TYPE, tableElement.getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_CLASS_NAME));
            tableElement.setAttribute((SourceAttributeName)TableAttributeName.SAVE_METHOD_TO_SAVE_VARIABLE, (Object)"toSave");
        }
    }

    protected void setCreateDefaultDateMethodsAttributes(SourceElement tableElement) {
        for (SourceElement column : tableElement.getChildren((SourceElementName)TorqueSchemaElementName.COLUMN)) {
            log.trace("column.getAttribute(JavaFieldAttributeName.FIELD_TYPE): {}", column.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_TYPE));
            log.debug("column: {}", (Object)column);
            if (!"java.util.Date".equals(column.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_TYPE))) continue;
            String defaultValue = Objects.toString(column.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT));
            if ("CURRENT_DATE".equalsIgnoreCase(defaultValue)) {
                if (tableElement.getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_DATE_METHOD_NAME) != null) continue;
                tableElement.setAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_DATE_METHOD_NAME, (Object)"getCurrentDate");
                continue;
            }
            if ("CURRENT_TIME".equalsIgnoreCase(defaultValue)) {
                if (tableElement.getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIME_METHOD_NAME) != null) continue;
                tableElement.setAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIME_METHOD_NAME, (Object)"getCurrentTime");
                continue;
            }
            if (!"CURRENT_TIMESTAMP".equalsIgnoreCase(defaultValue) || tableElement.getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIMESTAMP_METHOD_NAME) != null) continue;
            tableElement.setAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIMESTAMP_METHOD_NAME, (Object)"getCurrentTimestamp");
        }
    }
}

